/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.lambda;

import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teavm.dependency.BootstrapMethodSubstitutor;
import org.teavm.dependency.DynamicCallSite;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodHandleType;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.PrimitiveType;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.util.InvokeDynamicUtil;

public class LambdaMetafactorySubstitutor
implements BootstrapMethodSubstitutor {
    private static final int FLAG_SERIALIZABLE = 1;
    private static final int FLAG_MARKERS = 2;
    private static final int FLAG_BRIDGES = 4;
    private Map<MethodReference, Integer> lambdaIdsByMethod = new HashMap<MethodReference, Integer>();
    private Map<MethodDescriptor, MethodDescriptor> descriptorCache = new HashMap<MethodDescriptor, MethodDescriptor>();
    private List<String> fieldNameCache = new ArrayList<String>();

    public ValueEmitter substitute(DynamicCallSite callSite, ProgramEmitter callerPe) {
        int i;
        MethodReader callerMethod;
        ValueType[] invokedType = callSite.getCalledMethod().getSignature();
        ValueType[] samMethodType = ((RuntimeConstant)callSite.getBootstrapArguments().get(0)).getMethodType();
        MethodHandle implMethod = ((RuntimeConstant)callSite.getBootstrapArguments().get(1)).getMethodHandle();
        ValueType[] instantiatedMethodType = ((RuntimeConstant)callSite.getBootstrapArguments().get(2)).getMethodType();
        ValueType.Object lambdaInterfaceType = (ValueType.Object)callSite.getCalledMethod().getResultType();
        String samName = lambdaInterfaceType.getClassName();
        ClassHierarchy hierarchy = callSite.getAgent().getClassHierarchy();
        ClassReader samClass = hierarchy.getClassSource().get(samName);
        String key = callSite.getCaller().getClassName() + "$" + callSite.getCaller().getName();
        ClassReaderSource classSource = callSite.getAgent().getClassSource();
        ClassReader callerClass = classSource.get(callSite.getCaller().getClassName());
        int id = 0;
        Iterator iterator = callerClass.getMethods().iterator();
        while (iterator.hasNext() && !(callerMethod = (MethodReader)iterator.next()).getDescriptor().equals((Object)callSite.getCaller().getDescriptor())) {
            ++id;
        }
        int subId = this.lambdaIdsByMethod.getOrDefault(callSite.getCaller(), 0);
        ClassHolder implementor = new ClassHolder(key + "$lambda$_" + id + "_" + subId);
        this.lambdaIdsByMethod.put(callSite.getCaller(), subId + 1);
        implementor.setLevel(AccessLevel.PUBLIC);
        if (samClass != null && samClass.hasModifier(ElementModifier.INTERFACE)) {
            implementor.setParent("java.lang.Object");
            implementor.getInterfaces().add(samName);
        } else {
            implementor.setParent(samName);
        }
        int capturedVarCount = callSite.getCalledMethod().parameterCount();
        MethodHolder ctor = this.createConstructor(hierarchy, implementor, Arrays.copyOfRange(invokedType, 0, capturedVarCount), callerPe.getCurrentLocation());
        this.createBridge(hierarchy, implementor, callSite.getCalledMethod().getName(), instantiatedMethodType, samMethodType, callerPe.getCurrentLocation());
        MethodHolder worker = new MethodHolder(callSite.getCalledMethod().getName(), instantiatedMethodType);
        worker.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)worker, (ClassHierarchy)callSite.getAgent().getClassHierarchy());
        pe.setCurrentLocation(callerPe.getCurrentLocation());
        ValueEmitter thisVar = pe.var(0, (ClassReader)implementor);
        ValueEmitter[] arguments = new ValueEmitter[instantiatedMethodType.length - 1];
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            arguments[i2] = pe.var(i2 + 1, instantiatedMethodType[i2]);
        }
        ValueType[] implementorSignature = this.getSignature(implMethod);
        ValueEmitter[] passedArguments = new ValueEmitter[implementorSignature.length - 1];
        for (i = 0; i < capturedVarCount; ++i) {
            passedArguments[i] = thisVar.getField(this.fieldName(i), invokedType[i]);
        }
        for (i = 0; i < instantiatedMethodType.length - 1; ++i) {
            passedArguments[i + capturedVarCount] = this.tryConvertArgument(arguments[i], instantiatedMethodType[i], implementorSignature[i + capturedVarCount]);
        }
        ValueEmitter result = InvokeDynamicUtil.invoke((ProgramEmitter)pe, (MethodHandle)implMethod, (ValueEmitter[])passedArguments);
        ValueType expectedResult = instantiatedMethodType[instantiatedMethodType.length - 1];
        if (result != null && expectedResult != ValueType.VOID) {
            ValueType actualResult = implementorSignature[implementorSignature.length - 1];
            this.tryConvertArgument(result, actualResult, expectedResult).returnValue();
        } else {
            pe.exit();
        }
        implementor.addMethod(worker);
        if (callSite.getBootstrapArguments().size() > 3) {
            int i3;
            int flags = ((RuntimeConstant)callSite.getBootstrapArguments().get(3)).getInt();
            if ((flags & 1) != 0) {
                implementor.getInterfaces().add("java.io.Serializable");
                String functionInterfaceMethodName = callSite.getCalledMethod().getName();
                LambdaMetafactorySubstitutor.addWriteReplaceMethod(callerPe.getCurrentLocation(), hierarchy, implementor, ValueType.object((String)callSite.getCaller().getClassName()), lambdaInterfaceType, new MethodDescriptor(functionInterfaceMethodName, samMethodType), implMethod.getKind(), ValueType.object((String)implMethod.getClassName()), new MethodDescriptor(implMethod.getName(), implMethod.signature()), new MethodDescriptor(functionInterfaceMethodName, instantiatedMethodType));
            }
            int bootstrapArgIndex = 4;
            if ((flags & 2) != 0) {
                int markerCount = ((RuntimeConstant)callSite.getBootstrapArguments().get(bootstrapArgIndex++)).getInt();
                for (i3 = 0; i3 < markerCount; ++i3) {
                    ValueType markerType = ((RuntimeConstant)callSite.getBootstrapArguments().get(bootstrapArgIndex++)).getValueType();
                    implementor.getInterfaces().add(((ValueType.Object)markerType).getClassName());
                }
            }
            if ((flags & 4) != 0) {
                int bridgeCount = ((RuntimeConstant)callSite.getBootstrapArguments().get(bootstrapArgIndex++)).getInt();
                for (i3 = 0; i3 < bridgeCount; ++i3) {
                    ValueType[] bridgeType = ((RuntimeConstant)callSite.getBootstrapArguments().get(bootstrapArgIndex++)).getMethodType();
                    this.createBridge(hierarchy, implementor, callSite.getCalledMethod().getName(), instantiatedMethodType, bridgeType, callerPe.getCurrentLocation());
                }
            }
        }
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add(callSite.getCaller().getClassName());
        dependencies.addAll(implementor.getInterfaces());
        if (!implementor.getParent().equals("java.lang.Object")) {
            dependencies.add(implementor.getParent());
        }
        callSite.getAgent().submitClass(implementor);
        callSite.getAgent().getIncrementalCache().addDependencies(implementor.getName(), dependencies.toArray(new String[0]));
        return callerPe.construct(ctor.getOwnerName(), callSite.getArguments().toArray(new ValueEmitter[0]));
    }

    private ValueEmitter tryConvertArgument(ValueEmitter arg, ValueType from, ValueType to) {
        if (from.equals(to)) {
            return arg;
        }
        if (from instanceof ValueType.Primitive && to instanceof ValueType.Primitive) {
            return arg.cast(to);
        }
        if (from instanceof ValueType.Primitive && to instanceof ValueType.Object) {
            String primitiveClass = ((ValueType.Object)to).getClassName();
            PrimitiveType toType = this.getWrappedPrimitive(primitiveClass);
            if (toType == null) {
                return arg;
            }
            arg = this.tryConvertArgument(arg, from, ValueType.primitive((PrimitiveType)toType));
            return arg.getProgramEmitter().invoke(primitiveClass, "valueOf", to, new ValueEmitter[]{arg});
        }
        if (from instanceof ValueType.Object && to instanceof ValueType.Primitive) {
            String primitiveClass = ((ValueType.Object)from).getClassName();
            PrimitiveType fromType = this.getWrappedPrimitive(primitiveClass);
            if (fromType == null) {
                return arg;
            }
            arg = arg.invokeVirtual(this.primitiveName(fromType) + "Value", ValueType.primitive((PrimitiveType)fromType), new ValueEmitter[0]);
            return this.tryConvertArgument(arg, ValueType.primitive((PrimitiveType)fromType), to);
        }
        return arg.cast(to);
    }

    private PrimitiveType getWrappedPrimitive(String name) {
        switch (name) {
            case "java.lang.Boolean": {
                return PrimitiveType.BOOLEAN;
            }
            case "java.lang.Byte": {
                return PrimitiveType.BYTE;
            }
            case "java.lang.Short": {
                return PrimitiveType.SHORT;
            }
            case "java.lang.Character": {
                return PrimitiveType.CHARACTER;
            }
            case "java.lang.Integer": {
                return PrimitiveType.INTEGER;
            }
            case "java.lang.Long": {
                return PrimitiveType.LONG;
            }
            case "java.lang.Float": {
                return PrimitiveType.FLOAT;
            }
            case "java.lang.Double": {
                return PrimitiveType.DOUBLE;
            }
        }
        return null;
    }

    private String primitiveName(PrimitiveType type) {
        switch (type) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case SHORT: {
                return "short";
            }
            case CHARACTER: {
                return "char";
            }
            case INTEGER: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
        }
        throw new IllegalArgumentException("Unexpected primitive " + String.valueOf(type));
    }

    private ValueType[] getSignature(MethodHandle handle) {
        switch (handle.getKind()) {
            case GET_FIELD: {
                return new ValueType[]{ValueType.object((String)handle.getClassName()), handle.getValueType()};
            }
            case GET_STATIC_FIELD: {
                return new ValueType[]{handle.getValueType()};
            }
            case PUT_FIELD: {
                return new ValueType[]{ValueType.object((String)handle.getClassName()), handle.getValueType(), ValueType.VOID};
            }
            case PUT_STATIC_FIELD: {
                return new ValueType[]{handle.getValueType(), ValueType.VOID};
            }
            case INVOKE_VIRTUAL: 
            case INVOKE_INTERFACE: 
            case INVOKE_SPECIAL: {
                ValueType[] signature = handle.signature();
                ValueType[] result = new ValueType[signature.length + 1];
                System.arraycopy(signature, 0, result, 1, signature.length);
                result[0] = ValueType.object((String)handle.getClassName());
                return result;
            }
        }
        return handle.signature();
    }

    private MethodHolder createConstructor(ClassHierarchy hierarchy, ClassHolder implementor, ValueType[] types, TextLocation location) {
        ValueType[] signature = Arrays.copyOf(types, types.length + 1);
        signature[types.length] = ValueType.VOID;
        MethodDescriptor descriptor = this.descriptorCache.computeIfAbsent(new MethodDescriptor("<init>", signature), k -> k);
        MethodHolder ctor = new MethodHolder(descriptor);
        ctor.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)ctor, (ClassHierarchy)hierarchy);
        pe.setCurrentLocation(location);
        ValueEmitter thisVar = pe.var(0, (ClassReader)implementor);
        thisVar.invokeSpecial(implementor.getParent(), "<init>", new ValueEmitter[0]);
        for (int i = 0; i < types.length; ++i) {
            FieldHolder field = new FieldHolder(this.fieldName(i));
            field.setLevel(AccessLevel.PRIVATE);
            field.setType(types[i]);
            implementor.addField(field);
            thisVar.setField(field.getName(), pe.var(i + 1, types[i]));
        }
        pe.exit();
        implementor.addMethod(ctor);
        return ctor;
    }

    private String fieldName(int index) {
        Object result;
        if (index >= this.fieldNameCache.size()) {
            this.fieldNameCache.addAll(Collections.nCopies(index - this.fieldNameCache.size() + 1, null));
        }
        if ((result = this.fieldNameCache.get(index)) == null) {
            result = "_" + index;
            this.fieldNameCache.set(index, (String)result);
        }
        return result;
    }

    private void createBridge(ClassHierarchy hierarchy, ClassHolder implementor, String name, ValueType[] types, ValueType[] bridgeTypes, TextLocation location) {
        int i;
        if (Arrays.equals(types, bridgeTypes)) {
            return;
        }
        MethodHolder bridge = new MethodHolder(name, bridgeTypes);
        bridge.setLevel(AccessLevel.PUBLIC);
        bridge.getModifiers().add(ElementModifier.BRIDGE);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)bridge, (ClassHierarchy)hierarchy);
        pe.setCurrentLocation(location);
        ValueEmitter thisVar = pe.var(0, (ClassReader)implementor);
        ValueEmitter[] arguments = new ValueEmitter[bridgeTypes.length - 1];
        for (i = 0; i < arguments.length; ++i) {
            arguments[i] = pe.var(i + 1, bridgeTypes[i]);
        }
        for (i = 0; i < bridgeTypes.length - 1; ++i) {
            ValueType type = types[i];
            ValueType bridgeType = bridgeTypes[i];
            if (type.equals(bridgeType)) continue;
            arguments[i] = arguments[i].cast(type);
        }
        ValueEmitter result = thisVar.invokeSpecial(name, types[types.length - 1], arguments);
        if (result != null) {
            if (!types[types.length - 1].equals(bridgeTypes[bridgeTypes.length - 1])) {
                result = result.cast(bridgeTypes[bridgeTypes.length - 1]);
            }
            result.returnValue();
        } else {
            pe.exit();
        }
        implementor.addMethod(bridge);
    }

    private static void addWriteReplaceMethod(TextLocation location, ClassHierarchy classHierarchy, ClassHolder lambdaClassDefinition, ValueType.Object capturingClass, ValueType.Object functionalInterfaceClass, MethodDescriptor functionalInterfaceMethodDescriptor, MethodHandleType implMethodKind, ValueType.Object implClass, MethodDescriptor implMethodDescriptor, MethodDescriptor instantiatedMethodDescriptor) {
        MethodHolder writeReplace = new MethodHolder("writeReplace", new ValueType[]{new ValueType.Object(SerializedLambda.class.getName())});
        writeReplace.setLevel(AccessLevel.PRIVATE);
        writeReplace.getModifiers().add(ElementModifier.FINAL);
        ProgramEmitter programEmitter = ProgramEmitter.create((MethodHolder)writeReplace, (ClassHierarchy)classHierarchy);
        programEmitter.setCurrentLocation(location);
        Collection fields = lambdaClassDefinition.getFields();
        ValueEmitter capturedParametersArray = programEmitter.constructArray(Object.class, fields.size());
        ValueEmitter lambdaThis = programEmitter.var(0, (ClassReader)lambdaClassDefinition);
        int index = 0;
        for (FieldHolder fieldHolder : fields) {
            ValueType fieldType = fieldHolder.getType();
            ValueEmitter fieldValue = lambdaThis.getField(fieldHolder.getName(), fieldType);
            if (fieldType instanceof ValueType.Primitive) {
                fieldValue = fieldValue.cast((ValueType)((ValueType.Primitive)fieldType).getBoxedType());
            }
            capturedParametersArray.setElement(index++, fieldValue);
        }
        ValueEmitter newSerializedLambda = programEmitter.construct(SerializedLambda.class, new ValueEmitter[]{programEmitter.constant((ValueType)capturingClass), programEmitter.constant(functionalInterfaceClass.getClassName().replace('.', '/')), programEmitter.constant(functionalInterfaceMethodDescriptor.getName()), programEmitter.constant(functionalInterfaceMethodDescriptor.signatureToString()), programEmitter.constant(implMethodKind.getReferenceKind()), programEmitter.constant(implClass.getClassName().replace('.', '/')), programEmitter.constant(implMethodDescriptor.getName()), programEmitter.constant(implMethodDescriptor.signatureToString()), programEmitter.constant(instantiatedMethodDescriptor.signatureToString()), capturedParametersArray});
        newSerializedLambda.returnValue();
        lambdaClassDefinition.addMethod(writeReplace);
    }
}

