/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import org.teavm.backend.wasm.runtime.WasmSupport;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.TLongStream;
import org.teavm.classlib.java.util.stream.doubleimpl.TSimpleDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TSimpleIntStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamImpl;
import org.teavm.interop.Import;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSBody;

public class TRandom
extends TObject
implements TSerializable {
    private double storedGaussian;
    private boolean haveStoredGaussian;

    public TRandom() {
    }

    public TRandom(long seed) {
    }

    public void setSeed(long seed) {
    }

    protected int next(int bits) {
        if (bits == 32) {
            return (int)(this.nextDouble() * 4.294967295E9 + -2.147483648E9);
        }
        return (int)(this.nextDouble() * (double)(1L << TMath.min(32, bits)));
    }

    public void nextBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.next(8);
        }
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return (int)(this.nextDouble() * (double)n);
    }

    public int nextInt(int origin, int bound) {
        int value;
        if (origin >= bound) {
            throw new IllegalArgumentException();
        }
        int range = bound - origin;
        if (range > 0) {
            return this.nextInt(range) + origin;
        }
        while ((value = this.nextInt()) < origin || value >= bound) {
        }
        return value;
    }

    public long nextLong() {
        return (long)this.nextInt() << 32 | (long)this.nextInt();
    }

    public long nextLong(long bound) {
        long result;
        long value;
        if (bound <= 0L) {
            throw new IllegalArgumentException();
        }
        while ((value = this.nextLong()) - (result = value % bound) + (bound - 1L) >= 0L) {
        }
        return result;
    }

    public long nextLong(long origin, long bound) {
        long value;
        if (origin >= bound) {
            throw new IllegalArgumentException();
        }
        long range = bound - origin;
        if (range > 0L) {
            return this.nextLong(range) + origin;
        }
        while ((value = this.nextLong()) < origin || value >= bound) {
        }
        return value;
    }

    public boolean nextBoolean() {
        return this.nextInt() % 2 == 0;
    }

    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public float nextFloat(float bound) {
        return (float)this.nextDouble(bound);
    }

    public float nextFloat(float origin, float bound) {
        return (float)this.nextDouble(origin, bound);
    }

    public double nextDouble() {
        if (PlatformDetector.isC()) {
            return TRandom.crand();
        }
        if (PlatformDetector.isWebAssembly()) {
            return WasmSupport.random();
        }
        return TRandom.random();
    }

    public double nextDouble(double bound) {
        if (bound <= 0.0) {
            throw new IllegalArgumentException();
        }
        double value = this.nextDouble() * bound;
        if (value == bound) {
            value = Math.nextDown(value);
        }
        return value;
    }

    public double nextDouble(double origin, double bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException();
        }
        return origin + this.nextDouble(bound - origin);
    }

    @Import(name="teavm_rand")
    @Unmanaged
    private static native double crand();

    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveStoredGaussian) {
            this.haveStoredGaussian = false;
            return this.storedGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double m = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.storedGaussian = v2 * m;
        this.haveStoredGaussian = true;
        return v1 * m;
    }

    @JSBody(script="return Math.random();")
    @Import(module="teavmMath", name="random")
    @Unmanaged
    private static native double random();

    public TIntStream ints(final long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        return new TSimpleIntStreamImpl(){
            private long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(IntPredicate consumer) {
                while (this.remaining > 0L) {
                    --this.remaining;
                    if (consumer.test(TRandom.this.nextInt())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TIntStream ints() {
        return new TSimpleIntStreamImpl(){

            @Override
            public boolean next(IntPredicate consumer) {
                while (consumer.test(TRandom.this.nextInt())) {
                }
                return true;
            }
        };
    }

    public TIntStream ints(final long streamSize, final int randomNumberOrigin, final int randomNumberBound) {
        if (streamSize < 0L || randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final int range = randomNumberBound - randomNumberOrigin;
        if (range > 0) {
            return new TSimpleIntStreamImpl(){
                long remaining;
                {
                    this.remaining = streamSize;
                }

                @Override
                public boolean next(IntPredicate consumer) {
                    while (this.remaining > 0L) {
                        --this.remaining;
                        if (consumer.test(TRandom.this.nextInt(range) + randomNumberOrigin)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new TSimpleIntStreamImpl(){
            long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(IntPredicate consumer) {
                while (this.remaining > 0L) {
                    int n;
                    --this.remaining;
                    while ((n = TRandom.this.nextInt()) < randomNumberOrigin || n >= randomNumberBound) {
                    }
                    if (consumer.test(n)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TIntStream ints(final int randomNumberOrigin, final int randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final int range = randomNumberBound - randomNumberOrigin;
        if (range > 0) {
            return new TSimpleIntStreamImpl(){

                @Override
                public boolean next(IntPredicate consumer) {
                    while (consumer.test(TRandom.this.nextInt(range) + randomNumberOrigin)) {
                    }
                    return true;
                }
            };
        }
        return new TSimpleIntStreamImpl(){

            @Override
            public boolean next(IntPredicate consumer) {
                int n;
                while ((n = TRandom.this.nextInt()) < randomNumberOrigin || n >= randomNumberBound || consumer.test(n)) {
                }
                return true;
            }
        };
    }

    public TLongStream longs(final long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        return new TSimpleLongStreamImpl(){
            private long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(LongPredicate consumer) {
                while (this.remaining > 0L) {
                    --this.remaining;
                    if (consumer.test(TRandom.this.nextLong())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TLongStream longs() {
        return new TSimpleLongStreamImpl(){

            @Override
            public boolean next(LongPredicate consumer) {
                while (consumer.test(TRandom.this.nextLong())) {
                }
                return true;
            }
        };
    }

    public TLongStream longs(final long streamSize, final long randomNumberOrigin, final long randomNumberBound) {
        if (streamSize < 0L || randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final long range = randomNumberBound - randomNumberOrigin;
        if (range > 0L) {
            return new TSimpleLongStreamImpl(){
                long remaining;
                {
                    this.remaining = streamSize;
                }

                @Override
                public boolean next(LongPredicate consumer) {
                    while (this.remaining > 0L) {
                        --this.remaining;
                        if (consumer.test(TRandom.this.nextLong(range) + randomNumberOrigin)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new TSimpleLongStreamImpl(){
            long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(LongPredicate consumer) {
                while (this.remaining > 0L) {
                    long n;
                    --this.remaining;
                    while ((n = TRandom.this.nextLong()) < randomNumberOrigin || n >= randomNumberBound) {
                    }
                    if (consumer.test(n)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TLongStream longs(final long randomNumberOrigin, final long randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final long range = randomNumberBound - randomNumberOrigin;
        if (range > 0L) {
            return new TSimpleLongStreamImpl(){

                @Override
                public boolean next(LongPredicate consumer) {
                    while (consumer.test(TRandom.this.nextLong(range) + randomNumberOrigin)) {
                    }
                    return true;
                }
            };
        }
        return new TSimpleLongStreamImpl(){

            @Override
            public boolean next(LongPredicate consumer) {
                long n;
                while ((n = TRandom.this.nextLong()) < randomNumberOrigin || n >= randomNumberBound || consumer.test(n)) {
                }
                return true;
            }
        };
    }

    public TDoubleStream doubles(final long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        return new TSimpleDoubleStreamImpl(){
            private long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(DoublePredicate consumer) {
                while (this.remaining > 0L) {
                    --this.remaining;
                    if (consumer.test(TRandom.this.nextDouble())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TDoubleStream doubles() {
        return new TSimpleDoubleStreamImpl(){

            @Override
            public boolean next(DoublePredicate consumer) {
                while (consumer.test(TRandom.this.nextDouble())) {
                }
                return true;
            }
        };
    }

    public TDoubleStream doubles(final long streamSize, final double randomNumberOrigin, double randomNumberBound) {
        if (streamSize < 0L || randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final double range = randomNumberBound - randomNumberOrigin;
        return new TSimpleDoubleStreamImpl(){
            long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(DoublePredicate consumer) {
                while (this.remaining > 0L) {
                    --this.remaining;
                    if (consumer.test(TRandom.this.nextDouble() * range + randomNumberOrigin)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TDoubleStream doubles(final double randomNumberOrigin, double randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final double range = randomNumberBound - randomNumberOrigin;
        return new TSimpleDoubleStreamImpl(){

            @Override
            public boolean next(DoublePredicate consumer) {
                while (consumer.test(TRandom.this.nextDouble() * range + randomNumberOrigin)) {
                }
                return true;
            }
        };
    }
}

