/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.function.Supplier;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.classlib.java.util.TComparator;

public final class TObjects
extends TObject {
    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        return a == null ? b == null : a.equals(b);
    }

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static String toString(Object o) {
        return TObjects.toString(o, "null");
    }

    public static String toString(Object o, String nullDefault) {
        return o != null ? o.toString() : nullDefault;
    }

    public static <T> int compare(T a, T b, TComparator<? super T> c) {
        return a == null && b == null ? 0 : c.compare(a, b);
    }

    public static <T> T requireNonNull(T obj) {
        return TObjects.requireNonNull(obj, "");
    }

    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, Supplier<String> messageSupplier) {
        if (obj == null) {
            throw new NullPointerException(messageSupplier.get());
        }
        return obj;
    }

    public static <T> T requireNonNullElse(T obj, T defaultObj) {
        return obj != null ? obj : TObjects.requireNonNull(defaultObj);
    }

    public static <T> T requireNonNullElseGet(T obj, Supplier<? extends T> supplier) {
        return obj != null ? obj : TObjects.requireNonNull(supplier.get());
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean nonNull(Object obj) {
        return obj != null;
    }

    public static boolean deepEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return b == null;
        }
        if (a instanceof boolean[]) {
            return b instanceof boolean[] && TArrays.equals((boolean[])a, (boolean[])b);
        }
        if (b instanceof boolean[]) {
            return false;
        }
        if (a instanceof byte[]) {
            return b instanceof byte[] && TArrays.equals((byte[])a, (byte[])b);
        }
        if (b instanceof byte[]) {
            return false;
        }
        if (a instanceof short[]) {
            return b instanceof short[] && TArrays.equals((short[])a, (short[])b);
        }
        if (b instanceof short[]) {
            return false;
        }
        if (a instanceof int[]) {
            return b instanceof int[] && TArrays.equals((int[])a, (int[])b);
        }
        if (b instanceof int[]) {
            return false;
        }
        if (a instanceof char[]) {
            return b instanceof char[] && TArrays.equals((char[])a, (char[])b);
        }
        if (b instanceof char[]) {
            return false;
        }
        if (a instanceof float[]) {
            return b instanceof float[] && TArrays.equals((float[])a, (float[])b);
        }
        if (b instanceof float[]) {
            return false;
        }
        if (a instanceof double[]) {
            return b instanceof double[] && TArrays.equals((double[])a, (double[])b);
        }
        if (b instanceof double[]) {
            return false;
        }
        if (a instanceof Object[]) {
            return b instanceof Object[] && TArrays.deepEquals((Object[])a, (Object[])b);
        }
        if (b instanceof Object[]) {
            return false;
        }
        return a.equals(b);
    }

    public static int hash(Object ... values) {
        return TArrays.hashCode(values);
    }

    public static int checkIndex(int index, int length) {
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException();
        }
        return index;
    }

    public static int checkFromToIndex(int fromIndex, int toIndex, int length) {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > length) {
            throw new IndexOutOfBoundsException();
        }
        return fromIndex;
    }

    public static int checkFromIndexSize(int fromIndex, int size, int length) {
        if (fromIndex < 0 || size < 0 || fromIndex + size > length) {
            throw new IndexOutOfBoundsException();
        }
        return fromIndex;
    }
}

