/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import java.util.ArrayList;
import java.util.List;
import org.teavm.classlib.java.text.TDateFormatElement;
import org.teavm.classlib.java.text.TDateFormatSymbols;
import org.teavm.classlib.java.util.TLocale;

class TSimpleDatePatternParser {
    private TDateFormatSymbols symbols;
    private TLocale locale;
    private List<TDateFormatElement> elements = new ArrayList<TDateFormatElement>();
    private int index;
    private String pattern;

    public TSimpleDatePatternParser(TDateFormatSymbols symbols, TLocale locale) {
        this.symbols = symbols;
        this.locale = locale;
    }

    public List<TDateFormatElement> getElements() {
        return this.elements;
    }

    public void parsePattern(String pattern) {
        this.elements.clear();
        this.pattern = pattern;
        this.index = 0;
        block24: while (this.index < pattern.length()) {
            char c = pattern.charAt(this.index);
            switch (c) {
                case '\'': {
                    ++this.index;
                    this.parseQuoted();
                    continue block24;
                }
                case 'G': {
                    this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.EraText(this.symbols));
                    continue block24;
                }
                case 'Y': 
                case 'y': {
                    int rep = this.parseRepetitions();
                    if (rep == 2) {
                        this.elements.add(new TDateFormatElement.Year(1));
                        continue block24;
                    }
                    this.elements.add(new TDateFormatElement.Numeric(1, rep, 8));
                    continue block24;
                }
                case 'L': 
                case 'M': {
                    int rep = this.parseRepetitions();
                    if (rep <= 2) {
                        this.elements.add(new TDateFormatElement.NumericMonth(rep));
                        continue block24;
                    }
                    this.elements.add(new TDateFormatElement.MonthText(this.symbols, rep == 3));
                    continue block24;
                }
                case 'w': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Numeric(3, rep, 2));
                    continue block24;
                }
                case 'W': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Numeric(4, rep, 1));
                    continue block24;
                }
                case 'D': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Numeric(6, rep, 3));
                    continue block24;
                }
                case 'd': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Numeric(5, rep, 2));
                    continue block24;
                }
                case 'F': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Numeric(8, rep, 2));
                    continue block24;
                }
                case 'E': 
                case 'c': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.WeekdayText(this.symbols, rep <= 3));
                    continue block24;
                }
                case 'u': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.NumericWeekday(rep));
                    continue block24;
                }
                case 'a': {
                    this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.AmPmText(this.symbols));
                    continue block24;
                }
                case 'H': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Numeric(11, rep, 2));
                    continue block24;
                }
                case 'k': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.NumericHour(11, rep, 24));
                    continue block24;
                }
                case 'K': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Numeric(10, rep, 2));
                    continue block24;
                }
                case 'h': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.NumericHour(10, rep, 12));
                    continue block24;
                }
                case 'm': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Numeric(12, rep, 2));
                    continue block24;
                }
                case 's': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Numeric(13, rep, 2));
                    continue block24;
                }
                case 'S': {
                    int rep = this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Numeric(14, rep, 3));
                    continue block24;
                }
                case 'z': {
                    this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.GeneralTimezone(this.locale));
                    continue block24;
                }
                case 'Z': {
                    this.parseRepetitions();
                    this.elements.add(new TDateFormatElement.Rfc822Timezone(this.locale));
                    continue block24;
                }
                case 'X': {
                    int rep = this.parseRepetitions();
                    if (rep > 3) {
                        throw new IllegalArgumentException("Wrong number of repetitions of X pattern at " + this.index);
                    }
                    this.elements.add(new TDateFormatElement.Iso8601Timezone(rep));
                    continue block24;
                }
            }
            if (this.isControl(c)) {
                this.parseRepetitions();
                continue;
            }
            StringBuilder sb = new StringBuilder();
            while (this.index < pattern.length() && !this.isControl(pattern.charAt(this.index))) {
                sb.append(pattern.charAt(this.index++));
            }
            this.elements.add(new TDateFormatElement.ConstantText(sb.toString()));
        }
    }

    private boolean isControl(char c) {
        return c == '\'' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private void parseQuoted() {
        StringBuilder sb = new StringBuilder();
        while (this.index < this.pattern.length()) {
            char c;
            if ((c = this.pattern.charAt(this.index++)) == '\'') {
                if (this.index >= this.pattern.length() || this.pattern.charAt(this.index) != '\'') break;
                sb.append('\'');
                ++this.index;
                continue;
            }
            sb.append(c);
        }
        this.elements.add(new TDateFormatElement.ConstantText(sb.toString()));
    }

    private int parseRepetitions() {
        int count = 1;
        char orig = this.pattern.charAt(this.index++);
        while (this.index < this.pattern.length() && this.pattern.charAt(this.index) == orig) {
            ++this.index;
            ++count;
        }
        return count;
    }
}

