/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teavm.classlib.java.util.TObjects;
import org.teavm.classlib.java.util.stream.TCollector;
import org.teavm.classlib.java.util.stream.TCollectorImpl;

public final class TCollectors {
    private TCollectors() {
    }

    public static <T, C extends Collection<T>> TCollector<T, ?, C> toCollection(Supplier<C> collectionFactory) {
        return TCollector.of(collectionFactory, Collection::add, (a, b) -> {
            a.addAll(b);
            return a;
        }, new TCollector.Characteristics[0]);
    }

    public static <T> TCollector<T, ?, List<T>> toList() {
        return TCollectors.toCollection(ArrayList::new);
    }

    public static <T> TCollector<T, ?, List<T>> toUnmodifiableList() {
        return TCollectors.collectingAndThen(TCollectors.toList(), Collections::unmodifiableList);
    }

    public static <T> TCollector<T, ?, Set<T>> toSet() {
        return TCollectors.toCollection(HashSet::new);
    }

    public static TCollector<CharSequence, ?, String> joining() {
        return TCollector.of(StringBuilder::new, StringBuilder::append, StringBuilder::append, StringBuilder::toString, new TCollector.Characteristics[0]);
    }

    public static TCollector<CharSequence, ?, String> joining(CharSequence delimiter) {
        return TCollectors.joining(delimiter, "", "");
    }

    public static TCollector<CharSequence, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        BiConsumer<StringBuilder, CharSequence> accumulator = (sb, item) -> {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append((CharSequence)item);
        };
        BinaryOperator combiner = (a, b) -> {
            if (a.length() > 0) {
                a.append(delimiter);
            }
            return a.append((CharSequence)b);
        };
        return TCollector.of(StringBuilder::new, accumulator, combiner, sb -> sb.insert(0, prefix).append(suffix).toString(), new TCollector.Characteristics[0]);
    }

    public static <E, K, V> TCollector<E, ?, Map<K, V>> toMap(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper) {
        return TCollector.of(HashMap::new, (map, el) -> {
            Object newV;
            Object k = keyMapper.apply((Object)el);
            Object oldV = map.putIfAbsent(k, newV = TObjects.requireNonNull(valueMapper.apply((Object)el)));
            if (oldV != null) {
                throw new IllegalStateException("Key " + k + " corresponds to values " + oldV + " and " + newV);
            }
        }, (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                Object newV = TObjects.requireNonNull(e.getValue());
                Object oldV = m1.putIfAbsent(e.getKey(), newV);
                if (oldV == null) continue;
                throw new IllegalStateException("Key " + e.getKey() + " corresponds to values " + oldV + " and " + newV);
            }
            return m1;
        }, TCollector.Characteristics.IDENTITY_FINISH);
    }

    public static <E, K, V> TCollector<E, ?, Map<K, V>> toMap(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        return TCollectors.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    public static <E, K, V, M extends Map<K, V>> TCollector<E, ?, M> toMap(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<M> mapFactory) {
        return TCollector.of(mapFactory, (map, el) -> map.merge(keyMapper.apply((Object)el), valueMapper.apply((Object)el), mergeFunction), (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        }, TCollector.Characteristics.IDENTITY_FINISH);
    }

    public static <T, A, R, K> TCollector<T, A, K> collectingAndThen(TCollector<T, A, R> downstream, Function<R, K> finisher) {
        EnumSet<TCollector.Characteristics> newCharacteristics = EnumSet.copyOf(downstream.characteristics());
        newCharacteristics.remove((Object)TCollector.Characteristics.IDENTITY_FINISH);
        return new TCollectorImpl<T, A, K>(downstream.supplier(), downstream.accumulator(), downstream.combiner(), downstream.finisher().andThen(finisher), newCharacteristics);
    }
}

