/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.backend.wasm.runtime.WasmSupport;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.MathNativeGenerator;
import org.teavm.classlib.java.lang.TDouble;
import org.teavm.classlib.java.lang.TFloat;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.interop.Import;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.Unmanaged;

@NoSideEffects
public final class TMath
extends TObject {
    public static final double E = Math.E;
    public static final double PI = Math.PI;

    private TMath() {
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="sin")
    @Unmanaged
    public static native double sin(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="cos")
    @Unmanaged
    public static native double cos(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="tan")
    @Unmanaged
    public static native double tan(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="asin")
    @Unmanaged
    public static native double asin(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="acos")
    @Unmanaged
    public static native double acos(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="atan")
    @Unmanaged
    public static native double atan(double var0);

    public static double toRadians(double angdeg) {
        return angdeg * Math.PI / 180.0;
    }

    public static double toDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="exp")
    @Unmanaged
    public static native double exp(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="log")
    @Unmanaged
    public static native double log(double var0);

    public static double log10(double a) {
        return TMath.log(a) / 2.302585092994046;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="sqrt")
    @Unmanaged
    public static native double sqrt(double var0);

    public static double cbrt(double a) {
        return a > 0.0 ? TMath.pow(a, 0.3333333333333333) : -TMath.pow(-a, 0.3333333333333333);
    }

    public static double IEEEremainder(double f1, double f2) {
        int n = (int)(f1 / f2);
        return f1 - (double)n * f2;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="ceil")
    @Unmanaged
    public static native double ceil(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="floor")
    @Unmanaged
    public static native double floor(double var0);

    public static double pow(double x, double y) {
        if (PlatformDetector.isWebAssembly()) {
            return WasmSupport.pow((double)x, (double)y);
        }
        return TMath.powImpl(x, y);
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="pow")
    @Unmanaged
    private static native double powImpl(double var0, double var2);

    public static double rint(double a) {
        return TMath.round(a);
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="atan2")
    @Unmanaged
    public static native double atan2(double var0, double var2);

    public static int round(float a) {
        return (int)(a + TMath.signum(a) * 0.5f);
    }

    public static long round(double a) {
        return (long)(a + TMath.signum(a) * 0.5);
    }

    public static int floorDiv(int a, int b) {
        int div = a / b;
        return (a ^ b) < 0 && div * b != a ? div - 1 : div;
    }

    public static long floorDiv(long a, int b) {
        return TMath.floorDiv(a, (long)b);
    }

    public static long floorDiv(long a, long b) {
        long div = a / b;
        return (a ^ b) < 0L && div * b != a ? div - 1L : div;
    }

    public static int floorMod(int a, int b) {
        return a - TMath.floorDiv(a, b) * b;
    }

    public static int floorMod(long a, int b) {
        return (int)(a - TMath.floorDiv(a, b) * (long)b);
    }

    public static long floorMod(long a, long b) {
        return a - TMath.floorDiv(a, b) * b;
    }

    @Unmanaged
    public static double random() {
        return PlatformDetector.isC() ? TMath.randomC() : TMath.randomImpl();
    }

    @Import(name="teavm_rand")
    private static native double randomC();

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="random")
    private static native double randomImpl();

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static long min(long a, long b) {
        return a < b ? a : b;
    }

    public static long max(long a, long b) {
        return a > b ? a : b;
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static double max(double a, double b) {
        return a > b ? a : b;
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static int abs(int n) {
        return n > 0 ? n : -n;
    }

    public static long abs(long n) {
        return n > 0L ? n : -n;
    }

    public static float abs(float n) {
        return n > 0.0f ? n : -n;
    }

    public static double abs(double n) {
        return n > 0.0 ? n : -n;
    }

    public static double ulp(double d) {
        if (TDouble.isNaN(d)) {
            return d;
        }
        if (TDouble.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (TDouble.isNaN(d)) {
            return d;
        }
        if (TDouble.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        long bits = TDouble.doubleToLongBits(d);
        if ((bits &= 0xEFF0000000000000L) >= 0x350000000000000L) {
            bits -= 0x340000000000000L;
        } else {
            int exponent = (int)(bits >> 52);
            bits = 1 << Math.max(0, exponent - 1);
        }
        return TDouble.longBitsToDouble(bits);
    }

    public static float ulp(float d) {
        if (TFloat.isNaN(d)) {
            return d;
        }
        if (TFloat.isInfinite(d)) {
            return Float.POSITIVE_INFINITY;
        }
        int bits = TFloat.floatToIntBits(d);
        if ((long)(bits &= 0x7F800000) >= 0xC000000L) {
            bits = (int)((long)bits - 0xB800000L);
        } else {
            int exponent = bits >> 23;
            bits = 1 << Math.max(0, exponent - 1);
        }
        return TFloat.intBitsToFloat(bits);
    }

    public static double signum(double d) {
        return d > 0.0 ? 1.0 : (d < 0.0 ? -1.0 : d);
    }

    public static float signum(float d) {
        return d > 0.0f ? 1.0f : (d < 0.0f ? -1.0f : d);
    }

    public static double sinh(double x) {
        double e = TMath.exp(x);
        return (e - 1.0 / e) / 2.0;
    }

    public static double cosh(double x) {
        double e = TMath.exp(x);
        return (e + 1.0 / e) / 2.0;
    }

    public static double tanh(double x) {
        double e = TMath.exp(x);
        return (e - 1.0 / e) / (e + 1.0 / e);
    }

    public static double hypot(double x, double y) {
        return TMath.sqrt(x * x + y * y);
    }

    public static double expm1(double x) {
        return TMath.exp(x) - 1.0;
    }

    public static double log1p(double x) {
        return TMath.log(x + 1.0);
    }

    public static float copySign(float magnitude, float sign) {
        if (sign == 0.0f || sign == 0.0f) {
            return sign;
        }
        return sign > 0.0f == magnitude > 0.0f ? magnitude : -magnitude;
    }

    public static double copySign(double magnitude, double sign) {
        if (sign == 0.0 || sign == 0.0) {
            return sign;
        }
        return sign > 0.0 == magnitude > 0.0 ? magnitude : -magnitude;
    }

    public static int getExponent(double d) {
        long bits = TDouble.doubleToLongBits(d);
        int exponent = (int)(bits >> 52 & 0x7FFL);
        return exponent - 1023;
    }

    public static int getExponent(float f) {
        int bits = TFloat.floatToIntBits(f);
        int exponent = bits >> 23 & 0xF;
        return exponent + 128;
    }

    public static double nextAfter(double start, double direction) {
        if (start == direction) {
            return direction;
        }
        return direction > start ? TMath.nextUp(start) : TMath.nextDown(start);
    }

    public static float nextAfter(float start, double direction) {
        if ((double)start == direction) {
            return start;
        }
        return direction > (double)start ? TMath.nextUp(start) : TMath.nextDown(start);
    }

    public static double nextUp(double d) {
        boolean negative;
        if (TDouble.isNaN(d)) {
            return d;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return d;
        }
        long bits = TDouble.doubleToLongBits(d);
        boolean bl = negative = (bits & Long.MIN_VALUE) != 0L;
        bits = negative ? --bits : ++bits;
        return TDouble.longBitsToDouble(bits);
    }

    public static float nextUp(float d) {
        boolean negative;
        if (TFloat.isNaN(d)) {
            return d;
        }
        if (d == Float.POSITIVE_INFINITY) {
            return d;
        }
        int bits = TFloat.floatToIntBits(d);
        boolean bl = negative = ((long)bits & 0x80000000L) != 0L;
        bits = negative ? --bits : ++bits;
        return TFloat.intBitsToFloat(bits);
    }

    public static double nextDown(double d) {
        boolean negative;
        if (TDouble.isNaN(d)) {
            return d;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        long bits = TDouble.doubleToLongBits(d);
        boolean bl = negative = (bits & Long.MIN_VALUE) != 0L;
        bits = negative ? ++bits : --bits;
        return TDouble.longBitsToDouble(bits);
    }

    public static float nextDown(float d) {
        boolean negative;
        if (TFloat.isNaN(d)) {
            return d;
        }
        if (d == Float.POSITIVE_INFINITY) {
            return d;
        }
        int bits = TFloat.floatToIntBits(d);
        boolean bl = negative = ((long)bits & 0x80000000L) != 0L;
        bits = negative ? ++bits : --bits;
        return TFloat.intBitsToFloat(bits);
    }
}

