/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.TInterruptedException;
import org.teavm.classlib.java.lang.TThread;
import org.teavm.classlib.java.lang.TThreadInterruptHandler;
import org.teavm.classlib.java.util.TAbstractQueue;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.concurrent.TBlockingQueue;
import org.teavm.classlib.java.util.concurrent.TTimeUnit;
import org.teavm.interop.Async;
import org.teavm.interop.AsyncCallback;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformQueue;
import org.teavm.platform.PlatformRunnable;
import org.teavm.runtime.EventQueue;

public class TArrayBlockingQueue<E>
extends TAbstractQueue<E>
implements TBlockingQueue<E> {
    private Object[] array;
    private int head;
    private int tail;
    private PlatformQueue<WaitHandler> waitHandlers;

    public TArrayBlockingQueue(int capacity) {
        this(capacity, false);
    }

    public TArrayBlockingQueue(int capacity, boolean fair) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be >= 1");
        }
        this.array = new Object[capacity];
    }

    public TArrayBlockingQueue(int capacity, boolean fair, Collection<? extends E> c) {
        if (capacity < 1 || capacity < Objects.requireNonNull(c).size()) {
            throw new IllegalArgumentException("Capacity must be at least 1 or collection's size");
        }
        if (c.size() > capacity) {
            throw new IllegalArgumentException();
        }
        this.array = new Object[capacity];
        int index = 0;
        for (E e : c) {
            this.array[index++] = Objects.requireNonNull(e);
        }
        this.tail = c.size();
    }

    @Override
    public boolean add(E e) {
        Objects.requireNonNull(e);
        if (this.isFull()) {
            throw new IllegalStateException("This blocking queue is full");
        }
        this.addImpl(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        Objects.requireNonNull(e);
        if (this.isFull()) {
            return false;
        }
        this.addImpl(e);
        return true;
    }

    @Override
    public void put(E e) throws InterruptedException {
        Objects.requireNonNull(e);
        while (this.isFull()) {
            this.waitForChange(0L);
        }
        this.addImpl(e);
    }

    @Override
    public boolean offer(E e, long timeout, TTimeUnit unit) throws InterruptedException {
        Objects.requireNonNull(e);
        if (this.isFull()) {
            long timeLimit = System.currentTimeMillis() + unit.toMillis(timeout);
            while (this.isFull()) {
                if (this.waitForChange(timeLimit).booleanValue()) continue;
                return false;
            }
        }
        this.addImpl(e);
        return true;
    }

    @Override
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.removeImpl();
    }

    @Override
    public E take() throws InterruptedException {
        while (this.isEmpty()) {
            this.waitForChange(0L);
        }
        return this.removeImpl();
    }

    @Override
    public E poll(long timeout, TTimeUnit unit) throws InterruptedException {
        if (this.isEmpty()) {
            long timeLimit = System.currentTimeMillis() + unit.toMillis(timeout);
            while (this.isEmpty()) {
                if (this.waitForChange(timeLimit).booleanValue()) continue;
                return null;
            }
        }
        return this.removeImpl();
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (E)this.array[this.head];
    }

    @Override
    public int size() {
        if (this.head < this.tail) {
            return this.tail - this.head;
        }
        if (this.array[this.head] != null) {
            return this.tail + this.array.length - this.head;
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail && this.array[this.head] == null;
    }

    @Override
    public int remainingCapacity() {
        return this.array.length - this.size();
    }

    @Override
    public boolean remove(Object o) {
        int i;
        if (this.isEmpty()) {
            return false;
        }
        if (this.head < this.tail) {
            for (int i2 = this.head; i2 < this.tail; ++i2) {
                if (!this.array[i2].equals(o)) continue;
                this.removeAt(i2);
                return true;
            }
            return false;
        }
        for (i = this.head; i < this.array.length; ++i) {
            if (!this.array[i].equals(o)) continue;
            this.removeAt(i);
            return true;
        }
        for (i = 0; i < this.tail; ++i) {
            if (!this.array[i].equals(o)) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        int i;
        if (this.isEmpty()) {
            return false;
        }
        if (this.head < this.tail) {
            for (int i2 = this.head; i2 < this.tail; ++i2) {
                if (!this.array[i2].equals(o)) continue;
                return true;
            }
            return false;
        }
        for (i = this.head; i < this.array.length; ++i) {
            if (!this.array[i].equals(o)) continue;
            return true;
        }
        for (i = 0; i < this.tail; ++i) {
            if (!this.array[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        if (this.isEmpty()) {
            return new Object[0];
        }
        if (this.head < this.tail) {
            return Arrays.copyOfRange(this.array, this.head, this.tail);
        }
        Object[] result = new Object[this.size()];
        System.arraycopy(this.array, this.head, result, 0, this.array.length - this.head);
        System.arraycopy(this.array, 0, result, this.array.length - this.head, this.tail);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.isEmpty()) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int size = this.size();
        if (size > a.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        } else if (size < a.length) {
            a[size] = null;
        }
        if (this.head < this.tail) {
            System.arraycopy(this.array, this.head, a, 0, size);
        } else {
            System.arraycopy(this.array, this.head, a, 0, this.array.length - this.head);
            System.arraycopy(this.array, 0, a, this.array.length - this.head, this.tail);
        }
        return a;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        if (this.head < this.tail) {
            for (int i = this.head; i < this.tail; ++i) {
                this.array[i] = null;
            }
        } else {
            int i;
            for (i = this.head; i < this.array.length; ++i) {
                this.array[i] = null;
            }
            for (i = 0; i < this.tail; ++i) {
                this.array[i] = null;
            }
        }
        this.head = 0;
        this.tail = 0;
        this.notifyChange();
    }

    @Override
    public int drainTo(TCollection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(TCollection<? super E> c, int maxElements) {
        if (c == this) {
            throw new IllegalArgumentException("The specified collection is this queue");
        }
        if (this.isEmpty()) {
            return 0;
        }
        Objects.requireNonNull(c);
        maxElements = Math.min(maxElements, this.size());
        if (maxElements < this.tail) {
            for (int i = 0; i < maxElements; ++i) {
                this.drainSingleTo(c);
            }
            this.notifyChange();
        } else {
            int remaining = maxElements - (this.array.length - this.head);
            while (this.head < this.array.length) {
                this.drainSingleTo(c);
            }
            this.head = 0;
            while (remaining-- > 0) {
                this.drainSingleTo(c);
            }
            this.notifyChange();
        }
        return maxElements;
    }

    @Override
    public TIterator<E> iterator() {
        return new TIterator<E>(){
            int index;
            int removeIndex;
            {
                this.index = TArrayBlockingQueue.this.head;
                this.removeIndex = -1;
            }

            @Override
            public boolean hasNext() {
                return TArrayBlockingQueue.this.array[this.index] != null;
            }

            @Override
            public E next() {
                this.removeIndex = this.index;
                Object result = TArrayBlockingQueue.this.array[this.index++];
                if (result == null) {
                    throw new NoSuchElementException();
                }
                if (this.index == TArrayBlockingQueue.this.array.length) {
                    this.index = 0;
                }
                return result;
            }

            @Override
            public void remove() {
                if (this.removeIndex < 0 || TArrayBlockingQueue.this.array[this.removeIndex] == null) {
                    throw new IllegalStateException();
                }
                TArrayBlockingQueue.this.removeAt(this.removeIndex);
                this.removeIndex = -1;
            }
        };
    }

    private void removeAt(int index) {
        if (index < this.tail) {
            this.shiftElements(index, this.tail);
            --this.tail;
        } else {
            this.shiftElements(index, this.array.length);
            this.array[this.array.length - 1] = this.array[0];
            this.shiftElements(0, this.tail);
            if (--this.tail < 0) {
                this.tail = this.array.length;
            }
        }
        this.array[this.tail] = null;
        this.notifyChange();
    }

    private void drainSingleTo(TCollection<? super E> c) {
        Object e = this.array[this.head];
        this.array[this.head++] = null;
        c.add(e);
    }

    private void shiftElements(int from, int to) {
        int remaining = to - from - 1;
        if (remaining > 0) {
            System.arraycopy(this.array, from + 1, this.array, from, remaining);
        }
    }

    private void addImpl(E e) {
        this.array[this.tail++] = e;
        if (this.tail == this.array.length) {
            this.tail = 0;
        }
        this.notifyChange();
    }

    private E removeImpl() {
        Object result = this.array[this.head];
        this.array[this.head++] = null;
        if (this.head == this.array.length) {
            this.head = 0;
        }
        this.notifyChange();
        return (E)result;
    }

    private void notifyChange() {
        if (this.waitHandlers == null) {
            return;
        }
        while (!this.waitHandlers.isEmpty()) {
            WaitHandler handler = (WaitHandler)this.waitHandlers.remove();
            if (PlatformDetector.isLowLevel()) {
                EventQueue.offer(handler::changed);
                continue;
            }
            Platform.postpone(handler::changed);
        }
        this.waitHandlers = null;
    }

    @Async
    private native Boolean waitForChange(long var1) throws InterruptedException;

    private void waitForChange(long timeLimit, AsyncCallback<Boolean> callback) {
        if (this.waitHandlers == null) {
            this.waitHandlers = Platform.createQueue();
        }
        WaitHandler handler = new WaitHandler(callback);
        this.waitHandlers.add((Object)handler);
        if (timeLimit > 0L) {
            int timeout = Math.max(0, (int)(timeLimit - System.currentTimeMillis()));
            handler.timerId = PlatformDetector.isLowLevel() ? EventQueue.offer((EventQueue.Event)handler, (long)timeLimit) : Platform.schedule((PlatformRunnable)handler, (int)timeout);
        } else {
            handler.timerId = -1;
        }
        TThread.currentThread().interruptHandler = handler;
    }

    private boolean isFull() {
        return this.head == this.tail && this.array[this.head] != null;
    }

    class WaitHandler
    implements PlatformRunnable,
    TThreadInterruptHandler,
    EventQueue.Event {
        AsyncCallback<Boolean> callback;
        boolean complete;
        int timerId;

        WaitHandler(AsyncCallback<Boolean> callback) {
            this.callback = callback;
        }

        public void run() {
            if (this.complete()) {
                return;
            }
            this.callback.complete((Object)false);
        }

        @Override
        public void interrupted() {
            if (this.complete()) {
                return;
            }
            this.callback.error((Throwable)new TInterruptedException());
        }

        private boolean complete() {
            if (this.complete) {
                return true;
            }
            this.complete = true;
            if (this.timerId >= 0) {
                if (PlatformDetector.isLowLevel()) {
                    EventQueue.kill((int)this.timerId);
                } else {
                    Platform.killSchedule((int)this.timerId);
                }
                this.timerId = -1;
            }
            TThread.currentThread().interruptHandler = null;
            return false;
        }

        void changed() {
            if (this.complete()) {
                return;
            }
            this.callback.complete((Object)true);
        }
    }
}

