/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.charset;

import org.teavm.classlib.java.nio.charset.TBufferOverflowException;
import org.teavm.classlib.java.nio.charset.TBufferUnderflowException;
import org.teavm.classlib.java.nio.charset.TCharacterCodingException;
import org.teavm.classlib.java.nio.charset.TMalformedInputException;
import org.teavm.classlib.java.nio.charset.TUnmappableCharacterException;

public class TCoderResult {
    public static final TCoderResult UNDERFLOW = new TCoderResult(0, 0);
    public static final TCoderResult OVERFLOW = new TCoderResult(1, 0);
    private byte kind;
    private int length;

    TCoderResult(byte kind, int length) {
        this.kind = kind;
        this.length = length;
    }

    public boolean isUnderflow() {
        return this.kind == 0;
    }

    public boolean isOverflow() {
        return this.kind == 1;
    }

    public boolean isError() {
        return this.isMalformed() || this.isUnmappable();
    }

    public boolean isMalformed() {
        return this.kind == 2;
    }

    public boolean isUnmappable() {
        return this.kind == 3;
    }

    public int length() {
        if (!this.isError()) {
            throw new UnsupportedOperationException();
        }
        return this.length;
    }

    public static TCoderResult malformedForLength(int length) {
        return new TCoderResult(2, length);
    }

    public static TCoderResult unmappableForLength(int length) {
        return new TCoderResult(3, length);
    }

    public void throwException() throws TCharacterCodingException {
        switch (this.kind) {
            case 0: {
                throw new TBufferUnderflowException();
            }
            case 1: {
                throw new TBufferOverflowException();
            }
            case 2: {
                throw new TMalformedInputException(this.length);
            }
            case 3: {
                throw new TUnmappableCharacterException(this.length);
            }
        }
    }

    public String toString() {
        switch (this.kind) {
            case 0: {
                return "UNDERFLOW";
            }
            case 1: {
                return "OVERFLOW";
            }
            case 2: {
                return "MALFORMED " + this.length;
            }
            case 3: {
                return "UNMAPPABLE " + this.length;
            }
        }
        throw new AssertionError();
    }
}

