/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.function.Consumer;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TSpliterator;

public class TSpliteratorOverCollection<T>
implements TSpliterator<T> {
    private TCollection<T> collection;
    private TIterator<T> iterator;

    public TSpliteratorOverCollection(TCollection<T> collection) {
        this.collection = collection;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        this.ensureIterator();
        if (this.iterator.hasNext()) {
            action.accept(this.iterator.next());
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.ensureIterator();
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.next());
        }
    }

    private void ensureIterator() {
        if (this.iterator == null) {
            this.iterator = this.collection.iterator();
        }
    }

    @Override
    public TSpliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.collection.size();
    }

    @Override
    public int characteristics() {
        return 64;
    }
}

