/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.TCheckedCollection;
import org.teavm.classlib.java.util.TCheckedSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.THashMap;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TSet;

class TCheckedMap<K, V>
implements TMap<K, V> {
    private TMap<K, V> innerMap;
    private TClass<K> keyType;
    private TClass<V> valueType;

    public TCheckedMap(TMap<K, V> innerMap, TClass<K> keyType, TClass<V> valueType) {
        this.innerMap = innerMap;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.innerMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.innerMap.put(this.keyType.cast(TObject.wrap(key)), this.valueType.cast(TObject.wrap(value)));
    }

    @Override
    public V remove(Object key) {
        return this.innerMap.remove(key);
    }

    @Override
    public void putAll(TMap<? extends K, ? extends V> m) {
        m = new THashMap<K, V>(m);
        TIterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            this.keyType.cast(TObject.wrap(entry.getKey()));
            this.valueType.cast(TObject.wrap(entry.getValue()));
        }
        this.innerMap.putAll(m);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public TSet<K> keySet() {
        return new TCheckedSet<K>(this.innerMap.keySet(), this.keyType);
    }

    @Override
    public TCollection<V> values() {
        return new TCheckedCollection<V>(this.innerMap.values(), this.valueType);
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        return this.innerMap.entrySet();
    }
}

