/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.Arrays;
import org.teavm.common.DisjointSet;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;

public class ClassForNameTransformer
implements ClassHolderTransformer {
    private static final MethodReference getNameMethod = new MethodReference(Class.class, "getName", new Class[]{String.class});
    private static final MethodReference forNameMethod = new MethodReference(Class.class, "forName", new Class[]{String.class, Boolean.TYPE, ClassLoader.class, Class.class});
    private static final MethodReference initMethod = new MethodReference(Class.class, "initialize", new Class[]{Void.TYPE});

    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        for (MethodHolder method : cls.getMethods()) {
            Program program = method.getProgram();
            if (program == null) continue;
            this.transformProgram(program);
        }
    }

    private void transformProgram(Program program) {
        DisjointSet varSet = new DisjointSet();
        for (int i = 0; i < program.variableCount(); ++i) {
            varSet.create();
        }
        int[] nameIndexes = new int[program.variableCount()];
        Arrays.fill(nameIndexes, -1);
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                if (instruction instanceof InvokeInstruction) {
                    InvokeInstruction invoke = (InvokeInstruction)instruction;
                    if (!invoke.getMethod().equals((Object)getNameMethod) || invoke.getReceiver() == null) continue;
                    nameIndexes[invoke.getReceiver().getIndex()] = invoke.getInstance().getIndex();
                    continue;
                }
                if (!(instruction instanceof AssignInstruction)) continue;
                AssignInstruction assign = (AssignInstruction)instruction;
                varSet.union(assign.getAssignee().getIndex(), assign.getReceiver().getIndex());
            }
        }
        nameIndexes = Arrays.copyOf(nameIndexes, varSet.size());
        int[] nameRepresentatives = new int[nameIndexes.length];
        Arrays.fill(nameRepresentatives, -1);
        for (int i = 0; i < program.variableCount(); ++i) {
            int varClass = varSet.find(i);
            if (nameRepresentatives[varClass] < 0) {
                nameRepresentatives[varClass] = i;
            }
            if (nameIndexes[i] < 0) continue;
            nameIndexes[varClass] = varSet.find(nameIndexes[i]);
        }
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                int classNameIndex;
                int nameIndex;
                InvokeInstruction invoke;
                if (!(instruction instanceof InvokeInstruction) || !(invoke = (InvokeInstruction)instruction).getMethod().equals((Object)forNameMethod) || (nameIndex = nameIndexes[classNameIndex = ((Variable)invoke.getArguments().get(0)).getIndex()]) < 0) continue;
                Variable representative = program.variableAt(nameRepresentatives[nameIndex]);
                InvokeInstruction initInvoke = new InvokeInstruction();
                initInvoke.setLocation(invoke.getLocation());
                initInvoke.setType(InvocationType.SPECIAL);
                initInvoke.setMethod(initMethod);
                initInvoke.setInstance(representative);
                invoke.insertPrevious((Instruction)initInvoke);
                if (invoke.getReceiver() == null) {
                    invoke.delete();
                    continue;
                }
                AssignInstruction assign = new AssignInstruction();
                assign.setLocation(invoke.getLocation());
                assign.setAssignee(representative);
                assign.setReceiver(invoke.getReceiver());
                invoke.replace((Instruction)assign);
            }
        }
    }
}

