/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.teavm.classlib.java.text.TDateFormatSymbols;
import org.teavm.classlib.java.text.TParsePosition;
import org.teavm.classlib.java.util.TCalendar;
import org.teavm.classlib.java.util.TGregorianCalendar;
import org.teavm.classlib.java.util.TLocale;
import org.teavm.classlib.java.util.TTimeZone;

abstract class TDateFormatElement {
    TDateFormatElement() {
    }

    public abstract void format(TCalendar var1, StringBuffer var2);

    public abstract void parse(String var1, TCalendar var2, TParsePosition var3);

    static boolean matches(String text, int position, String pattern) {
        if (pattern.length() + position > text.length()) {
            return false;
        }
        for (int i = 0; i < pattern.length(); ++i) {
            if (Character.toLowerCase(pattern.charAt(i)) == Character.toLowerCase(text.charAt(position++))) continue;
            return false;
        }
        return true;
    }

    static int whichMatches(String text, TParsePosition position, String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!TDateFormatElement.matches(text, position.getIndex(), patterns[i])) continue;
            position.setIndex(position.getIndex() + patterns[i].length());
            return i;
        }
        return -1;
    }

    static boolean tryParseFixedTimeZone(String text, TCalendar date, TParsePosition position) {
        block6: {
            char signChar;
            if (position.getIndex() + 4 < text.length()) {
                int signIndex = position.getIndex() + 3;
                if (text.substring(position.getIndex(), signIndex).equals("GMT") && ((signChar = text.charAt(signIndex)) == '+' || signChar == '-')) {
                    TDateFormatElement.parseHoursMinutes(text, date, position);
                    return true;
                }
            }
            if (position.getIndex() + 5 <= text.length()) {
                int index = position.getIndex();
                if ((signChar = text.charAt(index++)) == '+' || signChar == '-') {
                    for (int i = 0; i < 4; ++i) {
                        if (Character.isDigit(text.charAt(index + i))) {
                            continue;
                        }
                        break block6;
                    }
                    int sign = signChar == '-' ? -1 : 1;
                    int hours = 10 * Character.digit(text.charAt(index), 10) + Character.digit(text.charAt(index + 1), 10);
                    int minutes = 10 * Character.digit(text.charAt(index + 2), 10) + Character.digit(text.charAt(index + 3), 10);
                    date.setTimeZone(TDateFormatElement.getStaticTimeZone(sign * hours, minutes));
                    return true;
                }
            }
        }
        return false;
    }

    static void parseHoursMinutes(String text, TCalendar date, TParsePosition position) {
        int sign;
        int index = position.getIndex() + 3;
        int n = sign = text.charAt(index++) == '-' ? -1 : 1;
        if (index >= text.length() || !Character.isDigit(text.charAt(index))) {
            position.setErrorIndex(index);
            return;
        }
        int hours = Character.digit(text.charAt(index++), 10);
        if (index >= text.length()) {
            position.setErrorIndex(index);
            return;
        }
        if (text.charAt(index) != ':') {
            if (!Character.isDigit(text.charAt(index))) {
                position.setErrorIndex(index);
                return;
            }
            hours = 10 * hours + Character.digit(text.charAt(index), 10);
        }
        if (index >= text.length() || text.charAt(index) != ':') {
            position.setErrorIndex(index);
            return;
        }
        if (++index + 2 > text.length() || !Character.isDigit(text.charAt(index)) || !Character.isDigit(text.charAt(index + 1))) {
            position.setErrorIndex(index);
            return;
        }
        int minutes = Character.digit(text.charAt(index), 10) * 10 + Character.digit(text.charAt(index), 10);
        position.setIndex(index + 2);
        TTimeZone tz = TDateFormatElement.getStaticTimeZone(sign * hours, minutes);
        date.setTimeZone(tz);
    }

    static TTimeZone getStaticTimeZone(int hours, int minutes) {
        return TTimeZone.getTimeZone("GMT" + (hours > 0 ? (char)'+' : '-') + Math.abs(hours) + ":" + minutes / 10 + minutes % 10);
    }

    static class TrieNodeBuilder {
        char ch;
        TrieNodeBuilder next;
        TTimeZone tz;
        TrieNodeBuilder sibling;

        TrieNodeBuilder() {
        }
    }

    static class TrieBuilder {
        TrieNodeBuilder root = new TrieNodeBuilder();

        TrieBuilder() {
        }

        public void add(String text, TTimeZone tz) {
            TrieNodeBuilder node = this.root;
            for (int i = 0; i < text.length(); ++i) {
                char c = Character.toLowerCase(text.charAt(i));
                while (node.ch != c) {
                    if (node.ch == '\u0000') {
                        node.ch = c;
                        node.sibling = new TrieNodeBuilder();
                        break;
                    }
                    node = node.sibling;
                }
                if (node.next == null) {
                    node.next = new TrieNodeBuilder();
                }
                node = node.next;
            }
            node.tz = tz;
        }

        public TrieNode build() {
            return this.build(this.root);
        }

        TrieNode build(TrieNodeBuilder builder) {
            TrieNode node = new TrieNode();
            if (builder == null) {
                return node;
            }
            node.tz = builder.tz;
            ArrayList<TrieNodeBuilder> builders = new ArrayList<TrieNodeBuilder>();
            TrieNodeBuilder tmp = builder;
            while (tmp.ch != '\u0000') {
                builders.add(tmp);
                tmp = tmp.sibling;
            }
            Collections.sort(builders, (o1, o2) -> Character.compare(o1.ch, o2.ch));
            node.chars = new char[builders.size()];
            node.childNodes = new TrieNode[builders.size()];
            for (int i = 0; i < node.chars.length; ++i) {
                node.chars[i] = ((TrieNodeBuilder)builders.get((int)i)).ch;
                node.childNodes[i] = this.build(((TrieNodeBuilder)builders.get((int)i)).next);
            }
            return node;
        }
    }

    static class TrieNode {
        char[] chars;
        TrieNode[] childNodes;
        TTimeZone tz;

        TrieNode() {
        }
    }

    public static class Iso8601Timezone
    extends TDateFormatElement {
        private int size;

        public Iso8601Timezone(int size) {
            this.size = size;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int minutes = date.getTimeZone().getOffset(date.getTimeInMillis()) / 60000;
            if (minutes == 0) {
                buffer.append('Z');
                return;
            }
            if (minutes > 0) {
                buffer.append('+');
            } else {
                minutes = -minutes;
                buffer.append('-');
            }
            int hours = minutes / 60;
            minutes %= 60;
            buffer.append(hours / 10).append(hours % 10);
            if (this.size >= 3) {
                buffer.append(':');
            }
            if (this.size > 1) {
                buffer.append(minutes / 10).append(minutes % 10);
            }
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            int sign;
            char signChar;
            int index = position.getIndex();
            if ((signChar = text.charAt(index++)) == '+') {
                sign = 1;
            } else if (signChar == '-') {
                sign = -1;
            } else {
                if (signChar == 'Z') {
                    date.setTimeZone(TTimeZone.getTimeZone("GMT"));
                    return;
                }
                position.setErrorIndex(index);
                return;
            }
            int expectedSize = 2;
            if (this.size > 1) {
                expectedSize += 2;
            }
            if (this.size >= 3) {
                ++expectedSize;
            }
            if (index + expectedSize > text.length()) {
                position.setErrorIndex(index);
                return;
            }
            if (!Character.isDigit(text.charAt(index)) || !Character.isDigit(text.charAt(index + 1))) {
                position.setErrorIndex(index);
                return;
            }
            int hours = Character.digit(text.charAt(index++), 10) * 10 + Character.digit(text.charAt(index++), 10);
            if (this.size >= 3 && text.charAt(index++) != ':') {
                position.setErrorIndex(index);
                return;
            }
            int minutes = 0;
            if (this.size > 1) {
                if (!Character.isDigit(text.charAt(index)) || !Character.isDigit(text.charAt(index + 1))) {
                    position.setErrorIndex(index);
                    return;
                }
                minutes = Character.digit(text.charAt(index++), 10) * 10 + Character.digit(text.charAt(index++), 10);
            }
            position.setIndex(index);
            date.setTimeZone(Iso8601Timezone.getStaticTimeZone(sign * hours, minutes));
        }
    }

    public static class Rfc822Timezone
    extends BaseTimezone {
        public Rfc822Timezone(TLocale locale) {
            super(locale);
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            TTimeZone tz = date.getTimeZone();
            int minutes = tz.getOffset(date.getTimeInMillis()) / 60000;
            if (minutes >= 0) {
                buffer.append('+');
            } else {
                minutes = -minutes;
                buffer.append('-');
            }
            int hours = minutes / 60;
            buffer.append(hours / 10).append(hours % 10).append((minutes %= 60) / 10).append(minutes % 10);
        }
    }

    public static class GeneralTimezone
    extends BaseTimezone {
        public GeneralTimezone(TLocale locale) {
            super(locale);
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            TTimeZone tz = date.getTimeZone();
            if (tz.getID().startsWith("GMT")) {
                int minutes = tz.getRawOffset() / 60000;
                buffer.append("GMT");
                if (minutes >= 0) {
                    buffer.append('+');
                } else {
                    minutes = -minutes;
                    buffer.append('-');
                }
                int hours = minutes / 60;
                buffer.append(hours / 10).append(hours % 10).append(':').append((minutes %= 60) / 10).append(minutes % 10);
            } else {
                buffer.append(tz.getDisplayName(this.locale));
            }
        }
    }

    public static abstract class BaseTimezone
    extends TDateFormatElement {
        private static Map<TLocale, TrieNode> cache;
        private static TrieNode idSearchTrie;
        protected TLocale locale;
        private TrieNode searchTrie;

        public BaseTimezone(TLocale locale) {
            this.locale = locale;
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            if (BaseTimezone.tryParseFixedTimeZone(text, date, position)) {
                return;
            }
            this.prepareTrie();
            TTimeZone tz = this.match(this.searchTrie, text, position);
            if (tz != null) {
                date.setTimeZone(tz);
            } else {
                BaseTimezone.prepareIdTrie();
                tz = this.match(idSearchTrie, text, position);
                if (tz != null) {
                    date.setTimeZone(tz);
                } else {
                    position.setErrorIndex(position.getIndex());
                }
            }
        }

        public TTimeZone match(TrieNode node, String text, TParsePosition position) {
            int start;
            int index = start = position.getIndex();
            int lastMatch = start;
            TTimeZone tz = null;
            while (node.childNodes != null && node.childNodes.length > 0) {
                int next;
                if (node.tz != null) {
                    lastMatch = index;
                    tz = node.tz;
                }
                if (index >= text.length()) break;
                if ((next = Arrays.binarySearch(node.chars, Character.toLowerCase(text.charAt(index++)))) < 0) {
                    return null;
                }
                node = node.childNodes[next];
            }
            if (node.tz != null) {
                lastMatch = index;
                tz = node.tz;
            }
            position.setIndex(lastMatch);
            return tz;
        }

        private void prepareTrie() {
            if (this.searchTrie != null) {
                return;
            }
            if (cache == null) {
                cache = new HashMap<TLocale, TrieNode>();
            }
            this.searchTrie = cache.get(this.locale);
            if (this.searchTrie != null) {
                return;
            }
            TrieBuilder builder = new TrieBuilder();
            for (String tzId : TTimeZone.getAvailableIDs()) {
                TTimeZone tz = TTimeZone.getTimeZone(tzId);
                builder.add(tz.getDisplayName(this.locale), tz);
            }
            this.searchTrie = builder.build();
            cache.put(this.locale, this.searchTrie);
        }

        private static void prepareIdTrie() {
            if (idSearchTrie != null) {
                return;
            }
            TrieBuilder builder = new TrieBuilder();
            for (String tzId : TTimeZone.getAvailableIDs()) {
                TTimeZone tz = TTimeZone.getTimeZone(tzId);
                builder.add(tz.getID(), tz);
            }
            idSearchTrie = builder.build();
        }
    }

    public static class ConstantText
    extends TDateFormatElement {
        private String textConstant;

        public ConstantText(String textConstant) {
            this.textConstant = textConstant;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            buffer.append(this.textConstant);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            if (ConstantText.matches(text, position.getIndex(), this.textConstant)) {
                position.setIndex(position.getIndex() + this.textConstant.length());
            } else {
                position.setErrorIndex(position.getIndex());
            }
        }
    }

    public static class Year
    extends TDateFormatElement {
        private int field;

        public Year(int field) {
            this.field = field;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int number = date.get(this.field);
            if (number < 10) {
                buffer.append(number);
            } else {
                buffer.append((char)(number % 100 / 10 + 48));
                buffer.append((char)(number % 10 + 48));
            }
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            char c;
            int num = 0;
            int pos = position.getIndex();
            if ((c = text.charAt(pos++)) < '0' || c > '9') {
                position.setErrorIndex(position.getErrorIndex());
                return;
            }
            num = c - 48;
            c = text.charAt(pos);
            if (c >= '0' && c <= '9') {
                num = num * 10 + (c - 48);
                ++pos;
            }
            position.setIndex(pos);
            TGregorianCalendar calendar = new TGregorianCalendar();
            int currentYear = calendar.get(1);
            int currentShortYear = currentYear % 100;
            int century = currentYear / 100;
            if (currentShortYear > 80) {
                if (num < currentShortYear - 80) {
                    ++century;
                }
            } else if (num > currentShortYear + 20) {
                --century;
            }
            date.set(this.field, num + century * 100);
        }
    }

    public static class NumericHour
    extends Numeric {
        private int limit;

        public NumericHour(int field, int length, int limit) {
            super(field, length);
            this.limit = limit;
        }

        @Override
        protected int processBeforeFormat(int num) {
            return num == 0 ? this.limit : num;
        }

        @Override
        protected int processAfterParse(int num) {
            return num == this.limit ? 0 : num;
        }
    }

    public static class NumericWeekday
    extends Numeric {
        public NumericWeekday(int length) {
            super(7, length);
        }

        @Override
        protected int processBeforeFormat(int num) {
            return num == 1 ? 7 : num - 1;
        }

        @Override
        protected int processAfterParse(int num) {
            return num == 7 ? 1 : num + 1;
        }
    }

    public static class NumericMonth
    extends Numeric {
        public NumericMonth(int length) {
            super(2, length);
        }

        @Override
        protected int processBeforeFormat(int num) {
            return num + 1;
        }

        @Override
        protected int processAfterParse(int num) {
            return num - 1;
        }
    }

    public static class Numeric
    extends TDateFormatElement {
        private int field;
        private int length;

        public Numeric(int field, int length) {
            this.field = field;
            this.length = length;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int number = this.processBeforeFormat(date.get(this.field));
            String str = Integer.toString(number);
            for (int i = str.length(); i < this.length; ++i) {
                buffer.append('0');
            }
            buffer.append(str);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            char c;
            int num = 0;
            int i = 0;
            int pos = position.getIndex();
            while (pos < text.length() && (c = text.charAt(pos)) >= '0' && c <= '9') {
                num = num * 10 + (c - 48);
                ++pos;
                ++i;
            }
            if (i < this.length) {
                position.setErrorIndex(position.getIndex());
                return;
            }
            position.setIndex(pos);
            date.set(this.field, this.processAfterParse(num));
        }

        protected int processBeforeFormat(int num) {
            return num;
        }

        protected int processAfterParse(int num) {
            return num;
        }
    }

    public static class AmPmText
    extends TDateFormatElement {
        String[] ampms;

        public AmPmText(TDateFormatSymbols symbols) {
            this.ampms = symbols.getAmPmStrings();
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int ampm = date.get(9);
            buffer.append(this.ampms[ampm]);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            int ampm = AmPmText.whichMatches(text, position, this.ampms);
            if (ampm < 0) {
                position.setErrorIndex(position.getIndex());
            } else {
                date.set(9, ampm);
            }
        }
    }

    public static class EraText
    extends TDateFormatElement {
        String[] eras;

        public EraText(TDateFormatSymbols symbols) {
            this.eras = symbols.getEras();
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int era = date.get(0);
            buffer.append(this.eras[era]);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            int era = EraText.whichMatches(text, position, this.eras);
            if (era < 0) {
                position.setErrorIndex(position.getIndex());
            } else {
                date.set(0, era);
            }
        }
    }

    public static class WeekdayText
    extends TDateFormatElement {
        String[] weeks;
        String[] shortWeeks;
        boolean abbreviated;

        public WeekdayText(TDateFormatSymbols symbols, boolean abbreviated) {
            this.weeks = symbols.getWeekdays();
            this.shortWeeks = symbols.getShortWeekdays();
            this.abbreviated = abbreviated;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int weekday = date.get(7) - 1;
            buffer.append(this.abbreviated ? this.shortWeeks[weekday] : this.weeks[weekday]);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            int weekday = WeekdayText.whichMatches(text, position, this.weeks);
            if (weekday < 0) {
                weekday = WeekdayText.whichMatches(text, position, this.shortWeeks);
            }
            if (weekday < 0) {
                position.setErrorIndex(position.getIndex());
            } else {
                date.set(4, weekday + 1);
            }
        }
    }

    public static class MonthText
    extends TDateFormatElement {
        String[] months;
        String[] shortMonths;
        boolean abbreviated;

        public MonthText(TDateFormatSymbols symbols, boolean abbreviated) {
            this.months = symbols.getMonths();
            this.shortMonths = symbols.getShortMonths();
            this.abbreviated = abbreviated;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int month = date.get(2);
            buffer.append(this.abbreviated ? this.shortMonths[month] : this.months[month]);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            int month = MonthText.whichMatches(text, position, this.months);
            if (month < 0) {
                month = MonthText.whichMatches(text, position, this.shortMonths);
            }
            if (month < 0) {
                position.setErrorIndex(position.getIndex());
            } else {
                date.set(2, month);
            }
        }
    }
}

