/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.IOException;
import org.teavm.codegen.SourceWriter;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.javascript.spi.Generator;
import org.teavm.javascript.spi.GeneratorContext;
import org.teavm.model.CallLocation;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;

public class SystemNativeGenerator
implements Generator,
DependencyPlugin {
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "doArrayCopy": {
                this.generateArrayCopy(context, writer);
                break;
            }
            case "currentTimeMillis": {
                this.generateCurrentTimeMillis(writer);
                break;
            }
            case "setOut": {
                writer.appendClass("java.lang.System").append('.').appendField(new FieldReference("java.lang.System", "out")).ws().append('=').ws().append(context.getParameterName(1)).append(";").softNewLine();
                break;
            }
            case "setErr": {
                writer.appendClass("java.lang.System").append('.').appendField(new FieldReference("java.lang.System", "err")).ws().append('=').ws().append(context.getParameterName(1)).append(";").softNewLine();
            }
        }
    }

    public void methodReached(DependencyAgent agent, MethodDependency method, CallLocation location) {
        switch (method.getReference().getName()) {
            case "doArrayCopy": {
                this.achieveArrayCopy(method);
                break;
            }
            case "setOut": {
                this.achieveSetOut(agent, method);
                break;
            }
            case "setErr": {
                this.achieveSetErr(agent, method);
            }
        }
    }

    private void generateArrayCopy(GeneratorContext context, SourceWriter writer) throws IOException {
        String src = context.getParameterName(1);
        String srcPos = context.getParameterName(2);
        String dest = context.getParameterName(3);
        String destPos = context.getParameterName(4);
        String length = context.getParameterName(5);
        writer.append("if (" + src + " !== " + dest + " || " + destPos + " < " + srcPos + ") {").indent().newLine();
        writer.append("for (var i = 0; i < " + length + "; i = (i + 1) | 0) {").indent().softNewLine();
        writer.append(dest + ".data[" + destPos + "++] = " + src + ".data[" + srcPos + "++];").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.outdent().append("} else {").indent().softNewLine();
        writer.append(srcPos + " = (" + srcPos + " + " + length + ") | 0;").softNewLine();
        writer.append(destPos + " = (" + destPos + " + " + length + ") | 0;").softNewLine();
        writer.append("for (var i = 0; i < " + length + "; i = (i + 1) | 0) {").indent().softNewLine();
        writer.append(dest + ".data[--" + destPos + "] = " + src + ".data[--" + srcPos + "];").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.outdent().append("}").softNewLine();
    }

    private void generateCurrentTimeMillis(SourceWriter writer) throws IOException {
        writer.append("return Long_fromNumber(new Date().getTime());").softNewLine();
    }

    private void achieveArrayCopy(MethodDependency method) {
        DependencyNode src = method.getVariable(1);
        DependencyNode dest = method.getVariable(3);
        src.getArrayItem().connect(dest.getArrayItem());
    }

    private void achieveSetErr(DependencyAgent agent, MethodDependency method) {
        FieldDependency fieldDep = agent.linkField(new FieldReference("java.lang.System", "err"), null);
        method.getVariable(1).connect(fieldDep.getValue());
    }

    private void achieveSetOut(DependencyAgent agent, MethodDependency method) {
        FieldDependency fieldDep = agent.linkField(new FieldReference("java.lang.System", "out"), null);
        method.getVariable(1).connect(fieldDep.getValue());
    }
}

