/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import org.teavm.classlib.impl.FirstDayOfWeekMetadataGenerator;
import org.teavm.classlib.impl.MinimalDaysInFirstWeekMetadataGenerator;
import org.teavm.classlib.impl.unicode.AvailableLocalesMetadataGenerator;
import org.teavm.classlib.impl.unicode.CountryMetadataGenerator;
import org.teavm.classlib.impl.unicode.CurrencyLocalization;
import org.teavm.classlib.impl.unicode.CurrencyLocalizationMetadataGenerator;
import org.teavm.classlib.impl.unicode.DateFormatCollection;
import org.teavm.classlib.impl.unicode.DateFormatMetadataGenerator;
import org.teavm.classlib.impl.unicode.DateSymbolsMetadataGenerator;
import org.teavm.classlib.impl.unicode.DecimalData;
import org.teavm.classlib.impl.unicode.DecimalMetadataGenerator;
import org.teavm.classlib.impl.unicode.DefaultLocaleMetadataGenerator;
import org.teavm.classlib.impl.unicode.LanguageMetadataGenerator;
import org.teavm.classlib.impl.unicode.LikelySubtagsMetadataGenerator;
import org.teavm.classlib.impl.unicode.NumberFormatMetadataGenerator;
import org.teavm.classlib.impl.unicode.TimeZoneLocalization;
import org.teavm.classlib.impl.unicode.TimeZoneLocalizationGenerator;
import org.teavm.platform.metadata.IntResource;
import org.teavm.platform.metadata.MetadataProvider;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StringResource;

public final class CLDRHelper {
    private CLDRHelper() {
    }

    public static String getCode(String language, String country) {
        return !country.isEmpty() ? language + "-" + country : language;
    }

    public static String getLikelySubtags(String localeCode) {
        ResourceMap<StringResource> map = CLDRHelper.getLikelySubtagsMap();
        return map.has(localeCode) ? ((StringResource)map.get(localeCode)).getValue() : localeCode;
    }

    public static String resolveCountry(String language, String country) {
        if (country.isEmpty()) {
            String subtags = CLDRHelper.getLikelySubtags(language);
            int index = subtags.lastIndexOf(95);
            country = index > 0 ? subtags.substring(index + 1) : "";
        }
        return country;
    }

    @MetadataProvider(value=LikelySubtagsMetadataGenerator.class)
    private static native ResourceMap<StringResource> getLikelySubtagsMap();

    public static String[] resolveEras(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getErasMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getErasMap();

    public static String[] resolveAmPm(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getAmPmMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getAmPmMap();

    public static String[] resolveMonths(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getMonthMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getMonthMap();

    public static String[] resolveShortMonths(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getShortMonthMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getShortMonthMap();

    public static String[] resolveWeekdays(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getWeekdayMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getWeekdayMap();

    public static String[] resolveShortWeekdays(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getShortWeekdayMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getShortWeekdayMap();

    private static String[] resolveDateFormatSymbols(ResourceMap<ResourceArray<StringResource>> map, String language, String country) {
        String localeCode = CLDRHelper.getCode(language, country);
        ResourceArray arrayRes = map.has(localeCode) ? (ResourceArray)map.get(localeCode) : (map.has(language) ? (ResourceArray)map.get(language) : (ResourceArray)map.get("root"));
        String[] result = new String[arrayRes.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((StringResource)arrayRes.get(i)).getValue();
        }
        return result;
    }

    public static String getTimeZoneName(String language, String country, String id) {
        String locale = CLDRHelper.getCode(language, country);
        if (!CLDRHelper.getTimeZoneLocalizationMap().has(locale)) {
            locale = language;
        }
        if (!CLDRHelper.getTimeZoneLocalizationMap().has(locale)) {
            return null;
        }
        TimeZoneLocalization localization = (TimeZoneLocalization)CLDRHelper.getTimeZoneLocalizationMap().get(locale);
        int separator = id.indexOf(47);
        if (separator < 0) {
            return null;
        }
        String area = id.substring(0, separator);
        String territory = id.substring(separator + 1);
        if (!localization.getTimeZones().has(area)) {
            return null;
        }
        ResourceMap timeZones = (ResourceMap)localization.getTimeZones().get(area);
        if (!timeZones.has(territory)) {
            return null;
        }
        return ((StringResource)timeZones.get(territory)).getValue();
    }

    @MetadataProvider(value=TimeZoneLocalizationGenerator.class)
    public static native ResourceMap<TimeZoneLocalization> getTimeZoneLocalizationMap();

    @MetadataProvider(value=LanguageMetadataGenerator.class)
    public static native ResourceMap<ResourceMap<StringResource>> getLanguagesMap();

    @MetadataProvider(value=CountryMetadataGenerator.class)
    public static native ResourceMap<ResourceMap<StringResource>> getCountriesMap();

    @MetadataProvider(value=DefaultLocaleMetadataGenerator.class)
    public static native StringResource getDefaultLocale();

    @MetadataProvider(value=AvailableLocalesMetadataGenerator.class)
    public static native ResourceArray<StringResource> getAvailableLocales();

    @MetadataProvider(value=MinimalDaysInFirstWeekMetadataGenerator.class)
    public static native ResourceMap<IntResource> getMinimalDaysInFirstWeek();

    @MetadataProvider(value=FirstDayOfWeekMetadataGenerator.class)
    public static native ResourceMap<IntResource> getFirstDayOfWeek();

    public static DateFormatCollection resolveDateFormats(String language, String country) {
        return CLDRHelper.resolveDateFormats(CLDRHelper.getDateFormatMap(), language, country);
    }

    @MetadataProvider(value=DateFormatMetadataGenerator.class)
    private static native ResourceMap<DateFormatCollection> getDateFormatMap();

    public static DateFormatCollection resolveTimeFormats(String language, String country) {
        return CLDRHelper.resolveDateFormats(CLDRHelper.getTimeFormatMap(), language, country);
    }

    @MetadataProvider(value=DateFormatMetadataGenerator.class)
    private static native ResourceMap<DateFormatCollection> getTimeFormatMap();

    public static DateFormatCollection resolveDateTimeFormats(String language, String country) {
        return CLDRHelper.resolveDateFormats(CLDRHelper.getDateTimeFormatMap(), language, country);
    }

    @MetadataProvider(value=DateFormatMetadataGenerator.class)
    private static native ResourceMap<DateFormatCollection> getDateTimeFormatMap();

    public static String resolveNumberFormat(String language, String country) {
        return CLDRHelper.resolveFormatSymbols(CLDRHelper.getNumberFormatMap(), language, country);
    }

    @MetadataProvider(value=NumberFormatMetadataGenerator.class)
    private static native ResourceMap<StringResource> getNumberFormatMap();

    public static String resolvePercentFormat(String language, String country) {
        return CLDRHelper.resolveFormatSymbols(CLDRHelper.getPercentFormatMap(), language, country);
    }

    @MetadataProvider(value=NumberFormatMetadataGenerator.class)
    private static native ResourceMap<StringResource> getPercentFormatMap();

    public static String resolveCurrencyFormat(String language, String country) {
        return CLDRHelper.resolveFormatSymbols(CLDRHelper.getCurrencyFormatMap(), language, country);
    }

    @MetadataProvider(value=NumberFormatMetadataGenerator.class)
    private static native ResourceMap<StringResource> getCurrencyFormatMap();

    private static DateFormatCollection resolveDateFormats(ResourceMap<DateFormatCollection> map, String language, String country) {
        String localeCode = CLDRHelper.getCode(language, country);
        return map.has(localeCode) ? (DateFormatCollection)map.get(localeCode) : (map.has(language) ? (DateFormatCollection)map.get(language) : (DateFormatCollection)map.get("root"));
    }

    private static String resolveFormatSymbols(ResourceMap<StringResource> map, String language, String country) {
        String localeCode = CLDRHelper.getCode(language, country);
        StringResource res = map.has(localeCode) ? (StringResource)map.get(localeCode) : (map.has(language) ? (StringResource)map.get(language) : (StringResource)map.get("root"));
        return res.getValue();
    }

    public static DecimalData resolveDecimalData(String language, String country) {
        String localeCode;
        ResourceMap<DecimalData> map = CLDRHelper.getDecimalDataMap();
        return map.has(localeCode = CLDRHelper.getCode(language, country)) ? (DecimalData)map.get(localeCode) : (map.has(language) ? (DecimalData)map.get(language) : (DecimalData)map.get("root"));
    }

    @MetadataProvider(value=DecimalMetadataGenerator.class)
    private static native ResourceMap<DecimalData> getDecimalDataMap();

    public static CurrencyLocalization resolveCurrency(String language, String country, String currency) {
        ResourceMap currencies;
        String localeCode = CLDRHelper.getCode(language, country);
        ResourceMap<ResourceMap<CurrencyLocalization>> map = CLDRHelper.getCurrencyMap();
        if (map.has(localeCode) && (currencies = (ResourceMap)map.get(localeCode)).has(currency)) {
            return (CurrencyLocalization)currencies.get(currency);
        }
        if (map.has(language) && (currencies = (ResourceMap)map.get(language)).has(currency)) {
            return (CurrencyLocalization)currencies.get(currency);
        }
        return null;
    }

    @MetadataProvider(value=CurrencyLocalizationMetadataGenerator.class)
    private static native ResourceMap<ResourceMap<CurrencyLocalization>> getCurrencyMap();
}

