/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.jso.JSBody;

public class TDouble
extends TNumber
implements TComparable<TDouble> {
    public static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    public static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    public static final double NaN = TDouble.getNaN();
    public static final double MAX_VALUE = Double.MAX_VALUE;
    public static final double MIN_NORMAL = -4.49423283715579E307;
    public static final double MIN_VALUE = Double.MIN_VALUE;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_EXPONENT = -1022;
    public static final int SIZE = 64;
    public static final TClass<TDouble> TYPE = TClass.doubleClass();
    private double value;

    public TDouble(double value) {
        this.value = value;
    }

    public TDouble(TString value) throws TNumberFormatException {
        this.value = TDouble.parseDouble(value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    public static TDouble valueOf(double d) {
        return new TDouble(d);
    }

    public static String toString(double d) {
        return new TStringBuilder().append(d).toString();
    }

    public static TDouble valueOf(TString string) {
        return TDouble.valueOf(TDouble.parseDouble(string));
    }

    public static double parseDouble(TString string) throws TNumberFormatException {
        string = string.trim();
        boolean negative = false;
        int index = 0;
        if (string.charAt(index) == '-') {
            ++index;
            negative = true;
        } else if (string.charAt(index) == '+') {
            ++index;
        }
        char c = string.charAt(index);
        if (c < '0' || c > '9') {
            throw new TNumberFormatException();
        }
        long mantissa = 0L;
        int exp = 0;
        while (string.charAt(index) == '0') {
            if (++index != string.length()) continue;
            return 0.0;
        }
        while (index < string.length() && (c = string.charAt(index)) >= '0' && c <= '9') {
            if ((double)mantissa < 1.0E17) {
                mantissa = mantissa * 10L + (long)(c - 48);
            } else {
                ++exp;
            }
            ++index;
        }
        if (index < string.length() && string.charAt(index) == '.') {
            ++index;
            boolean hasOneDigit = false;
            while (index < string.length() && (c = string.charAt(index)) >= '0' && c <= '9') {
                if ((double)mantissa < 1.0E17) {
                    mantissa = mantissa * 10L + (long)(c - 48);
                    --exp;
                }
                ++index;
                hasOneDigit = true;
            }
            if (!hasOneDigit) {
                throw new TNumberFormatException();
            }
        }
        if (index < string.length()) {
            c = string.charAt(index);
            if (c != 'e' && c != 'E') {
                throw new TNumberFormatException();
            }
            boolean negativeExp = false;
            if (string.charAt(++index) == '-') {
                ++index;
                negativeExp = true;
            } else if (string.charAt(index) == '+') {
                ++index;
            }
            int numExp = 0;
            boolean hasOneDigit = false;
            while (index < string.length() && (c = string.charAt(index)) >= '0' && c <= '9') {
                numExp = 10 * numExp + (c - 48);
                hasOneDigit = true;
                ++index;
            }
            if (!hasOneDigit) {
                throw new TNumberFormatException();
            }
            if (negativeExp) {
                numExp = -numExp;
            }
            exp += numExp;
        }
        if (exp > 308 || exp == 308 && mantissa > 17976931348623157L) {
            return !negative ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (negative) {
            mantissa = -mantissa;
        }
        return (double)mantissa * TDouble.decimalExponent(exp);
    }

    public static double decimalExponent(int n) {
        double d;
        if (n < 0) {
            d = 0.1;
            n = -n;
        } else {
            d = 10.0;
        }
        double result = 1.0;
        while (n != 0) {
            if (n % 2 != 0) {
                result *= d;
            }
            d *= d;
            n /= 2;
        }
        return result;
    }

    @Override
    public String toString() {
        return TDouble.toString(this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TDouble && ((TDouble)other).value == this.value;
    }

    @Override
    public int hashCode() {
        long h = TDouble.doubleToLongBits(this.value);
        return (int)(h >>> 32) ^ ((int)h | 0);
    }

    public static int compare(double a, double b) {
        return a > b ? 1 : (a < b ? -1 : 0);
    }

    @Override
    public int compareTo(TDouble other) {
        return TDouble.compare(this.value, other.value);
    }

    public boolean isNaN() {
        return TDouble.isNaN(this.value);
    }

    public boolean isInfinite() {
        return TDouble.isInfinite(this.value);
    }

    @JSBody(params={"v"}, script="return isNaN(v);")
    public static native boolean isNaN(double var0);

    @JSBody(params={}, script="return NaN;")
    private static native double getNaN();

    @JSBody(params={"v"}, script="return !isFinite(v);")
    public static native boolean isInfinite(double var0);

    public static long doubleToRawLongBits(double value) {
        return TDouble.doubleToLongBits(value);
    }

    public static long doubleToLongBits(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return 0x7FF0000000000000L;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return -4503599627370496L;
        }
        if (TDouble.isNaN(value)) {
            return 9221120237041090560L;
        }
        double abs = TMath.abs(value);
        int exp = TMath.getExponent(abs);
        int negExp = -exp + 52;
        if (exp < -1022) {
            exp = -1023;
            negExp = 1074;
        }
        double doubleMantissa = negExp <= 1022 ? abs * TDouble.binaryExponent(negExp) : abs * 4.49423283715579E307 * TDouble.binaryExponent(negExp - 1022);
        long mantissa = (long)(doubleMantissa + 0.5) & 0xFFFFFFFFFFFFFL;
        return mantissa | (long)exp + 1023L << 52 | (value < 0.0 || 1.0 / value == Double.NEGATIVE_INFINITY ? Long.MIN_VALUE : 0L);
    }

    public static double longBitsToDouble(long bits) {
        if ((bits & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
            if (bits == 0x7FF0000000000000L) {
                return Double.POSITIVE_INFINITY;
            }
            if (bits == -4503599627370496L) {
                return Double.NEGATIVE_INFINITY;
            }
            return NaN;
        }
        boolean negative = (bits & Long.MIN_VALUE) != 0L;
        int rawExp = (int)(bits >> 52 & 0x7FFL);
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        mantissa = rawExp == 0 ? (mantissa <<= 1) : (mantissa |= 0x10000000000000L);
        double value = (double)mantissa * TDouble.binaryExponent(rawExp - 1023 - 52);
        return !negative ? value : -value;
    }

    public static TString toHexString(double d) {
        if (TDouble.isNaN(d)) {
            return TString.wrap("NaN");
        }
        if (TDouble.isInfinite(d)) {
            return d > 0.0 ? TString.wrap("Infinity") : TString.wrap("-Infinity");
        }
        char[] buffer = new char[30];
        int sz = 0;
        long bits = TDouble.doubleToLongBits(d);
        boolean subNormal = false;
        int exp = (int)(bits >>> 52 & 0x7FFL) - 1023;
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        if (exp == -1023) {
            ++exp;
            subNormal = true;
        }
        for (int i = 0; i < 13; ++i) {
            int digit = (int)(mantissa & 0xFL);
            if (digit > 0 || sz > 0) {
                buffer[sz++] = TCharacter.forDigit(digit, 16);
            }
            mantissa >>>= 4;
        }
        if (sz == 0) {
            buffer[sz++] = 48;
        }
        buffer[sz++] = 46;
        buffer[sz++] = subNormal ? 48 : 49;
        buffer[sz++] = 120;
        buffer[sz++] = 48;
        if ((bits & Long.MIN_VALUE) != 0L) {
            buffer[sz++] = 45;
        }
        int half = sz / 2;
        for (int i = 0; i < half; ++i) {
            char tmp = buffer[i];
            buffer[i] = buffer[sz - i - 1];
            buffer[sz - i - 1] = tmp;
        }
        buffer[sz++] = 112;
        if (exp < 0) {
            exp = -exp;
            buffer[sz++] = 45;
        }
        int pos = 1000;
        boolean first = true;
        for (int i = 0; i < 4; ++i) {
            int digit = exp / pos;
            if (digit > 0 || !first) {
                buffer[sz++] = TCharacter.forDigit(digit, 10);
                first = false;
            }
            exp %= pos;
            pos /= 10;
        }
        if (first) {
            buffer[sz++] = 48;
        }
        return new TString(buffer, 0, sz);
    }

    private static double binaryExponent(int n) {
        double result = 1.0;
        if (n >= 0) {
            double d = 2.0;
            while (n != 0) {
                if (n % 2 != 0) {
                    result *= d;
                }
                n /= 2;
                d *= d;
            }
        } else {
            n = -n;
            double d = 0.5;
            while (n != 0) {
                if (n % 2 != 0) {
                    result *= d;
                }
                n /= 2;
                d *= d;
            }
        }
        return result;
    }
}

