/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.io.TPrintStream;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TIllegalStateException;
import org.teavm.classlib.java.lang.TStackTraceElement;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TSystem;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.javascript.spi.Remove;
import org.teavm.javascript.spi.Rename;
import org.teavm.javascript.spi.Superclass;

@Superclass(value="java.lang.Object")
public class TThrowable
extends RuntimeException {
    private static final long serialVersionUID = 2026791432677149320L;
    private TString message;
    private TThrowable cause;
    private boolean suppressionEnabled;
    private boolean writableStackTrace;
    private TThrowable[] suppressed = new TThrowable[0];

    @Rename(value="fakeInit")
    protected TThrowable(TString message, TThrowable cause, boolean enableSuppression, boolean writableStackTrace) {
    }

    @Rename(value="<init>")
    public void init(TString message, TThrowable cause, boolean enableSuppression, boolean writableStackTrace) {
        if (writableStackTrace) {
            this.fillInStackTrace();
        }
        this.suppressionEnabled = enableSuppression;
        this.writableStackTrace = writableStackTrace;
        this.message = message;
        this.cause = cause;
    }

    @Rename(value="fakeInit")
    public TThrowable() {
    }

    @Rename(value="<init>")
    private void init() {
        this.suppressionEnabled = true;
        this.writableStackTrace = true;
        this.fillInStackTrace();
    }

    @Rename(value="fakeInit")
    public TThrowable(TString message) {
    }

    @Rename(value="<init>")
    private void init(TString message) {
        this.suppressionEnabled = true;
        this.writableStackTrace = true;
        this.fillInStackTrace();
        this.message = message;
    }

    @Rename(value="fakeInit")
    public TThrowable(TString message, TThrowable cause) {
    }

    @Rename(value="<init>")
    private void init(TString message, TThrowable cause) {
        this.suppressionEnabled = true;
        this.writableStackTrace = true;
        this.fillInStackTrace();
        this.message = message;
        this.cause = cause;
    }

    @Rename(value="fakeInit")
    public TThrowable(TThrowable cause) {
    }

    @Rename(value="<init>")
    private void init(TThrowable cause) {
        this.suppressionEnabled = true;
        this.writableStackTrace = true;
        this.fillInStackTrace();
        this.cause = cause;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Rename(value="getMessage")
    public TString getMessage0() {
        return this.message;
    }

    @Rename(value="getLocalizedMessage")
    public TString getLocalizedMessage0() {
        return TString.wrap(this.getMessage());
    }

    @Override
    public TThrowable getCause() {
        return this.cause != this ? this.cause : null;
    }

    @Remove
    public native TClass<?> getClass0();

    @Remove
    public native TString toString0();

    public TThrowable initCause(TThrowable cause) {
        if (this.cause != this && this.cause != null) {
            throw new TIllegalStateException(TString.wrap("Cause already set"));
        }
        if (cause == this) {
            throw new TIllegalArgumentException(TString.wrap("Circular causation relation"));
        }
        this.cause = cause;
        return this;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(TSystem.err);
    }

    public void printStackTrace(TPrintStream stream) {
        stream.println(TString.wrap(this.getClass().getName() + ": " + this.getMessage()));
    }

    @Rename(value="getStackTrace")
    public TStackTraceElement[] getStackTrace0() {
        return new TStackTraceElement[0];
    }

    public void setStackTrace(TStackTraceElement[] stackTrace) {
    }

    @Rename(value="getSuppressed")
    public final TThrowable[] getSuppressed0() {
        return TArrays.copyOf(this.suppressed, this.suppressed.length);
    }

    public final void addSuppressed(TThrowable exception) {
        if (!this.suppressionEnabled) {
            return;
        }
        this.suppressed = TArrays.copyOf(this.suppressed, this.suppressed.length + 1);
        this.suppressed[this.suppressed.length - 1] = exception;
    }
}

