/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.THashMap;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.javascript.spi.Rename;

public class THashSet<E>
extends TAbstractSet<E>
implements TCloneable,
TSerializable {
    transient THashMap<E, THashSet<E>> backingMap;

    public THashSet() {
        this(new THashMap());
    }

    public THashSet(int capacity) {
        this(new THashMap(capacity));
    }

    public THashSet(int capacity, float loadFactor) {
        this(new THashMap(capacity, loadFactor));
    }

    public THashSet(TCollection<? extends E> collection) {
        this(new THashMap(collection.size() < 6 ? 11 : collection.size() * 2));
        TIterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    THashSet(THashMap<E, THashSet<E>> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    public boolean add(E object) {
        return this.backingMap.put(object, this) == null;
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Rename(value="clone")
    public TObject clone0() {
        try {
            THashSet clone = (THashSet)super.clone();
            clone.backingMap = (THashMap)this.backingMap.clone();
            return clone;
        }
        catch (TCloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public TIterator<E> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.backingMap.remove(object) != null;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    THashMap<E, THashSet<E>> createBackingMap(int capacity, float loadFactor) {
        return new THashMap(capacity, loadFactor);
    }

    @Override
    public Object clone() {
        return new THashSet<E>(this);
    }
}

