/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.lambda;

import java.util.Arrays;
import org.teavm.cache.NoCache;
import org.teavm.dependency.BootstrapMethodSubstitutor;
import org.teavm.dependency.DynamicCallSite;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodHolder;
import org.teavm.model.PrimitiveType;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;

public class LambdaMetafactorySubstitutor
implements BootstrapMethodSubstitutor {
    private int lambdaIndex = 0;

    public ValueEmitter substitute(DynamicCallSite callSite, ProgramEmitter callerPe) {
        int i;
        ValueType[] invokedType = callSite.getCalledMethod().getSignature();
        ValueType[] samMethodType = ((RuntimeConstant)callSite.getBootstrapArguments().get(0)).getMethodType();
        MethodHandle implMethod = ((RuntimeConstant)callSite.getBootstrapArguments().get(1)).getMethodHandle();
        ValueType[] instantiatedMethodType = ((RuntimeConstant)callSite.getBootstrapArguments().get(2)).getMethodType();
        String samName = ((ValueType.Object)callSite.getCalledMethod().getResultType()).getClassName();
        ClassReaderSource classSource = callSite.getAgent().getClassSource();
        ClassReader samClass = classSource.get(samName);
        ClassHolder implementor = new ClassHolder("$$LAMBDA" + this.lambdaIndex++ + "$$");
        implementor.setLevel(AccessLevel.PUBLIC);
        if (samClass != null && samClass.hasModifier(ElementModifier.INTERFACE)) {
            implementor.setParent("java.lang.Object");
            implementor.getInterfaces().add(samName);
        } else {
            implementor.setParent(samName);
        }
        int capturedVarCount = callSite.getCalledMethod().parameterCount();
        MethodHolder ctor = this.createConstructor(classSource, implementor, Arrays.copyOfRange(invokedType, 0, capturedVarCount));
        ctor.getAnnotations().add(new AnnotationHolder(NoCache.class.getName()));
        this.createBridge(classSource, implementor, callSite.getCalledMethod().getName(), instantiatedMethodType, samMethodType);
        MethodHolder worker = new MethodHolder(callSite.getCalledMethod().getName(), instantiatedMethodType);
        worker.getAnnotations().add(new AnnotationHolder(NoCache.class.getName()));
        worker.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)worker, (ClassReaderSource)callSite.getAgent().getClassSource());
        ValueEmitter thisVar = pe.var(0, (ClassReader)implementor);
        ValueEmitter[] arguments = new ValueEmitter[instantiatedMethodType.length - 1];
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            arguments[i2] = pe.var(i2 + 1, instantiatedMethodType[i2]);
        }
        ValueType[] implementorSignature = this.getSignature(implMethod);
        ValueEmitter[] passedArguments = new ValueEmitter[implementorSignature.length - 1];
        for (i = 0; i < capturedVarCount; ++i) {
            passedArguments[i] = thisVar.getField("_" + i, invokedType[i]);
        }
        for (i = 0; i < instantiatedMethodType.length - 1; ++i) {
            passedArguments[i + capturedVarCount] = this.tryConvertArgument(arguments[i], instantiatedMethodType[i], implementorSignature[i + capturedVarCount]);
        }
        ValueEmitter result = this.invoke(pe, implMethod, passedArguments);
        if (result != null) {
            ValueType actualResult = implementorSignature[implementorSignature.length - 1];
            ValueType expectedResult = instantiatedMethodType[instantiatedMethodType.length - 1];
            this.tryConvertArgument(result, actualResult, expectedResult).returnValue();
        } else {
            pe.exit();
        }
        implementor.addMethod(worker);
        callSite.getAgent().submitClass(implementor);
        return callerPe.construct(ctor.getOwnerName(), callSite.getArguments().toArray(new ValueEmitter[0]));
    }

    private ValueEmitter invoke(ProgramEmitter pe, MethodHandle handle, ValueEmitter[] arguments) {
        switch (handle.getKind()) {
            case GET_FIELD: {
                return arguments[0].getField(handle.getName(), handle.getValueType());
            }
            case GET_STATIC_FIELD: {
                return pe.getField(handle.getClassName(), handle.getName(), handle.getValueType());
            }
            case PUT_FIELD: {
                arguments[0].setField(handle.getName(), arguments[0].cast(handle.getValueType()));
                return null;
            }
            case PUT_STATIC_FIELD: {
                pe.setField(handle.getClassName(), handle.getName(), arguments[0].cast(handle.getValueType()));
                return null;
            }
            case INVOKE_VIRTUAL: 
            case INVOKE_INTERFACE: 
            case INVOKE_SPECIAL: {
                for (int i = 1; i < arguments.length; ++i) {
                    arguments[i] = arguments[i].cast(handle.getArgumentType(i - 1));
                }
                arguments[0] = arguments[0].cast(ValueType.object((String)handle.getClassName()));
                return arguments[0].invokeVirtual(handle.getName(), handle.getValueType(), Arrays.copyOfRange(arguments, 1, arguments.length));
            }
            case INVOKE_STATIC: {
                for (int i = 0; i < arguments.length; ++i) {
                    arguments[i] = arguments[i].cast(handle.getArgumentType(i));
                }
                return pe.invoke(handle.getClassName(), handle.getName(), handle.getValueType(), arguments);
            }
            case INVOKE_CONSTRUCTOR: {
                return pe.construct(handle.getClassName(), arguments);
            }
        }
        throw new IllegalArgumentException("Unexpected handle type: " + handle.getKind());
    }

    private ValueEmitter tryConvertArgument(ValueEmitter arg, ValueType from, ValueType to) {
        if (from.equals((Object)to)) {
            return arg;
        }
        if (from instanceof ValueType.Primitive && to instanceof ValueType.Primitive) {
            return arg.cast(to);
        }
        if (from instanceof ValueType.Primitive && to instanceof ValueType.Object) {
            String primitiveClass = ((ValueType.Object)to).getClassName();
            PrimitiveType toType = this.getWrappedPrimitive(primitiveClass);
            if (toType == null) {
                return arg;
            }
            arg = this.tryConvertArgument(arg, from, ValueType.primitive((PrimitiveType)toType));
            return arg.getProgramEmitter().invoke(primitiveClass, "valueOf", ValueType.primitive((PrimitiveType)toType), new ValueEmitter[]{arg});
        }
        if (from instanceof ValueType.Object && to instanceof ValueType.Primitive) {
            String primitiveClass = ((ValueType.Object)from).getClassName();
            PrimitiveType fromType = this.getWrappedPrimitive(primitiveClass);
            if (fromType == null) {
                return arg;
            }
            arg = arg.invokeVirtual(this.primitiveName(fromType) + "Value", ValueType.primitive((PrimitiveType)fromType), new ValueEmitter[0]);
            return this.tryConvertArgument(arg, ValueType.primitive((PrimitiveType)fromType), to);
        }
        return arg.cast(to);
    }

    private PrimitiveType getWrappedPrimitive(String name) {
        switch (name) {
            case "java.lang.Boolean": {
                return PrimitiveType.BOOLEAN;
            }
            case "java.lang.Byte": {
                return PrimitiveType.BYTE;
            }
            case "java.lang.Short": {
                return PrimitiveType.SHORT;
            }
            case "java.lang.Character": {
                return PrimitiveType.CHARACTER;
            }
            case "java.lang.Integer": {
                return PrimitiveType.INTEGER;
            }
            case "java.lang.Long": {
                return PrimitiveType.LONG;
            }
            case "java.lang.Float": {
                return PrimitiveType.FLOAT;
            }
            case "java.lang.Double": {
                return PrimitiveType.DOUBLE;
            }
        }
        return null;
    }

    private String primitiveName(PrimitiveType type) {
        switch (type) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case SHORT: {
                return "short";
            }
            case CHARACTER: {
                return "char";
            }
            case INTEGER: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
        }
        throw new IllegalArgumentException("Unexpected primitive " + type);
    }

    private ValueType[] getSignature(MethodHandle handle) {
        switch (handle.getKind()) {
            case GET_FIELD: {
                return new ValueType[]{ValueType.object((String)handle.getClassName()), handle.getValueType()};
            }
            case GET_STATIC_FIELD: {
                return new ValueType[]{handle.getValueType()};
            }
            case PUT_FIELD: {
                return new ValueType[]{ValueType.object((String)handle.getClassName()), handle.getValueType(), ValueType.VOID};
            }
            case PUT_STATIC_FIELD: {
                return new ValueType[]{handle.getValueType(), ValueType.VOID};
            }
            case INVOKE_VIRTUAL: 
            case INVOKE_INTERFACE: 
            case INVOKE_SPECIAL: {
                ValueType[] signature = handle.signature();
                ValueType[] result = new ValueType[signature.length + 1];
                System.arraycopy(signature, 0, result, 1, signature.length);
                result[0] = ValueType.object((String)handle.getClassName());
                return result;
            }
        }
        return handle.signature();
    }

    private MethodHolder createConstructor(ClassReaderSource classSource, ClassHolder implementor, ValueType[] types) {
        ValueType[] signature = Arrays.copyOf(types, types.length + 1);
        signature[types.length] = ValueType.VOID;
        MethodHolder ctor = new MethodHolder("<init>", signature);
        ctor.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)ctor, (ClassReaderSource)classSource);
        ValueEmitter thisVar = pe.var(0, (ClassReader)implementor);
        thisVar.invokeSpecial(implementor.getParent(), "<init>", new ValueEmitter[0]);
        for (int i = 0; i < types.length; ++i) {
            FieldHolder field = new FieldHolder("_" + i);
            field.setLevel(AccessLevel.PRIVATE);
            field.setType(types[i]);
            implementor.addField(field);
            thisVar.setField(field.getName(), pe.var(i + 1, types[i]));
        }
        pe.exit();
        implementor.addMethod(ctor);
        return ctor;
    }

    private void createBridge(ClassReaderSource classSource, ClassHolder implementor, String name, ValueType[] types, ValueType[] bridgeTypes) {
        int i;
        if (Arrays.equals(types, bridgeTypes)) {
            return;
        }
        MethodHolder bridge = new MethodHolder(name, bridgeTypes);
        bridge.getAnnotations().add(new AnnotationHolder(NoCache.class.getName()));
        bridge.setLevel(AccessLevel.PUBLIC);
        bridge.getModifiers().add(ElementModifier.BRIDGE);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)bridge, (ClassReaderSource)classSource);
        ValueEmitter thisVar = pe.var(0, (ClassReader)implementor);
        ValueEmitter[] arguments = new ValueEmitter[bridgeTypes.length - 1];
        for (i = 0; i < arguments.length; ++i) {
            arguments[i] = pe.var(i + 1, bridgeTypes[i]);
        }
        for (i = 0; i < bridgeTypes.length - 1; ++i) {
            ValueType type = types[i];
            ValueType bridgeType = bridgeTypes[i];
            if (type.equals((Object)bridgeType)) continue;
            arguments[i] = arguments[i].cast(type);
        }
        ValueEmitter result = thisVar.invokeVirtual(name, types[types.length - 1], arguments);
        if (result != null) {
            if (!types[types.length - 1].equals((Object)bridgeTypes[bridgeTypes.length - 1])) {
                result = result.cast(bridgeTypes[bridgeTypes.length - 1]);
            }
            result.returnValue();
        } else {
            pe.exit();
        }
        implementor.addMethod(bridge);
    }
}

