/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import org.teavm.classlib.impl.unicode.CLDRHelper;
import org.teavm.classlib.impl.unicode.DecimalData;
import org.teavm.classlib.java.util.TLocale;

public class TDecimalFormatSymbols
implements Cloneable {
    private TLocale locale;
    private char zeroDigit;
    private char groupingSeparator;
    private char decimalSeparator;
    private char perMill;
    private char percent;
    private char digit;
    private char patternSeparator;
    private String NaN;
    private String infinity;
    private char minusSign;
    private char monetaryDecimalSeparator;
    private String exponentSeparator;

    public TDecimalFormatSymbols() {
        this(TLocale.getDefault());
    }

    public TDecimalFormatSymbols(TLocale locale) {
        this.locale = locale;
        this.initData();
    }

    private void initData() {
        DecimalData data = CLDRHelper.resolveDecimalData(this.locale.getLanguage(), this.locale.getCountry());
        this.zeroDigit = (char)48;
        this.groupingSeparator = (char)data.getGroupingSeparator();
        this.decimalSeparator = (char)data.getDecimalSeparator();
        this.perMill = (char)data.getPerMille();
        this.percent = (char)data.getPercent();
        this.digit = (char)35;
        this.patternSeparator = (char)59;
        this.NaN = data.getNaN();
        this.infinity = data.getInfinity();
        this.minusSign = (char)data.getMinusSign();
        this.monetaryDecimalSeparator = (char)data.getDecimalSeparator();
        this.exponentSeparator = data.getExponentSeparator();
    }

    public static TLocale[] getAvailableLocales() {
        return TLocale.getAvailableLocales();
    }

    public static final TDecimalFormatSymbols getInstance() {
        return new TDecimalFormatSymbols();
    }

    public static final TDecimalFormatSymbols getInstance(TLocale locale) {
        return new TDecimalFormatSymbols(locale);
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public void setZeroDigit(char zeroDigit) {
        this.zeroDigit = zeroDigit;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public void setPerMill(char perMill) {
        this.perMill = perMill;
    }

    public char getPercent() {
        return this.percent;
    }

    public void setPercent(char percent) {
        this.percent = percent;
    }

    public TLocale getLocale() {
        return this.locale;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public char getDigit() {
        return this.digit;
    }

    public void setDigit(char digit) {
        this.digit = digit;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public void setPatternSeparator(char patternSeparator) {
        this.patternSeparator = patternSeparator;
    }

    public String getNaN() {
        return this.NaN;
    }

    public void setNaN(String naN) {
        this.NaN = naN;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public void setInfinity(String infinity) {
        this.infinity = infinity;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public void setMinusSign(char minusSign) {
        this.minusSign = minusSign;
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetaryDecimalSeparator;
    }

    public void setMonetaryDecimalSeparator(char monetaryDecimalSeparator) {
        this.monetaryDecimalSeparator = monetaryDecimalSeparator;
    }

    public String getExponentSeparator() {
        return this.exponentSeparator;
    }

    public void setExponentSeparator(String exponentSeparator) {
        this.exponentSeparator = exponentSeparator;
    }

    public void setLocale(TLocale locale) {
        this.locale = locale;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("This exception should not been thrown", e);
        }
    }
}

