/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TJointSet;
import org.teavm.classlib.java.util.regex.TLexer;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;

class THangulDecomposedCharSet
extends TJointSet {
    private char[] decomposedChar;
    private String decomposedCharUTF16 = null;
    private int decomposedCharLength;

    public THangulDecomposedCharSet(char[] decomposedChar, int decomposedCharLength) {
        this.decomposedChar = decomposedChar;
        this.decomposedCharLength = decomposedCharLength;
    }

    @Override
    public TAbstractSet getNext() {
        return this.next;
    }

    @Override
    public void setNext(TAbstractSet next) {
        this.next = next;
    }

    private String getDecomposedChar() {
        return this.decomposedCharUTF16 == null ? (this.decomposedCharUTF16 = new String(this.decomposedChar)) : this.decomposedCharUTF16;
    }

    @Override
    protected String getName() {
        return "decomposed Hangul syllable:" + this.getDecomposedChar();
    }

    @Override
    public int matches(int strIndex, CharSequence testString, TMatchResultImpl matchResult) {
        char curSymb;
        int[] decompCurSymb;
        int rightBound = matchResult.getRightBound();
        int SyllIndex = 0;
        int[] decompSyllable = new int[3];
        int LIndex = -1;
        int VIndex = -1;
        int TIndex = -1;
        if (strIndex >= rightBound) {
            return -1;
        }
        if ((decompCurSymb = TLexer.getHangulDecomposition(curSymb = testString.charAt(strIndex++))) == null) {
            decompSyllable[SyllIndex++] = curSymb;
            LIndex = curSymb - 4352;
            if (LIndex < 0 || LIndex >= 19) {
                return -1;
            }
            if (strIndex < rightBound) {
                curSymb = testString.charAt(strIndex);
                VIndex = curSymb - 4449;
            }
            if (VIndex < 0 || VIndex >= 21) {
                return -1;
            }
            decompSyllable[SyllIndex++] = curSymb;
            if (++strIndex < rightBound) {
                curSymb = testString.charAt(strIndex);
                TIndex = curSymb - 4519;
            }
            if (TIndex < 0 || TIndex >= 28) {
                return this.decomposedCharLength == 2 && decompSyllable[0] == this.decomposedChar[0] && decompSyllable[1] == this.decomposedChar[1] ? this.next.matches(strIndex, testString, matchResult) : -1;
            }
            decompSyllable[SyllIndex++] = curSymb;
            return this.decomposedCharLength == 3 && decompSyllable[0] == this.decomposedChar[0] && decompSyllable[1] == this.decomposedChar[1] && decompSyllable[2] == this.decomposedChar[2] ? this.next.matches(++strIndex, testString, matchResult) : -1;
        }
        if (decompCurSymb.length != this.decomposedCharLength) {
            return -1;
        }
        for (int i = 0; i < this.decomposedCharLength; ++i) {
            if (decompCurSymb[i] == this.decomposedChar[i]) continue;
            return -1;
        }
        return this.next.matches(strIndex, testString, matchResult);
    }

    @Override
    public boolean first(TAbstractSet set) {
        return set instanceof THangulDecomposedCharSet ? ((THangulDecomposedCharSet)set).getDecomposedChar().equals(this.getDecomposedChar()) : true;
    }

    @Override
    public boolean hasConsumed(TMatchResultImpl matchResult) {
        return true;
    }
}

