/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TLeafSet;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;
import org.teavm.classlib.java.util.regex.TRangeSet;
import org.teavm.classlib.java.util.regex.TSupplCharSet;
import org.teavm.classlib.java.util.regex.TSupplRangeSet;

class TCharSet
extends TLeafSet {
    private char ch = '\u0000';

    public TCharSet(char ch) {
        this.ch = ch;
    }

    @Override
    public int charCount() {
        return 1;
    }

    @Override
    public int accepts(int strIndex, CharSequence testString) {
        return this.ch == testString.charAt(strIndex) ? 1 : -1;
    }

    @Override
    public int find(int strIndex, CharSequence testString, TMatchResultImpl matchResult) {
        if (testString instanceof String) {
            String testStr = (String)testString;
            int strLength = matchResult.getRightBound();
            while (strIndex < strLength) {
                if ((strIndex = testStr.indexOf(this.ch, strIndex)) < 0) {
                    return -1;
                }
                if (this.next.matches(strIndex + 1, testString, matchResult) >= 0) {
                    return strIndex;
                }
                ++strIndex;
            }
            return -1;
        }
        return super.find(strIndex, testString, matchResult);
    }

    @Override
    public int findBack(int strIndex, int lastIndex, CharSequence testString, TMatchResultImpl matchResult) {
        if (testString instanceof String) {
            String testStr = (String)testString;
            while (lastIndex >= strIndex) {
                if ((lastIndex = testStr.lastIndexOf(this.ch, lastIndex)) < 0 || lastIndex < strIndex) {
                    return -1;
                }
                if (this.next.matches(lastIndex + 1, testString, matchResult) >= 0) {
                    return lastIndex;
                }
                --lastIndex;
            }
            return -1;
        }
        return super.findBack(strIndex, lastIndex, testString, matchResult);
    }

    @Override
    protected String getName() {
        return "" + this.ch;
    }

    protected char getChar() {
        return this.ch;
    }

    @Override
    public boolean first(TAbstractSet set) {
        if (set instanceof TCharSet) {
            return ((TCharSet)set).getChar() == this.ch;
        }
        if (set instanceof TRangeSet) {
            return ((TRangeSet)set).accepts(0, Character.toString(this.ch)) > 0;
        }
        if (set instanceof TSupplRangeSet) {
            return ((TSupplRangeSet)set).contains(this.ch);
        }
        return !(set instanceof TSupplCharSet);
    }
}

