/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import org.teavm.classlib.java.io.TFilterInputStream;
import org.teavm.classlib.java.io.TIOException;
import org.teavm.classlib.java.io.TInputStream;
import org.teavm.classlib.java.lang.TArrayIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TString;

public class TPushbackInputStream
extends TFilterInputStream {
    protected byte[] buf;
    protected int pos;

    public TPushbackInputStream(TInputStream in) {
        super(in);
        this.buf = in == null ? null : new byte[1];
        this.pos = 1;
    }

    public TPushbackInputStream(TInputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive");
        }
        this.buf = in == null ? null : new byte[size];
        this.pos = size;
    }

    @Override
    public int available() throws TIOException {
        if (this.buf == null) {
            throw new TIOException();
        }
        return this.buf.length - this.pos + this.in.available();
    }

    @Override
    public void close() throws TIOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
            this.buf = null;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws TIOException {
        if (this.buf == null) {
            throw new TIOException();
        }
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws TIOException {
        if (this.buf == null) {
            throw new TIOException(TString.wrap("Stream is closed"));
        }
        if (offset > buffer.length || offset < 0) {
            throw new TArrayIndexOutOfBoundsException(TString.wrap("Offset out of bounds: " + offset));
        }
        if (length < 0 || length > buffer.length - offset) {
            throw new TArrayIndexOutOfBoundsException(TString.wrap("Length out of bounds: " + length));
        }
        int copiedBytes = 0;
        int copyLength = 0;
        int newOffset = offset;
        if (this.pos < this.buf.length) {
            copyLength = this.buf.length - this.pos >= length ? length : this.buf.length - this.pos;
            System.arraycopy(this.buf, this.pos, buffer, newOffset, copyLength);
            newOffset += copyLength;
            copiedBytes += copyLength;
            this.pos += copyLength;
        }
        if (copyLength == length) {
            return length;
        }
        int inCopied = this.in.read(buffer, newOffset, length - copiedBytes);
        if (inCopied > 0) {
            return inCopied + copiedBytes;
        }
        if (copiedBytes == 0) {
            return inCopied;
        }
        return copiedBytes;
    }

    @Override
    public long skip(long count) throws TIOException {
        if (this.in == null) {
            throw new TIOException();
        }
        if (count <= 0L) {
            return 0L;
        }
        int numSkipped = 0;
        if (this.pos < this.buf.length) {
            numSkipped = (int)((long)numSkipped + (count < (long)(this.buf.length - this.pos) ? count : (long)(this.buf.length - this.pos)));
            this.pos += numSkipped;
        }
        if ((long)numSkipped < count) {
            numSkipped = (int)((long)numSkipped + this.in.skip(count - (long)numSkipped));
        }
        return numSkipped;
    }

    public void unread(byte[] buffer) throws TIOException {
        this.unread(buffer, 0, buffer.length);
    }

    public void unread(byte[] buffer, int offset, int length) throws TIOException {
        if (length > this.pos) {
            throw new TIOException(TString.wrap("Pushback buffer full"));
        }
        if (offset > buffer.length || offset < 0) {
            throw new TArrayIndexOutOfBoundsException(TString.wrap("Offset out of bounds: " + offset));
        }
        if (length < 0 || length > buffer.length - offset) {
            throw new TArrayIndexOutOfBoundsException(TString.wrap("Length out of bounds: " + length));
        }
        if (this.buf == null) {
            throw new TIOException(TString.wrap("Stream is closed"));
        }
        System.arraycopy(buffer, offset, this.buf, this.pos - length, length);
        this.pos -= length;
    }

    public void unread(int oneByte) throws TIOException {
        if (this.buf == null) {
            throw new TIOException();
        }
        if (this.pos == 0) {
            throw new TIOException();
        }
        this.buf[--this.pos] = (byte)oneByte;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws TIOException {
        throw new TIOException();
    }
}

