/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.classlib.impl.CharFlow;

public class Base46 {
    public static void encodeUnsigned(StringBuilder sb, int number) {
        boolean hasMore;
        do {
            int digit = number % 46;
            hasMore = (number /= 46) > 0;
            digit = digit * 2 + (hasMore ? 1 : 0);
            sb.append(Base46.encodeDigit(digit));
        } while (hasMore);
    }

    public static void encode(StringBuilder sb, int number) {
        Base46.encodeUnsigned(sb, Math.abs(number) * 2 + (number >= 0 ? 0 : 1));
    }

    public static void encodeUnsigned(StringBuilder sb, long number) {
        boolean hasMore;
        do {
            int digit = (int)(number % 46L);
            hasMore = (number /= 46L) > 0L;
            digit = digit * 2 + (hasMore ? 1 : 0);
            sb.append(Base46.encodeDigit(digit));
        } while (hasMore);
    }

    public static void encode(StringBuilder sb, long number) {
        Base46.encodeUnsigned(sb, Math.abs(number) * 2L + (long)(number >= 0L ? 0 : 1));
    }

    public static int decodeUnsigned(CharFlow seq) {
        boolean hasMore;
        int number = 0;
        int pos = 1;
        do {
            int digit;
            hasMore = (digit = Base46.decodeDigit(seq.characters[seq.pointer++])) % 2 == 1;
            number += pos * (digit / 2);
            pos *= 46;
        } while (hasMore);
        return number;
    }

    public static int decode(CharFlow seq) {
        int number = Base46.decodeUnsigned(seq);
        int result = number / 2;
        if (number % 2 != 0) {
            result = -result;
        }
        return result;
    }

    public static long decodeUnsignedLong(CharFlow seq) {
        boolean hasMore;
        long number = 0L;
        long pos = 1L;
        do {
            int digit;
            hasMore = (digit = Base46.decodeDigit(seq.characters[seq.pointer++])) % 2 == 1;
            number += pos * (long)(digit / 2);
            pos *= 46L;
        } while (hasMore);
        return number;
    }

    public static long decodeLong(CharFlow seq) {
        long number = Base46.decodeUnsigned(seq);
        long result = number / 2L;
        if (number % 2L != 0L) {
            result = -result;
        }
        return result;
    }

    public static char encodeDigit(int digit) {
        if (digit < 2) {
            return (char)(digit + 32);
        }
        if (digit < 59) {
            return (char)(digit + 1 + 32);
        }
        return (char)(digit + 2 + 32);
    }

    public static int decodeDigit(char c) {
        if (c < '\"') {
            return c - 32;
        }
        if (c < '\\') {
            return c - 32 - 1;
        }
        return c - 32 - 2;
    }
}

