/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import java.util.ArrayList;
import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TMatchResult;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;
import org.teavm.classlib.java.util.regex.TPattern;

public final class TMatcher
implements TMatchResult {
    static int MODE_FIND = 1;
    static int MODE_MATCH = 2;
    private TPattern pat = null;
    private TAbstractSet start = null;
    private CharSequence string = null;
    private TMatchResultImpl matchResult = null;
    private int leftBound = -1;
    private int rightBound = -1;
    private int appendPos = 0;
    private String replacement = null;
    private String processedRepl = null;
    private ArrayList<Object> replacementParts = null;

    public TMatcher appendReplacement(StringBuffer buffer, String replacement) {
        this.processedRepl = this.processReplacement(replacement);
        buffer.append(this.string.subSequence(this.appendPos, this.start()));
        buffer.append(this.processedRepl);
        this.appendPos = this.end();
        return this;
    }

    private String processReplacement(String replacement) {
        if (this.replacement != null && this.replacement.equals(replacement)) {
            if (this.replacementParts == null) {
                return this.processedRepl;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.replacementParts.size(); ++i) {
                sb.append(this.replacementParts.get(i));
            }
            return sb.toString();
        }
        this.replacement = replacement;
        char[] repl = replacement.toCharArray();
        StringBuilder res = new StringBuilder();
        this.replacementParts = null;
        int replacementPos = 0;
        boolean nextBackSlashed = false;
        for (int index = 0; index < repl.length; ++index) {
            if (repl[index] == '\\' && !nextBackSlashed) {
                nextBackSlashed = true;
                ++index;
            }
            if (nextBackSlashed) {
                if (index >= repl.length) {
                    throw new IndexOutOfBoundsException();
                }
                res.append(repl[index]);
                nextBackSlashed = false;
                continue;
            }
            if (repl[index] == '$') {
                if (this.replacementParts == null) {
                    this.replacementParts = new ArrayList();
                }
                try {
                    final int gr = Integer.parseInt(new String(repl, ++index, 1));
                    if (replacementPos != res.length()) {
                        this.replacementParts.add(res.subSequence(replacementPos, res.length()));
                        replacementPos = res.length();
                    }
                    this.replacementParts.add(new Object(){
                        private final int grN;
                        {
                            this.grN = gr;
                        }

                        public String toString() {
                            return TMatcher.this.group(this.grN);
                        }
                    });
                    String group = this.group(gr);
                    replacementPos += group.length();
                    res.append(group);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("");
                }
            }
            res.append(repl[index]);
        }
        if (this.replacementParts != null && replacementPos != res.length()) {
            this.replacementParts.add(res.subSequence(replacementPos, res.length()));
        }
        return res.toString();
    }

    public TMatcher reset(CharSequence input) {
        if (input == null) {
            throw new NullPointerException("");
        }
        this.string = input;
        return this.reset();
    }

    public TMatcher reset() {
        this.leftBound = 0;
        this.rightBound = this.string.length();
        this.matchResult.reset(this.string, this.leftBound, this.rightBound);
        this.appendPos = 0;
        this.replacement = null;
        this.matchResult.previousMatch = -1;
        return this;
    }

    public TMatcher region(int start, int end) {
        if (start > end || start < 0 || end < 0 || start > this.string.length() || end > this.string.length()) {
            throw new IndexOutOfBoundsException(start + ", " + end);
        }
        this.leftBound = start;
        this.rightBound = end;
        this.matchResult.reset(null, start, end);
        this.appendPos = 0;
        this.replacement = null;
        return this;
    }

    public StringBuffer appendTail(StringBuffer buffer) {
        return buffer.append(this.string.subSequence(this.appendPos, this.string.length()));
    }

    public String replaceFirst(String replacement) {
        this.reset();
        if (this.find()) {
            StringBuffer sb = new StringBuffer();
            this.appendReplacement(sb, replacement);
            return this.appendTail(sb).toString();
        }
        return this.string.toString();
    }

    public String replaceAll(String replacement) {
        StringBuffer sb = new StringBuffer();
        this.reset();
        while (this.find()) {
            this.appendReplacement(sb, replacement);
        }
        return this.appendTail(sb).toString();
    }

    public TPattern pattern() {
        return this.pat;
    }

    @Override
    public String group(int group) {
        return this.matchResult.group(group);
    }

    @Override
    public String group() {
        return this.group(0);
    }

    public boolean find(int start) {
        int stringLength = this.string.length();
        if (start < 0 || start > stringLength) {
            throw new IndexOutOfBoundsException(String.valueOf(start));
        }
        if ((start = this.findAt(start)) >= 0 && this.matchResult.isValid()) {
            this.matchResult.finalizeMatch();
            return true;
        }
        this.matchResult.startIndex = -1;
        return false;
    }

    private int findAt(int startIndex) {
        this.matchResult.reset();
        this.matchResult.setMode(MODE_FIND);
        this.matchResult.setStartIndex(startIndex);
        int foundIndex = this.start.find(startIndex, this.string, this.matchResult);
        if (foundIndex == -1) {
            this.matchResult.hitEnd = true;
        }
        return foundIndex;
    }

    public boolean find() {
        int length = this.string.length();
        if (!this.hasTransparentBounds()) {
            length = this.rightBound;
        }
        if (this.matchResult.startIndex >= 0 && this.matchResult.mode() == MODE_FIND) {
            this.matchResult.startIndex = this.matchResult.end();
            if (this.matchResult.end() == this.matchResult.start()) {
                ++this.matchResult.startIndex;
            }
            return this.matchResult.startIndex <= length ? this.find(this.matchResult.startIndex) : false;
        }
        return this.find(this.leftBound);
    }

    @Override
    public int start(int group) {
        return this.matchResult.start(group);
    }

    @Override
    public int end(int group) {
        return this.matchResult.end(group);
    }

    public boolean matches() {
        return this.lookingAt(this.leftBound, MODE_MATCH);
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) < 0 && s.indexOf(36) < 0) {
            return s;
        }
        StringBuilder res = new StringBuilder(s.length() * 2);
        int len = s.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '$': {
                    res.append('\\');
                    res.append('$');
                    continue block4;
                }
                case '\\': {
                    res.append('\\');
                    res.append('\\');
                    continue block4;
                }
                default: {
                    res.append(ch);
                }
            }
        }
        return res.toString();
    }

    private boolean runMatch(TAbstractSet set, int index, TMatchResultImpl matchResult) {
        if (set.matches(index, this.string, matchResult) >= 0) {
            matchResult.finalizeMatch();
            return true;
        }
        return false;
    }

    public boolean lookingAt() {
        return this.lookingAt(this.leftBound, MODE_FIND);
    }

    private boolean lookingAt(int startIndex, int mode) {
        this.matchResult.reset();
        this.matchResult.setMode(mode);
        this.matchResult.setStartIndex(startIndex);
        return this.runMatch(this.start, startIndex, this.matchResult);
    }

    @Override
    public int start() {
        return this.start(0);
    }

    @Override
    public int groupCount() {
        return this.matchResult.groupCount();
    }

    @Override
    public int end() {
        return this.end(0);
    }

    public TMatchResult toMatchResult() {
        return this.matchResult.cloneImpl();
    }

    public TMatcher useAnchoringBounds(boolean value) {
        this.matchResult.useAnchoringBounds(value);
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.matchResult.hasAnchoringBounds();
    }

    public TMatcher useTransparentBounds(boolean value) {
        this.matchResult.useTransparentBounds(value);
        return this;
    }

    public boolean hasTransparentBounds() {
        return this.matchResult.hasTransparentBounds();
    }

    public int regionStart() {
        return this.matchResult.getLeftBound();
    }

    public int regionEnd() {
        return this.matchResult.getRightBound();
    }

    public boolean requireEnd() {
        return this.matchResult.requireEnd;
    }

    public boolean hitEnd() {
        return this.matchResult.hitEnd;
    }

    public TMatcher usePattern(TPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("");
        }
        int startIndex = this.matchResult.getPreviousMatchEnd();
        int mode = this.matchResult.mode();
        this.pat = pattern;
        this.start = pattern.start;
        this.matchResult = new TMatchResultImpl(this.string, this.leftBound, this.rightBound, pattern.groupCount(), pattern.compCount(), pattern.consCount());
        this.matchResult.setStartIndex(startIndex);
        this.matchResult.setMode(mode);
        return this;
    }

    TMatcher(TPattern pat, CharSequence cs) {
        this.pat = pat;
        this.start = pat.start;
        this.string = cs;
        this.leftBound = 0;
        this.rightBound = this.string.length();
        this.matchResult = new TMatchResultImpl(cs, this.leftBound, this.rightBound, pat.groupCount(), pat.compCount(), pat.consCount());
    }

    public String toString() {
        String lastMatch = "";
        try {
            lastMatch = Integer.toString(this.start());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return "Regex[pattern=" + this.pat + " region=" + this.matchResult.getLeftBound() + "," + this.matchResult.getRightBound() + " lastmatch=" + lastMatch + "]";
    }
}

