/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.util.ArrayList;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;

public class AnnotationDependencyListener
extends AbstractDependencyListener {
    public void classReached(DependencyAgent agent, String className, CallLocation location) {
        ClassReader cls = agent.getClassSource().get(className);
        if (cls == null) {
            return;
        }
        if (cls.hasModifier(ElementModifier.ANNOTATION)) {
            this.getAnnotationImplementor(agent, className);
        }
        for (AnnotationReader annotation : cls.getAnnotations().all()) {
            agent.linkClass(annotation.getType(), location);
        }
    }

    private String getAnnotationImplementor(DependencyAgent agent, String annotationType) {
        String implementorName = annotationType + "$$_impl";
        if (agent.getClassSource().get(implementorName) == null) {
            ClassHolder implementor = this.createImplementor(agent.getClassSource(), annotationType, implementorName);
            agent.submitClass(implementor);
        }
        return implementorName;
    }

    private ClassHolder createImplementor(ClassReaderSource classSource, String annotationType, String implementorName) {
        ClassHolder implementor = new ClassHolder(implementorName);
        implementor.setParent("java.lang.Object");
        implementor.getInterfaces().add(annotationType);
        implementor.getModifiers().add(ElementModifier.FINAL);
        implementor.setLevel(AccessLevel.PUBLIC);
        ClassReader annotation = classSource.get(annotationType);
        if (annotation == null) {
            return implementor;
        }
        ArrayList<Object> ctorSignature = new ArrayList<Object>();
        for (MethodReader methodDecl : annotation.getMethods()) {
            if (methodDecl.hasModifier(ElementModifier.STATIC)) continue;
            FieldHolder field = new FieldHolder("$" + methodDecl.getName());
            field.setType(methodDecl.getResultType());
            field.setLevel(AccessLevel.PRIVATE);
            implementor.addField(field);
            MethodHolder accessor = new MethodHolder(methodDecl.getDescriptor());
            ProgramEmitter pe = ProgramEmitter.create((MethodHolder)accessor);
            ValueEmitter thisVal = pe.newVar();
            ValueEmitter result = thisVal.getField(field.getReference(), field.getType());
            if (field.getType() instanceof ValueType.Array) {
                result = result.cloneArray();
            }
            result.returnValue();
            implementor.addMethod(accessor);
            ctorSignature.add(field.getType());
        }
        ctorSignature.add(ValueType.VOID);
        MethodHolder ctor = new MethodHolder("<init>", ctorSignature.toArray(new ValueType[ctorSignature.size()]));
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)ctor);
        ValueEmitter thisVal = pe.newVar();
        thisVal.invokeSpecial(new MethodReference(Object.class, "<init>", new Class[]{Void.TYPE}), new ValueEmitter[0]);
        for (MethodReader methodDecl : annotation.getMethods()) {
            if (methodDecl.hasModifier(ElementModifier.STATIC)) continue;
            ValueEmitter param = pe.newVar();
            FieldReference field = new FieldReference(implementorName, "$" + methodDecl.getName());
            thisVal.setField(field, methodDecl.getResultType(), param);
        }
        pe.exit();
        implementor.addMethod(ctor);
        MethodHolder annotTypeMethod = new MethodHolder("annotationType", new ValueType[]{ValueType.parse(Class.class)});
        pe = ProgramEmitter.create((MethodHolder)annotTypeMethod);
        pe.newVar();
        pe.constant(ValueType.object((String)annotationType)).returnValue();
        implementor.addMethod(annotTypeMethod);
        return implementor;
    }

    public void methodReached(DependencyAgent agent, MethodDependency method, CallLocation location) {
        ClassReader cls;
        ValueType type = method.getMethod().getResultType();
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            ClassReader cls2 = agent.getClassSource().get(className);
            if (cls2 != null && cls2.hasModifier(ElementModifier.ANNOTATION)) {
                agent.linkClass(className, location);
            }
        }
        if (method.getMethod().hasModifier(ElementModifier.STATIC) && method.getMethod().getName().equals("$$__readAnnotations__$$") && (cls = agent.getClassSource().get(method.getReference().getClassName())) != null) {
            for (AnnotationReader annotation : cls.getAnnotations().all()) {
                agent.linkClass(annotation.getType(), location);
            }
        }
    }
}

