/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRCurrency;
import org.teavm.classlib.impl.unicode.CLDRDateFormats;
import org.teavm.classlib.impl.unicode.CLDRDecimalData;
import org.teavm.classlib.impl.unicode.CLDRTimeZone;

public class CLDRLocale {
    final Map<String, String> languages = new LinkedHashMap<String, String>();
    final Map<String, String> territories = new LinkedHashMap<String, String>();
    final Map<String, CLDRCurrency> currencies = new LinkedHashMap<String, CLDRCurrency>();
    String[] eras;
    String[] dayPeriods;
    String[] months;
    String[] shortMonths;
    String[] weekdays;
    String[] shortWeekdays;
    CLDRDateFormats dateFormats;
    CLDRDateFormats timeFormats;
    CLDRDateFormats dateTimeFormats;
    CLDRTimeZone[] timeZones;
    CLDRDecimalData decimalData = new CLDRDecimalData();
    String numberFormat;
    String percentFormat;
    String currencyFormat;

    public Map<String, String> getLanguages() {
        return Collections.unmodifiableMap(this.languages);
    }

    public Map<String, String> getTerritories() {
        return Collections.unmodifiableMap(this.territories);
    }

    public Map<String, CLDRCurrency> getCurrencies() {
        return Collections.unmodifiableMap(this.currencies);
    }

    public String[] getEras() {
        return Arrays.copyOf(this.eras, this.eras.length);
    }

    public String[] getDayPeriods() {
        return Arrays.copyOf(this.dayPeriods, this.dayPeriods.length);
    }

    public String[] getMonths() {
        return Arrays.copyOf(this.months, this.months.length);
    }

    public String[] getShortMonths() {
        return Arrays.copyOf(this.shortMonths, this.shortMonths.length);
    }

    public String[] getWeekdays() {
        return Arrays.copyOf(this.weekdays, this.weekdays.length);
    }

    public String[] getShortWeekdays() {
        return Arrays.copyOf(this.shortWeekdays, this.shortWeekdays.length);
    }

    public CLDRDateFormats getDateFormats() {
        return this.dateFormats;
    }

    public CLDRDateFormats getTimeFormats() {
        return this.timeFormats;
    }

    public CLDRDateFormats getDateTimeFormats() {
        return this.dateTimeFormats;
    }

    public CLDRTimeZone[] getTimeZones() {
        return (CLDRTimeZone[])this.timeZones.clone();
    }

    public CLDRDecimalData getDecimalData() {
        return this.decimalData;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public String getPercentFormat() {
        return this.percentFormat;
    }

    public String getCurrencyFormat() {
        return this.currencyFormat;
    }
}

