/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Arrays;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TIllegalStateException;
import org.teavm.classlib.java.lang.TNullPointerException;
import org.teavm.classlib.java.util.TAbstractQueue;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TComparator;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TSortedSet;

public class TPriorityQueue<E>
extends TAbstractQueue<E>
implements TSerializable {
    private Object[] data;
    private TComparator<Object> comparator;
    private TComparator<? super E> originalComparator;
    private int size;
    private int version;

    public TPriorityQueue() {
        this(1);
    }

    public TPriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public TPriorityQueue(TCollection<? extends E> c) {
        if (c instanceof TPriorityQueue) {
            this.initFromPriorityQueue((TPriorityQueue)c);
        } else if (c instanceof TSortedSet) {
            this.initFromSortedSet((TSortedSet)c);
        } else {
            this.data = new Object[c.size()];
            this.fillFromCollection(c);
            this.setComparator(null);
        }
    }

    public TPriorityQueue(TPriorityQueue<? extends E> c) {
        this.initFromPriorityQueue(c);
    }

    public TPriorityQueue(TSortedSet<? extends E> c) {
        this.initFromSortedSet(c);
    }

    private void initFromSortedSet(TSortedSet<? extends E> sortedSet) {
        this.data = new Object[sortedSet.size()];
        this.setComparator(sortedSet.comparator());
        this.fillFromCollection(sortedSet);
    }

    private void initFromPriorityQueue(TPriorityQueue<? extends E> prirityQueue) {
        this.data = Arrays.copyOf(prirityQueue.data, prirityQueue.size);
        this.size = prirityQueue.size;
        this.setComparator(prirityQueue.comparator());
    }

    private void fillFromCollection(TCollection<? extends E> c) {
        TIterator iter = c.iterator();
        while (iter.hasNext()) {
            this.offer(iter.next());
        }
        this.version = 0;
    }

    public TPriorityQueue(int initialCapacity, TComparator<? super E> comparator) {
        if (initialCapacity < 1) {
            throw new TIllegalArgumentException();
        }
        this.data = new Object[initialCapacity];
        this.setComparator(comparator);
    }

    private void setComparator(TComparator<? super E> comparator) {
        this.originalComparator = comparator;
        if (comparator == null) {
            comparator = new TComparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof TComparable) {
                        return ((TComparable)o1).compareTo(o2);
                    }
                    return -((TComparable)o2).compareTo(o1);
                }
            };
        }
        this.comparator = comparator;
    }

    public TComparator<? super E> comparator() {
        return this.originalComparator;
    }

    @Override
    public boolean offer(E e) {
        int parent;
        if (e == null) {
            throw new TNullPointerException();
        }
        this.ensureCapacity(this.size + 1);
        int current = this.size;
        while (current > 0 && this.comparator.compare(e, this.data[parent = (current - 1) / 2]) < 0) {
            this.data[current] = this.data[parent];
            current = parent;
        }
        this.data[current] = e;
        ++this.size;
        ++this.version;
        return true;
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        Object elem = this.data[0];
        this.removeAt(0);
        return (E)elem;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return (E)this.data[0];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public TIterator<E> iterator() {
        return new TIterator<E>(){
            private int index;
            private int knownVersion;
            private int removeIndex;
            {
                this.knownVersion = TPriorityQueue.this.version;
                this.removeIndex = -1;
            }

            @Override
            public boolean hasNext() {
                if (TPriorityQueue.this.version != this.knownVersion) {
                    throw new TConcurrentModificationException();
                }
                return this.index < TPriorityQueue.this.size;
            }

            @Override
            public E next() {
                if (TPriorityQueue.this.version != this.knownVersion) {
                    throw new TConcurrentModificationException();
                }
                this.removeIndex = this.index;
                return TPriorityQueue.this.data[this.index++];
            }

            @Override
            public void remove() {
                if (TPriorityQueue.this.version != this.knownVersion) {
                    throw new TConcurrentModificationException();
                }
                if (this.removeIndex < 0) {
                    throw new TIllegalStateException();
                }
                TPriorityQueue.this.removeAt(this.removeIndex);
                this.removeIndex = -1;
                --this.index;
                this.knownVersion = TPriorityQueue.this.version;
            }
        };
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
        ++this.version;
    }

    private void removeAt(int index) {
        ++this.version;
        Object item = this.data[this.size - 1];
        this.data[--this.size] = null;
        while (true) {
            int next;
            int left = index * 2 + 1;
            int right = left + 1;
            if (left >= this.size || this.comparator.compare(item, this.data[next = right >= this.size || this.comparator.compare(this.data[left], this.data[right]) < 0 ? left : right]) <= 0) break;
            this.data[index] = this.data[next];
            index = next;
        }
        this.data[index] = item;
    }

    private void ensureCapacity(int capacity) {
        if (this.data.length >= capacity) {
            return;
        }
        capacity = Math.max(capacity, this.data.length * 3 / 2);
        this.data = Arrays.copyOf(this.data, capacity);
    }
}

