/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.impl.charset.ByteBuffer;
import org.teavm.classlib.impl.charset.CharBuffer;
import org.teavm.classlib.impl.charset.Charset;
import org.teavm.classlib.impl.charset.UTF16Helper;
import org.teavm.classlib.impl.charset.UTF8Charset;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.io.TUnsupportedEncodingException;
import org.teavm.classlib.java.lang.StringNativeGenerator;
import org.teavm.classlib.java.lang.TCharSequence;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.classlib.java.lang.TStringIndexOutOfBoundsException;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.classlib.java.util.TComparator;
import org.teavm.classlib.java.util.THashMap;
import org.teavm.classlib.java.util.TMap;
import org.teavm.dependency.PluggableDependency;
import org.teavm.javascript.ni.InjectedBy;
import org.teavm.javascript.ni.Rename;

public class TString
extends TObject
implements TSerializable,
TComparable<TString>,
TCharSequence {
    public static final TComparator<TString> CASE_INSENSITIVE_ORDER = new TComparator<TString>(){

        @Override
        public int compare(TString o1, TString o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };
    private char[] characters;
    private transient int hashCode;
    private static TMap<TString, TString> pool = new THashMap<TString, TString>();

    public TString() {
        this.characters = new char[0];
    }

    public TString(TString other) {
        this.characters = other.characters;
    }

    public TString(char[] characters) {
        this.characters = new char[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            this.characters[i] = characters[i];
        }
    }

    public TString(char[] value, int offset, int count) {
        this.characters = new char[count];
        for (int i = 0; i < count; ++i) {
            this.characters[i] = value[i + offset];
        }
    }

    public TString(byte[] bytes, int offset, int length, TString charsetName) throws TUnsupportedEncodingException {
        Charset charset = Charset.get(charsetName.toString());
        if (charset == null) {
            throw new TUnsupportedEncodingException(TString.wrap("Unknown encoding:" + charsetName));
        }
        this.initWithBytes(bytes, offset, length, charset);
    }

    public TString(byte[] bytes, int offset, int length) {
        this.initWithBytes(bytes, offset, length, new UTF8Charset());
    }

    public TString(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public TString(byte[] bytes, TString charsetName) throws TUnsupportedEncodingException {
        this(bytes, 0, bytes.length, charsetName);
    }

    public TString(int[] codePoints, int offset, int count) {
        this.characters = new char[count * 2];
        int charCount = 0;
        for (int i = 0; i < count; ++i) {
            int codePoint;
            if ((codePoint = codePoints[offset++]) >= 65536) {
                this.characters[charCount++] = UTF16Helper.highSurrogate(codePoint);
                this.characters[charCount++] = UTF16Helper.lowSurrogate(codePoint);
                continue;
            }
            this.characters[charCount++] = (char)codePoint;
        }
        if (charCount < this.characters.length) {
            this.characters = TArrays.copyOf(this.characters, charCount);
        }
    }

    private void initWithBytes(byte[] bytes, int offset, int length, Charset charset) {
        TStringBuilder sb = new TStringBuilder(bytes.length * 2);
        this.characters = new char[sb.length()];
        ByteBuffer source = new ByteBuffer(bytes, offset, offset + length);
        char[] destChars = new char[TMath.max(8, TMath.min(length * 2, 1024))];
        CharBuffer dest = new CharBuffer(destChars, 0, destChars.length);
        while (!source.end()) {
            charset.decode(source, dest);
            sb.append(destChars, 0, dest.position());
            dest.rewind(0);
        }
        this.characters = new char[sb.length()];
        sb.getChars(0, sb.length(), this.characters, 0);
    }

    public TString(TStringBuilder sb) {
        this(sb.buffer, 0, sb.length());
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.characters.length) {
            throw new TStringIndexOutOfBoundsException();
        }
        return this.characters[index];
    }

    public int codePointAt(int index) {
        return TCharacter.codePointAt(this, index);
    }

    public int codePointBefore(int index) {
        return TCharacter.codePointBefore(this, index);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        return TCharacter.codePointCount(this, beginIndex, endIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return TCharacter.offsetByCodePoints(this, index, codePointOffset);
    }

    @Override
    public int length() {
        return this.characters.length;
    }

    public boolean isEmpty() {
        return this.characters.length == 0;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin > srcEnd || srcEnd > this.length() || dstBegin < 0 || dstBegin + (srcEnd - srcBegin) > dst.length) {
            throw new TIndexOutOfBoundsException();
        }
        while (srcBegin < srcEnd) {
            dst[dstBegin++] = this.charAt(srcBegin++);
        }
    }

    public boolean contentEquals(TCharSequence charSeq) {
        if (this == charSeq) {
            return true;
        }
        if (this.characters.length != charSeq.length()) {
            return false;
        }
        for (int i = 0; i < this.characters.length; ++i) {
            if (this.characters[i] == charSeq.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TString anotherString) {
        if (this == anotherString) {
            return 0;
        }
        int l = TMath.min(this.length(), anotherString.length());
        for (int i = 0; i < l; ++i) {
            char b;
            char a = this.charAt(i);
            if (a - (b = anotherString.charAt(i)) == 0) continue;
            return a - b;
        }
        return this.length() - anotherString.length();
    }

    public int compareToIgnoreCase(TString anotherString) {
        if (this == anotherString) {
            return 0;
        }
        int l = TMath.min(this.length(), anotherString.length());
        for (int i = 0; i < l; ++i) {
            char b;
            char a = TCharacter.toLowerCase(this.charAt(i));
            if (a - (b = TCharacter.toLowerCase(anotherString.charAt(i))) == 0) continue;
            return a - b;
        }
        return this.length() - anotherString.length();
    }

    public boolean startsWith(TString prefix, int toffset) {
        if (toffset + prefix.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.charAt(i) == this.charAt(toffset++)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(TString prefix) {
        if (this == prefix) {
            return true;
        }
        return this.startsWith(prefix, 0);
    }

    public boolean regionMatches(int toffset, TString other, int ooffset, int len) {
        if (toffset < 0 || ooffset < 0 || toffset + len > this.length() || ooffset + len > other.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.charAt(toffset++) == other.charAt(ooffset++)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(TString suffix) {
        if (this == suffix) {
            return true;
        }
        if (suffix.length() > this.length()) {
            return false;
        }
        int j = 0;
        for (int i = this.length() - suffix.length(); i < this.length(); ++i) {
            if (this.charAt(i) == suffix.charAt(j++)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(int ch, int fromIndex) {
        if (ch < 65536) {
            char bmpChar = (char)ch;
            for (int i = fromIndex; i < this.characters.length; ++i) {
                if (this.characters[i] != bmpChar) continue;
                return i;
            }
            return -1;
        }
        char hi = UTF16Helper.highSurrogate(ch);
        char lo = UTF16Helper.lowSurrogate(ch);
        for (int i = fromIndex; i < this.characters.length - 1; ++i) {
            if (this.characters[i] != hi || this.characters[i + 1] != lo) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        if (ch < 65536) {
            char bmpChar = (char)ch;
            for (int i = fromIndex; i >= 0; --i) {
                if (this.characters[i] != bmpChar) continue;
                return i;
            }
            return -1;
        }
        char hi = UTF16Helper.highSurrogate(ch);
        char lo = UTF16Helper.lowSurrogate(ch);
        for (int i = fromIndex; i >= 1; --i) {
            if (this.characters[i] != lo || this.characters[i - 1] != hi) continue;
            return i - 1;
        }
        return -1;
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.length() - 1);
    }

    public int indexOf(TString str, int fromIndex) {
        int toIndex = this.length() - str.length();
        block0: for (int i = fromIndex; i <= toIndex; ++i) {
            for (int j = 0; j < str.length(); ++j) {
                if (this.charAt(i + j) != str.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int indexOf(TString str) {
        return this.indexOf(str, 0);
    }

    public int lastIndexOf(TString str, int fromIndex) {
        block0: for (int i = fromIndex = Math.min(fromIndex, this.length() - str.length()); i >= 0; --i) {
            for (int j = 0; j < str.length(); ++j) {
                if (this.charAt(i + j) != str.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int lastIndexOf(TString str) {
        return this.lastIndexOf(str, this.length());
    }

    public TString substring(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new TIndexOutOfBoundsException();
        }
        return new TString(this.characters, beginIndex, endIndex - beginIndex);
    }

    public TString substring(int beginIndex) {
        return this.substring(beginIndex, this.length());
    }

    @Override
    public TCharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public TString concat(TString str) {
        int i;
        if (str.isEmpty()) {
            return this;
        }
        char[] buffer = new char[this.length() + str.length()];
        int index = 0;
        for (i = 0; i < this.length(); ++i) {
            buffer[index++] = this.charAt(i);
        }
        for (i = 0; i < str.length(); ++i) {
            buffer[index++] = str.charAt(i);
        }
        return new TString(buffer);
    }

    public TString replace(char oldChar, char newChar) {
        if (oldChar == newChar) {
            return this;
        }
        char[] buffer = new char[this.length()];
        for (int i = 0; i < this.length(); ++i) {
            buffer[i] = this.charAt(i) == oldChar ? newChar : this.charAt(i);
        }
        return new TString(buffer);
    }

    public boolean contains(TCharSequence s) {
        block0: for (int i = 0; i < this.length(); ++i) {
            for (int j = 0; j < s.length(); ++j) {
                if (this.charAt(i + j) != s.charAt(j)) continue block0;
            }
            return true;
        }
        return false;
    }

    public TString replace(TCharSequence target, TCharSequence replacement) {
        int i;
        TStringBuilder sb = new TStringBuilder();
        int sz = this.length() - target.length();
        block0: for (i = 0; i <= sz; ++i) {
            for (int j = 0; j < target.length(); ++j) {
                if (this.charAt(i + j) == target.charAt(j)) continue;
                sb.append(this.charAt(i));
                continue block0;
            }
            sb.append(replacement);
            i += target.length() - 1;
        }
        sb.append(this.substring(i));
        return TString.wrap(sb.toString());
    }

    public TString trim() {
        int lower;
        int upper = this.length() - 1;
        for (lower = 0; lower <= upper && this.charAt(lower) <= ' '; ++lower) {
        }
        while (lower <= upper && this.charAt(upper) <= ' ') {
            --upper;
        }
        return this.substring(lower, upper + 1);
    }

    @Override
    @Rename(value="toString")
    public TString toString0() {
        return this;
    }

    public char[] toCharArray() {
        char[] array = new char[this.characters.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.characters[i];
        }
        return array;
    }

    public static TString valueOf(TObject obj) {
        return obj != null ? TString.wrap(obj.toString()) : TString.wrap("null");
    }

    public static TString valueOf(char[] data) {
        return new TString(data);
    }

    public static TString valueOf(char[] data, int offset, int count) {
        return new TString(data, offset, count);
    }

    public static TString copyValueOf(char[] data) {
        return TString.valueOf(data);
    }

    public static TString copyValueOf(char[] data, int offset, int count) {
        return TString.valueOf(data, offset, count);
    }

    public static TString valueOf(boolean b) {
        return b ? TString.wrap("true") : TString.wrap("false");
    }

    public static TString valueOf(char c) {
        return new TString(new char[]{c});
    }

    public static TString valueOf(int i) {
        return TString.wrap(new TStringBuilder().append(i).toString());
    }

    public static TString valueOf(long l) {
        return TString.wrap(new TStringBuilder().append(l).toString());
    }

    public static TString valueOf(float f) {
        return TString.wrap(new TStringBuilder().append(f).toString());
    }

    public static TString valueOf(double d) {
        return TString.wrap(new TStringBuilder().append(d).toString());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TString)) {
            return false;
        }
        TString str = (TString)other;
        if (str.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (this.charAt(i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(TString other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (TCharacter.toLowerCase(this.charAt(i)) == TCharacter.toLowerCase(other.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes(TString charsetName) throws TUnsupportedEncodingException {
        Charset charset = Charset.get(charsetName.toString());
        if (charset == null) {
            throw new TUnsupportedEncodingException(TString.wrap("Unsupported encoding: " + charsetName));
        }
        return this.getBytes(charset);
    }

    public byte[] getBytes() {
        return this.getBytes(new UTF8Charset());
    }

    private byte[] getBytes(Charset charset) {
        byte[] result = new byte[this.length() * 2];
        int resultLength = 0;
        byte[] destArray = new byte[TMath.max(16, TMath.min(this.length() * 2, 4096))];
        ByteBuffer dest = new ByteBuffer(destArray);
        CharBuffer src = new CharBuffer(this.characters);
        while (!src.end()) {
            charset.encode(src, dest);
            if (resultLength + dest.position() > result.length) {
                result = TArrays.copyOf(result, result.length * 2);
            }
            for (int i = 0; i < dest.position(); ++i) {
                result[resultLength++] = destArray[i];
            }
            dest.rewind(0);
        }
        return TArrays.copyOf(result, resultLength);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            for (char c : this.characters) {
                this.hashCode = 31 * this.hashCode + c;
            }
        }
        return this.hashCode;
    }

    @InjectedBy(value=StringNativeGenerator.class)
    @PluggableDependency(value=StringNativeGenerator.class)
    public static native TString wrap(String var0);

    public TString toLowerCase() {
        if (this.isEmpty()) {
            return this;
        }
        int[] codePoints = new int[this.characters.length];
        int codePointCount = 0;
        for (int i = 0; i < this.characters.length; ++i) {
            if (i == this.characters.length - 1 || !UTF16Helper.isHighSurrogate(this.characters[i]) || !UTF16Helper.isLowSurrogate(this.characters[i + 1])) {
                codePoints[codePointCount++] = TCharacter.toLowerCase(this.characters[i]);
                continue;
            }
            codePoints[codePointCount++] = TCharacter.toLowerCase(UTF16Helper.buildCodePoint(this.characters[i], this.characters[i + 1]));
            ++i;
        }
        return new TString(codePoints, 0, codePointCount);
    }

    public TString toUpperCase() {
        if (this.isEmpty()) {
            return this;
        }
        int[] codePoints = new int[this.characters.length];
        int codePointCount = 0;
        for (int i = 0; i < this.characters.length; ++i) {
            if (i == this.characters.length - 1 || !UTF16Helper.isHighSurrogate(this.characters[i]) || !UTF16Helper.isLowSurrogate(this.characters[i + 1])) {
                codePoints[codePointCount++] = TCharacter.toUpperCase(this.characters[i]);
                continue;
            }
            codePoints[codePointCount++] = TCharacter.toUpperCase(UTF16Helper.buildCodePoint(this.characters[i], this.characters[i + 1]));
            ++i;
        }
        return new TString(codePoints, 0, codePointCount);
    }

    public TString intern() {
        TString interned = pool.get(this);
        if (interned == null) {
            interned = this;
            pool.put(interned, interned);
        }
        return interned;
    }
}

