/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyAgentType;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class NewInstanceDependencySupport
implements DependencyListener {
    private DependencyNode allClassesNode;
    private DependencyStack newInstanceStack;

    public void started(DependencyAgent agent) {
        this.allClassesNode = agent.createNode();
    }

    public void classAchieved(DependencyAgent agent, String className) {
        ClassReader cls = agent.getClassSource().get(className);
        if (cls == null) {
            return;
        }
        if (cls.hasModifier(ElementModifier.ABSTRACT) || cls.hasModifier(ElementModifier.INTERFACE)) {
            return;
        }
        MethodReader method = cls.getMethod(new MethodDescriptor("<init>", new ValueType[]{ValueType.VOID}));
        if (method != null) {
            this.allClassesNode.propagate(agent.getType(className));
        }
    }

    public void methodAchieved(final DependencyAgent agent, MethodDependency method) {
        MethodReader reader = method.getMethod();
        if (reader.getOwnerName().equals("java.lang.Class") && reader.getName().equals("newInstance")) {
            this.newInstanceStack = method.getStack();
            this.allClassesNode.connect(method.getResult());
            method.getResult().addConsumer(new DependencyConsumer(){

                public void consume(DependencyAgentType type) {
                    NewInstanceDependencySupport.this.attachConstructor(agent, type.getName());
                }
            });
        }
    }

    private void attachConstructor(DependencyAgent checker, String type) {
        MethodReference ref = new MethodReference(type, new MethodDescriptor("<init>", new ValueType[]{ValueType.VOID}));
        checker.linkMethod(ref, this.newInstanceStack).use();
    }

    public void fieldAchieved(DependencyAgent dependencyAgent, FieldDependency field) {
    }
}

