/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.chrono.ChronoPeriod;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.chrono.IsoChronology;
import org.threeten.bp.format.DateTimeParseException;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAmount;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.temporal.UnsupportedTemporalTypeException;

public final class Period
extends ChronoPeriod
implements Serializable {
    public static final Period ZERO = new Period(0, 0, 0);
    private final int years;
    private final int months;
    private final int days;

    public static Period ofYears(int years) {
        return Period.create(years, 0, 0);
    }

    public static Period ofMonths(int months) {
        return Period.create(0, months, 0);
    }

    public static Period ofWeeks(int weeks) {
        return Period.create(0, 0, Math.multiplyExact(weeks, 7));
    }

    public static Period ofDays(int days) {
        return Period.create(0, 0, days);
    }

    public static Period of(int years, int months, int days) {
        return Period.create(years, months, days);
    }

    public static Period from(TemporalAmount amount) {
        if (amount instanceof Period) {
            return (Period)amount;
        }
        if (amount instanceof ChronoPeriod && !IsoChronology.INSTANCE.equals(((ChronoPeriod)amount).getChronology())) {
            throw new DateTimeException("Period requires ISO chronology: " + String.valueOf(amount));
        }
        Objects.requireNonNull(amount, "amount");
        int years = 0;
        int months = 0;
        int days = 0;
        for (TemporalUnit unit : amount.getUnits()) {
            long unitAmount = amount.get(unit);
            if (unit == ChronoUnit.YEARS) {
                years = Math.toIntExact(unitAmount);
                continue;
            }
            if (unit == ChronoUnit.MONTHS) {
                months = Math.toIntExact(unitAmount);
                continue;
            }
            if (unit == ChronoUnit.DAYS) {
                days = Math.toIntExact(unitAmount);
                continue;
            }
            throw new DateTimeException("Unit must be Years, Months or Days, but was " + String.valueOf(unit));
        }
        return Period.create(years, months, days);
    }

    public static Period between(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate);
    }

    public static Period parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        Parser parser = new Parser(text);
        if (!parser.parse() || !parser.hasOneField) {
            throw new DateTimeParseException("Text cannot be parsed to a Period", text, parser.ptr);
        }
        if (parser.negative) {
            parser.years = -parser.years;
            parser.months = -parser.months;
            parser.weeks = -parser.weeks;
            parser.days = -parser.days;
        }
        int days = Math.addExact(parser.days, Math.multiplyExact(parser.weeks, 7));
        return Period.create(parser.years, parser.months, days);
    }

    private static Period create(int years, int months, int days) {
        if ((years | months | days) == 0) {
            return ZERO;
        }
        return new Period(years, months, days);
    }

    private Period(int years, int months, int days) {
        this.years = years;
        this.months = months;
        this.days = days;
    }

    private Object readResolve() {
        if ((this.years | this.months | this.days) == 0) {
            return ZERO;
        }
        return this;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.unmodifiableList(Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS));
    }

    @Override
    public Chronology getChronology() {
        return IsoChronology.INSTANCE;
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.YEARS) {
            return this.years;
        }
        if (unit == ChronoUnit.MONTHS) {
            return this.months;
        }
        if (unit == ChronoUnit.DAYS) {
            return this.days;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + String.valueOf(unit));
    }

    @Override
    public boolean isZero() {
        return this == ZERO;
    }

    @Override
    public boolean isNegative() {
        return this.years < 0 || this.months < 0 || this.days < 0;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public Period withYears(int years) {
        if (years == this.years) {
            return this;
        }
        return Period.create(years, this.months, this.days);
    }

    public Period withMonths(int months) {
        if (months == this.months) {
            return this;
        }
        return Period.create(this.years, months, this.days);
    }

    public Period withDays(int days) {
        if (days == this.days) {
            return this;
        }
        return Period.create(this.years, this.months, days);
    }

    @Override
    public Period plus(TemporalAmount amountToAdd) {
        Period amount = Period.from(amountToAdd);
        return Period.create(Math.addExact(this.years, amount.years), Math.addExact(this.months, amount.months), Math.addExact(this.days, amount.days));
    }

    public Period plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        return Period.create(Math.toIntExact(Math.addExact((long)this.years, yearsToAdd)), this.months, this.days);
    }

    public Period plusMonths(long monthsToAdd) {
        if (monthsToAdd == 0L) {
            return this;
        }
        return Period.create(this.years, Math.toIntExact(Math.addExact((long)this.months, monthsToAdd)), this.days);
    }

    public Period plusDays(long daysToAdd) {
        if (daysToAdd == 0L) {
            return this;
        }
        return Period.create(this.years, this.months, Math.toIntExact(Math.addExact((long)this.days, daysToAdd)));
    }

    @Override
    public Period minus(TemporalAmount amountToSubtract) {
        Period amount = Period.from(amountToSubtract);
        return Period.create(Math.subtractExact(this.years, amount.years), Math.subtractExact(this.months, amount.months), Math.subtractExact(this.days, amount.days));
    }

    public Period minusYears(long yearsToSubtract) {
        return yearsToSubtract == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-yearsToSubtract);
    }

    public Period minusMonths(long monthsToSubtract) {
        return monthsToSubtract == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-monthsToSubtract);
    }

    public Period minusDays(long daysToSubtract) {
        return daysToSubtract == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-daysToSubtract);
    }

    @Override
    public Period multipliedBy(int scalar) {
        if (this == ZERO || scalar == 1) {
            return this;
        }
        return Period.create(Math.multiplyExact(this.years, scalar), Math.multiplyExact(this.months, scalar), Math.multiplyExact(this.days, scalar));
    }

    @Override
    public Period negated() {
        return this.multipliedBy(-1);
    }

    @Override
    public Period normalized() {
        long totalMonths = this.toTotalMonths();
        long splitYears = totalMonths / 12L;
        int splitMonths = (int)(totalMonths % 12L);
        if (splitYears == (long)this.years && splitMonths == this.months) {
            return this;
        }
        return Period.create(Math.toIntExact(splitYears), splitMonths, this.days);
    }

    public long toTotalMonths() {
        return (long)this.years * 12L + (long)this.months;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        if (this.years != 0) {
            temporal = this.months != 0 ? temporal.plus(this.toTotalMonths(), ChronoUnit.MONTHS) : temporal.plus(this.years, ChronoUnit.YEARS);
        } else if (this.months != 0) {
            temporal = temporal.plus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        if (this.years != 0) {
            temporal = this.months != 0 ? temporal.minus(this.toTotalMonths(), ChronoUnit.MONTHS) : temporal.minus(this.years, ChronoUnit.YEARS);
        } else if (this.months != 0) {
            temporal = temporal.minus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Period) {
            Period other = (Period)obj;
            return this.years == other.years && this.months == other.months && this.days == other.days;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.years + Integer.rotateLeft(this.months, 8) + Integer.rotateLeft(this.days, 16);
    }

    @Override
    public String toString() {
        if (this == ZERO) {
            return "P0D";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('P');
        if (this.years != 0) {
            buf.append(this.years).append('Y');
        }
        if (this.months != 0) {
            buf.append(this.months).append('M');
        }
        if (this.days != 0) {
            buf.append(this.days).append('D');
        }
        return buf.toString();
    }

    static class Parser {
        private int ptr;
        private CharSequence text;
        private int years;
        private int months;
        private int weeks;
        private int days;
        private boolean negative;
        private boolean hasOneField;
        private int parsedNumber;

        Parser(CharSequence text) {
            this.text = text;
        }

        boolean parse() {
            this.negative = this.sign();
            if (this.eof() || this.text.charAt(this.ptr) != 'P') {
                return false;
            }
            ++this.ptr;
            if (this.eof()) {
                return false;
            }
            int state = 0;
            block6: while (this.number()) {
                if (this.eof()) {
                    return false;
                }
                this.hasOneField = true;
                char c = this.text.charAt(this.ptr);
                switch (state) {
                    case 0: {
                        if (c == 'Y') {
                            ++this.ptr;
                            this.years = this.parsedNumber;
                            state = 1;
                            continue block6;
                        }
                    }
                    case 1: {
                        if (c == 'M') {
                            ++this.ptr;
                            this.months = this.parsedNumber;
                            state = 2;
                            continue block6;
                        }
                    }
                    case 2: {
                        if (c == 'W') {
                            ++this.ptr;
                            this.weeks = this.parsedNumber;
                            state = 3;
                            continue block6;
                        }
                    }
                    case 3: {
                        if (c != 'D') break;
                        ++this.ptr;
                        this.days = this.parsedNumber;
                        state = 4;
                        continue block6;
                    }
                }
                return false;
            }
            return this.eof() && this.hasOneField;
        }

        boolean eof() {
            return this.ptr >= this.text.length();
        }

        boolean sign() {
            if (!this.eof()) {
                if (this.text.charAt(this.ptr) == '-') {
                    ++this.ptr;
                    return true;
                }
                if (this.text.charAt(this.ptr) == '+') {
                    ++this.ptr;
                }
            }
            return false;
        }

        boolean number() {
            char c;
            boolean negative = this.sign();
            this.parsedNumber = 0;
            boolean hasDigits = false;
            while (this.ptr < this.text.length() && (c = this.text.charAt(this.ptr)) >= '0' && c < '9') {
                ++this.ptr;
                hasDigits = true;
                this.parsedNumber = this.parsedNumber * 10 + c - 48;
            }
            if (negative) {
                this.parsedNumber = -this.parsedNumber;
            }
            return hasDigits;
        }
    }
}

