/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.random;

import org.teavm.classlib.impl.RandomUtils;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.TLongStream;

public interface TRandomGenerator {
    default public boolean isDeprecated() {
        return false;
    }

    default public TDoubleStream doubles() {
        return TDoubleStream.generate(this::nextDouble);
    }

    default public TDoubleStream doubles(double origin, double bound) {
        RandomUtils.checkRange(origin, bound);
        return TDoubleStream.generate(() -> this.nextDouble(origin, bound));
    }

    default public TDoubleStream doubles(long streamSize) {
        RandomUtils.checkStreamSize(streamSize);
        return this.doubles().limit(streamSize);
    }

    default public TDoubleStream doubles(long streamSize, double origin, double bound) {
        RandomUtils.checkStreamSize(streamSize);
        RandomUtils.checkRange(origin, bound);
        return this.doubles(origin, bound).limit(streamSize);
    }

    default public TIntStream ints() {
        return TIntStream.generate(this::nextInt);
    }

    default public TIntStream ints(int origin, int bound) {
        RandomUtils.checkRange(origin, bound);
        return TIntStream.generate(() -> this.nextInt(origin, bound));
    }

    default public TIntStream ints(long streamSize) {
        RandomUtils.checkStreamSize(streamSize);
        return this.ints().limit(streamSize);
    }

    default public TIntStream ints(long streamSize, int origin, int bound) {
        RandomUtils.checkStreamSize(streamSize);
        RandomUtils.checkRange(origin, bound);
        return this.ints(origin, bound).limit(streamSize);
    }

    default public TLongStream longs() {
        return TLongStream.generate(this::nextLong);
    }

    default public TLongStream longs(long origin, long bound) {
        RandomUtils.checkRange(origin, bound);
        return TLongStream.generate(() -> this.nextLong(origin, bound));
    }

    default public TLongStream longs(long streamSize) {
        RandomUtils.checkStreamSize(streamSize);
        return this.longs().limit(streamSize);
    }

    default public TLongStream longs(long streamSize, long origin, long bound) {
        RandomUtils.checkStreamSize(streamSize);
        RandomUtils.checkRange(origin, bound);
        return this.longs(origin, bound).limit(streamSize);
    }

    default public boolean nextBoolean() {
        return this.nextInt() < 0;
    }

    default public void nextBytes(byte[] bytes) {
        if (bytes.length == 0) {
            return;
        }
        int len = (bytes.length - 1) / 4 + 1;
        for (int i = 0; i < len; ++i) {
            int rnd = this.nextInt();
            for (int j = 0; j < 4; ++j) {
                int idx = 4 * i + j;
                if (idx >= bytes.length) continue;
                bytes[idx] = (byte)(0xFF & rnd >> i * 8);
            }
        }
    }

    default public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    default public float nextFloat(float bound) {
        RandomUtils.checkBound(bound);
        float res = this.nextFloat() * bound;
        if (res >= bound) {
            res = Math.nextDown(bound);
        }
        return res;
    }

    default public float nextFloat(float origin, float bound) {
        RandomUtils.checkRange(origin, bound);
        float res = this.nextFloat() * (bound - origin) + origin;
        if (res >= bound) {
            res = Math.nextAfter(bound, (double)origin);
        }
        return res;
    }

    default public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    default public double nextDouble(double bound) {
        RandomUtils.checkBound(bound);
        double res = this.nextDouble() * bound;
        if (res >= bound) {
            res = Math.nextDown(bound);
        }
        return res;
    }

    default public double nextDouble(double origin, double bound) {
        RandomUtils.checkRange(origin, bound);
        double res = this.nextDouble() * (bound - origin) + origin;
        if (res >= bound) {
            res = Math.nextAfter(bound, origin);
        }
        return res;
    }

    default public int nextInt() {
        return (int)(this.nextLong() >>> 32);
    }

    default public int nextInt(int bound) {
        int res;
        RandomUtils.checkBound(bound);
        int mask = (Integer.highestOneBit(bound) << 1) - 1;
        while ((res = this.nextInt() & mask) >= bound) {
        }
        return res;
    }

    default public int nextInt(int origin, int bound) {
        int res;
        RandomUtils.checkRange(origin, bound);
        int range = bound - origin;
        if (range > 0) {
            return this.nextInt(range) + origin;
        }
        while ((res = this.nextInt()) < origin || res >= bound) {
        }
        return res;
    }

    public long nextLong();

    default public long nextLong(long bound) {
        long res;
        RandomUtils.checkBound(bound);
        long mask = (Long.highestOneBit(bound) << 1) - 1L;
        while ((res = this.nextLong() & mask) >= bound) {
        }
        return res;
    }

    default public long nextLong(long origin, long bound) {
        long res;
        RandomUtils.checkRange(origin, bound);
        long range = bound - origin;
        if (range > 0L) {
            return this.nextLong(range) + origin;
        }
        while ((res = this.nextLong()) < origin || res >= bound) {
        }
        return res;
    }

    default public double nextGaussian() {
        return RandomUtils.pairGaussian(this::nextDouble)[0];
    }

    default public double nextGaussian(double mean, double stddev) {
        if (stddev < 0.0) {
            throw new IllegalArgumentException();
        }
        return mean + stddev * this.nextGaussian();
    }
}

