/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.THashMap;
import org.teavm.classlib.java.util.THashSet;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TLinkedHashMap;
import org.teavm.classlib.java.util.TSequencedSet;

public class TLinkedHashSet<E>
extends THashSet<E>
implements TSequencedSet<E>,
TCloneable,
TSerializable {
    public TLinkedHashSet() {
        super(new TLinkedHashMap());
    }

    public TLinkedHashSet(int capacity) {
        super(new TLinkedHashMap(capacity));
    }

    public TLinkedHashSet(int capacity, float loadFactor) {
        super(new TLinkedHashMap(capacity, loadFactor));
    }

    public TLinkedHashSet(TCollection<? extends E> collection) {
        super(new TLinkedHashMap(collection.size() < 6 ? 11 : collection.size() * 2));
        TIterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    private TLinkedHashMap<E, THashSet<E>> map() {
        return (TLinkedHashMap)this.backingMap;
    }

    @Override
    public void addFirst(E e) {
        this.map().putFirst(e, this);
    }

    @Override
    public void addLast(E e) {
        this.map().putLast(e, this);
    }

    @Override
    public E getFirst() {
        return this.map().sequencedKeySet().getFirst();
    }

    @Override
    public E getLast() {
        return this.map().sequencedKeySet().getLast();
    }

    @Override
    public E removeFirst() {
        return this.map().sequencedKeySet().removeFirst();
    }

    @Override
    public E removeLast() {
        return this.map().sequencedKeySet().removeLast();
    }

    @Override
    public TSequencedSet<E> reversed() {
        return new ReversedLinkedHashSet(this);
    }

    public static <T> TLinkedHashSet<T> newLinkedHashSet(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        return new TLinkedHashSet(THashMap.capacity(size));
    }

    static class ReversedLinkedHashSet<E>
    extends TAbstractSet<E>
    implements TSequencedSet<E> {
        private final TLinkedHashSet<E> base;

        ReversedLinkedHashSet(TLinkedHashSet<E> base) {
            this.base = base;
        }

        @Override
        public int size() {
            return this.base.size();
        }

        @Override
        public TIterator<E> iterator() {
            return this.base.map().sequencedKeySet().reversed().iterator();
        }

        @Override
        public boolean add(E e) {
            return this.base.add(e);
        }

        @Override
        public void addFirst(E e) {
            this.base.addLast(e);
        }

        @Override
        public void addLast(E e) {
            this.base.addFirst(e);
        }

        @Override
        public E getFirst() {
            return this.base.getLast();
        }

        @Override
        public E getLast() {
            return this.base.getFirst();
        }

        @Override
        public E removeFirst() {
            return this.base.removeLast();
        }

        @Override
        public E removeLast() {
            return this.base.removeFirst();
        }

        @Override
        public TSequencedSet<E> reversed() {
            return this.base;
        }
    }
}

