/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferOverDataView;
import org.teavm.classlib.java.nio.TCharBufferOverTypedArray;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TDoubleBufferOverDataView;
import org.teavm.classlib.java.nio.TDoubleBufferOverTypedArray;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TFloatBufferOverDataView;
import org.teavm.classlib.java.nio.TFloatBufferOverTypedArray;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TIntBufferOverDataView;
import org.teavm.classlib.java.nio.TIntBufferOverTypedArray;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TLongBufferOverDataView;
import org.teavm.classlib.java.nio.TLongBufferOverTypedArray;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.classlib.java.nio.TShortBuffer;
import org.teavm.classlib.java.nio.TShortBufferOverDataView;
import org.teavm.classlib.java.nio.TShortBufferOverTypedArray;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.BigInt64Array;
import org.teavm.jso.typedarrays.DataView;
import org.teavm.jso.typedarrays.Float32Array;
import org.teavm.jso.typedarrays.Float64Array;
import org.teavm.jso.typedarrays.Int16Array;
import org.teavm.jso.typedarrays.Int32Array;
import org.teavm.jso.typedarrays.Int8Array;
import org.teavm.jso.typedarrays.Uint16Array;

class TByteBufferJsImpl
extends TByteBuffer
implements TArrayBufferViewProvider {
    private byte[] array;
    private int arrayOffset;
    private Int8Array data;
    private DataView dataView;
    private boolean direct;
    private boolean readOnly;

    TByteBufferJsImpl(byte[] array, int arrayOffset, Int8Array data, boolean direct, boolean readOnly) {
        this.array = array;
        this.arrayOffset = arrayOffset;
        this.data = data;
        this.direct = direct;
        this.readOnly = readOnly;
    }

    @Override
    byte[] arrayImpl() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int arrayOffsetImpl() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.arrayOffset;
    }

    @Override
    boolean hasArrayImpl() {
        return this.array != null;
    }

    @Override
    int capacityImpl() {
        return this.data.getLength();
    }

    @Override
    void getImpl(int index, byte[] dst, int offset, int length) {
        Int8Array slice = new Int8Array(this.data.getBuffer(), this.data.getByteOffset() + index, length);
        Int8Array.fromJavaArray((byte[])dst).set((ArrayBufferView)slice, offset);
    }

    @Override
    void putImpl(int index, TByteBuffer src, int offset, int length) {
        if (src instanceof TByteBufferJsImpl) {
            TByteBufferJsImpl srcImpl = (TByteBufferJsImpl)src;
            Int8Array slice = new Int8Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + offset, length);
            this.data.set((ArrayBufferView)slice, index);
        } else if (src.hasArray()) {
            Int8Array slice = new Int8Array(Int8Array.fromJavaArray((byte[])src.array()).getBuffer(), src.arrayOffset() + offset, length);
            this.data.set((ArrayBufferView)slice, index);
        } else {
            for (int i = 0; i < length; ++i) {
                this.put(index + i, src.get(offset + i));
            }
        }
    }

    @Override
    void putImpl(byte[] src, int srcOffset, int destOffset, int length) {
        Int8Array slice = new Int8Array(Int8Array.fromJavaArray((byte[])src).getBuffer(), srcOffset, length);
        this.data.set((ArrayBufferView)slice, destOffset);
    }

    @Override
    public TByteBuffer slice() {
        Int8Array newData = new Int8Array(this.data.getBuffer(), this.data.getByteOffset() + this.position, this.remaining());
        TByteBufferJsImpl result = new TByteBufferJsImpl(this.array, this.arrayOffset + this.position, newData, this.direct, this.readOnly);
        result.position = 0;
        result.limit = newData.getLength();
        result.order = TByteOrder.BIG_ENDIAN;
        return result;
    }

    @Override
    public TByteBuffer duplicate() {
        TByteBufferJsImpl result = new TByteBufferJsImpl(this.array, this.arrayOffset + this.position, this.data, this.direct, this.readOnly);
        result.position = this.position;
        result.limit = this.limit;
        result.mark = this.mark;
        result.order = TByteOrder.BIG_ENDIAN;
        return result;
    }

    @Override
    public TByteBuffer asReadOnlyBuffer() {
        TByteBufferJsImpl result = new TByteBufferJsImpl(this.array, this.arrayOffset + this.position, this.data, this.direct, true);
        result.position = this.position;
        result.limit = this.limit;
        result.mark = this.mark;
        result.order = TByteOrder.BIG_ENDIAN;
        return result;
    }

    @Override
    public byte get() {
        if (this.position >= this.limit) {
            throw new TBufferUnderflowException();
        }
        return this.data.get(this.position++);
    }

    @Override
    public TByteBuffer put(byte b) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.data.set(this.position++, b);
        return this;
    }

    @Override
    public byte get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.get(index);
    }

    @Override
    public TByteBuffer put(int index, byte b) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.data.set(index, b);
        return this;
    }

    @Override
    public TByteBuffer compact() {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        int sz = this.remaining();
        if (this.position > 0) {
            this.data.set((ArrayBufferView)new Int8Array(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz), 0);
        }
        this.position = sz;
        this.limit = this.capacity();
        this.mark = -1;
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    private DataView getDataView() {
        if (this.dataView == null) {
            this.dataView = new DataView(this.data.getBuffer(), this.data.getByteOffset(), this.data.getByteLength());
        }
        return this.dataView;
    }

    @Override
    public char getChar() {
        if (this.position + 1 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        int result = this.getDataView().getUint16(this.position, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 2;
        return (char)result;
    }

    @Override
    public TByteBuffer putChar(char value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 1 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.getDataView().setUint16(this.position, (int)value, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 2;
        return this;
    }

    @Override
    public char getChar(int index) {
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return (char)this.getDataView().getUint16(index, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public TByteBuffer putChar(int index, char value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.getDataView().setUint16(index, (int)value, this.order == TByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public TCharBuffer asCharBuffer() {
        int sz = this.remaining() / 2;
        if (this.order == TByteOrder.nativeOrder()) {
            Uint16Array slice = new Uint16Array(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz);
            return new TCharBufferOverTypedArray(0, sz, this.readOnly, slice, null);
        }
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz * 2);
        return new TCharBufferOverDataView(0, sz, this.readOnly, slice, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public short getShort() {
        if (this.position + 1 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        short result = this.getDataView().getInt16(this.position, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 2;
        return result;
    }

    @Override
    public TByteBuffer putShort(short value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 1 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.getDataView().setInt16(this.position, (int)value, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 2;
        return this;
    }

    @Override
    public short getShort(int index) {
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.getDataView().getInt16(index, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public TByteBuffer putShort(int index, short value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.getDataView().setInt16(index, (int)value, this.order == TByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public TShortBuffer asShortBuffer() {
        int sz = this.remaining() / 2;
        if (this.order == TByteOrder.nativeOrder()) {
            Int16Array slice = new Int16Array(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz);
            return new TShortBufferOverTypedArray(0, sz, this.readOnly, slice, null);
        }
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz * 2);
        return new TShortBufferOverDataView(0, sz, this.readOnly, slice, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int getInt() {
        if (this.position + 3 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        int result = this.getDataView().getInt32(this.position, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 4;
        return result;
    }

    @Override
    public TByteBuffer putInt(int value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 3 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.getDataView().setInt32(this.position, value, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 4;
        return this;
    }

    @Override
    public int getInt(int index) {
        if (index < 0 || index + 3 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.getDataView().getInt32(index, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public TByteBuffer putInt(int index, int value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 3 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.getDataView().setInt32(index, value, this.order == TByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public TIntBuffer asIntBuffer() {
        int sz = this.remaining() / 4;
        if (this.order == TByteOrder.nativeOrder()) {
            Int32Array slice = new Int32Array(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz);
            return new TIntBufferOverTypedArray(0, sz, this.readOnly, slice, null);
        }
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz * 4);
        return new TIntBufferOverDataView(0, sz, this.readOnly, slice, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public float getFloat() {
        if (this.position + 3 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        float result = this.getDataView().getFloat32(this.position, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 4;
        return result;
    }

    @Override
    public TByteBuffer putFloat(float value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 3 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.getDataView().setFloat32(this.position, value, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 4;
        return this;
    }

    @Override
    public TByteBuffer putFloat(int index, float value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index + 3 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.getDataView().setFloat32(index, value, this.order == TByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public float getFloat(int index) {
        if (index + 3 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        return this.getDataView().getFloat32(index, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public double getDouble() {
        if (this.position + 7 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        double result = this.getDataView().getFloat64(this.position, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 8;
        return result;
    }

    @Override
    public TByteBuffer putDouble(double value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 7 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.getDataView().setFloat64(this.position, value, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 8;
        return this;
    }

    @Override
    public double getDouble(int index) {
        if (index + 7 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        return this.getDataView().getFloat64(index, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public TByteBuffer putDouble(int index, double value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index + 7 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.getDataView().setFloat64(index, value, this.order == TByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public long getLong() {
        if (this.position + 7 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        long result = this.getDataView().getBigInt64(this.position, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 8;
        return result;
    }

    @Override
    public TByteBuffer putLong(long value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 7 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.getDataView().setBigInt64(this.position, value, this.order == TByteOrder.LITTLE_ENDIAN);
        this.position += 8;
        return this;
    }

    @Override
    public long getLong(int index) {
        if (index < 0 || index + 7 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 7) + ")");
        }
        return this.getDataView().getBigInt64(index, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public TByteBuffer putLong(int index, long value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 3 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 3) + ")");
        }
        this.getDataView().setBigInt64(index, value, this.order == TByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public TLongBuffer asLongBuffer() {
        int sz = this.remaining() / 8;
        if (this.order == TByteOrder.nativeOrder()) {
            BigInt64Array slice = new BigInt64Array(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz);
            return new TLongBufferOverTypedArray(0, sz, this.readOnly, slice, null);
        }
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz * 8);
        return new TLongBufferOverDataView(0, sz, this.readOnly, slice, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public TFloatBuffer asFloatBuffer() {
        int sz = this.remaining() / 4;
        if (this.order == TByteOrder.nativeOrder()) {
            Float32Array slice = new Float32Array(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz);
            return new TFloatBufferOverTypedArray(0, sz, this.readOnly, slice, null);
        }
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz * 4);
        return new TFloatBufferOverDataView(0, sz, this.readOnly, slice, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public TDoubleBuffer asDoubleBuffer() {
        int sz = this.remaining() / 8;
        if (this.order == TByteOrder.nativeOrder()) {
            Float64Array slice = new Float64Array(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz);
            return new TDoubleBufferOverTypedArray(0, sz, this.readOnly, slice, null);
        }
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + this.position, sz * 8);
        return new TDoubleBufferOverDataView(0, sz, this.readOnly, slice, this.order == TByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 1;
    }
}

