/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.Precedence;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.InjectorContext;
import org.teavm.classlib.impl.ReflectionDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MemberReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ClassGenerator
implements Generator,
Injector,
DependencyPlugin {
    private static final FieldReference platformClassField = new FieldReference(Class.class.getName(), "platformClass");
    private static final MethodDescriptor CLINIT = new MethodDescriptor("<clinit>", new Class[]{Void.TYPE});

    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) {
        switch (methodRef.getName()) {
            case "createMetadata": {
                this.generateCreateMetadata(context, writer);
            }
        }
    }

    public void generate(InjectorContext context, MethodReference methodRef) {
        switch (methodRef.getName()) {
            case "newEmptyInstance": {
                context.getWriter().append("new").ws().append("(");
                context.writeExpr(context.getArgument(0), Precedence.MEMBER_ACCESS);
                context.getWriter().append('.').appendField(platformClassField);
                context.getWriter().append(")");
            }
        }
    }

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        switch (method.getReference().getName()) {
            case "newEmptyInstance": {
                method.getVariable(0).getClassValueNode().addConsumer(type -> {
                    if (!(type.getValueType() instanceof ValueType.Object)) {
                        return;
                    }
                    String className = ((ValueType.Object)type.getValueType()).getClassName();
                    ClassReader cls = agent.getClassSource().get(className);
                    if (cls != null && !cls.hasModifier(ElementModifier.ABSTRACT) && !cls.hasModifier(ElementModifier.INTERFACE)) {
                        method.getResult().propagate(type);
                    }
                });
                break;
            }
            case "getSuperclass": {
                this.reachGetSuperclass(agent, method);
                break;
            }
            case "getInterfaces": {
                this.reachGetInterfaces(agent, method);
                break;
            }
            case "getComponentType": {
                this.reachGetComponentType(agent, method);
            }
        }
    }

    private void reachGetSuperclass(DependencyAgent agent, MethodDependency method) {
        method.getVariable(0).getClassValueNode().addConsumer(type -> {
            if (!(type.getValueType() instanceof ValueType.Object)) {
                return;
            }
            String className = ((ValueType.Object)type.getValueType()).getClassName();
            ClassReader cls = agent.getClassSource().get(className);
            if (cls != null && cls.getParent() != null) {
                method.getResult().getClassValueNode().propagate(agent.getType((ValueType)ValueType.object((String)cls.getParent())));
            }
        });
    }

    private void reachGetInterfaces(DependencyAgent agent, MethodDependency method) {
        method.getVariable(0).getClassValueNode().addConsumer(type -> {
            if (!(type.getValueType() instanceof ValueType.Object)) {
                return;
            }
            String className = ((ValueType.Object)type.getValueType()).getClassName();
            ClassReader cls = agent.getClassSource().get(className);
            method.getResult().propagate(agent.getType((ValueType)ValueType.arrayOf((ValueType)ValueType.object((String)"java.lang.Class"))));
            method.getResult().getArrayItem().propagate(agent.getType((ValueType)ValueType.object((String)"java.lang.Class")));
            if (cls != null) {
                for (String iface : cls.getInterfaces()) {
                    method.getResult().getArrayItem().getClassValueNode().propagate(agent.getType((ValueType)ValueType.object((String)iface)));
                }
            }
        });
    }

    private void reachGetComponentType(DependencyAgent agent, MethodDependency method) {
        method.getVariable(0).getClassValueNode().addConsumer(t -> {
            if (!(t.getValueType() instanceof ValueType.Array)) {
                return;
            }
            ValueType itemType = ((ValueType.Array)t.getValueType()).getItemType();
            method.getResult().getClassValueNode().propagate(agent.getType(itemType));
        });
    }

    private void generateCreateMetadata(GeneratorContext context, SourceWriter writer) {
        ReflectionDependencyListener reflection = (ReflectionDependencyListener)((Object)context.getService(ReflectionDependencyListener.class));
        for (String className : reflection.getClassesWithReflectableFields()) {
            this.generateCreateFieldsForClass(context, writer, className);
        }
        for (String className : reflection.getClassesWithReflectableMethods()) {
            this.generateCreateMethodsForClass(context, writer, className);
        }
    }

    private void generateCreateFieldsForClass(GeneratorContext context, SourceWriter writer, String className) {
        ReflectionDependencyListener reflection = (ReflectionDependencyListener)((Object)context.getService(ReflectionDependencyListener.class));
        Set<String> accessibleFields = reflection.getAccessibleFields(className);
        ClassReader cls = context.getClassSource().get(className);
        if (cls == null) {
            return;
        }
        writer.appendClass(className).append(".$meta.fields").ws().append('=').ws().append('[').indent();
        Set fieldsToExpose = accessibleFields == null ? Collections.emptySet() : cls.getFields().stream().filter(f -> accessibleFields.contains(f.getName())).collect(Collectors.toSet());
        boolean skipPrivates = ReflectionDependencyListener.shouldSkipPrivates(cls);
        this.generateCreateMembers(writer, skipPrivates, fieldsToExpose, field -> {
            this.appendProperty(writer, "type", false, () -> context.typeToClassString(writer, field.getType()));
            this.appendProperty(writer, "getter", false, () -> {
                if (accessibleFields != null && accessibleFields.contains(field.getName()) && reflection.isRead(field.getReference())) {
                    this.renderGetter(context, writer, (FieldReader)field);
                } else {
                    writer.append("null");
                }
            });
            this.appendProperty(writer, "setter", false, () -> {
                if (accessibleFields != null && accessibleFields.contains(field.getName()) && reflection.isWritten(field.getReference())) {
                    this.renderSetter(context, writer, (FieldReader)field);
                } else {
                    writer.append("null");
                }
            });
        });
        writer.outdent().append("];").softNewLine();
    }

    private void generateCreateMethodsForClass(GeneratorContext context, SourceWriter writer, String className) {
        ReflectionDependencyListener reflection = (ReflectionDependencyListener)((Object)context.getService(ReflectionDependencyListener.class));
        Set<MethodDescriptor> accessibleMethods = reflection.getAccessibleMethods(className);
        ClassReader cls = context.getInitialClassSource().get(className);
        if (cls == null) {
            return;
        }
        writer.appendClass(className).append(".$meta.methods").ws().append('=').ws().append('[').indent();
        boolean skipPrivates = ReflectionDependencyListener.shouldSkipPrivates(cls);
        Set methodsToExpose = accessibleMethods == null ? Collections.emptySet() : (Collection)cls.getMethods().stream().filter(m -> accessibleMethods.contains(m.getDescriptor())).collect(Collectors.toList());
        this.generateCreateMembers(writer, skipPrivates, methodsToExpose, method -> {
            this.appendProperty(writer, "parameterTypes", false, () -> {
                writer.append('[');
                for (int i = 0; i < method.parameterCount(); ++i) {
                    if (i > 0) {
                        writer.append(',').ws();
                    }
                    context.typeToClassString(writer, method.parameterType(i));
                }
                writer.append(']');
            });
            this.appendProperty(writer, "returnType", false, () -> context.typeToClassString(writer, method.getResultType()));
            this.appendProperty(writer, "callable", false, () -> {
                if (accessibleMethods != null && accessibleMethods.contains(method.getDescriptor()) && reflection.isCalled(method.getReference())) {
                    this.renderCallable(context, writer, (MethodReader)method);
                } else {
                    writer.append("null");
                }
            });
        });
        writer.outdent().append("];").softNewLine();
    }

    private <T extends MemberReader> void generateCreateMembers(SourceWriter writer, boolean skipPrivates, Iterable<T> members, MemberRenderer<T> renderer) {
        boolean first = true;
        for (MemberReader member : members) {
            if (skipPrivates && (member.getLevel() == AccessLevel.PRIVATE || member.getLevel() == AccessLevel.PACKAGE_PRIVATE)) continue;
            if (!first) {
                writer.append(",").ws();
            } else {
                writer.softNewLine();
            }
            first = false;
            writer.append("{").indent().softNewLine();
            this.appendProperty(writer, "name", true, () -> writer.append('\"').append(RenderingUtil.escapeString((String)member.getName())).append('\"'));
            this.appendProperty(writer, "modifiers", false, () -> writer.append(ElementModifier.pack((Set)member.readModifiers())));
            this.appendProperty(writer, "accessLevel", false, () -> writer.append(member.getLevel().ordinal()));
            renderer.render(member);
            writer.outdent().softNewLine().append("}");
        }
    }

    private void appendProperty(SourceWriter writer, String name, boolean first, Fragment value) {
        if (!first) {
            writer.append(",").softNewLine();
        }
        writer.append(name).ws().append(':').ws();
        value.render();
    }

    private void renderGetter(GeneratorContext context, SourceWriter writer, FieldReader field) {
        writer.append("function(obj)").ws().append("{").indent().softNewLine();
        this.initClass(context, writer, (MemberReader)field);
        writer.append("return ");
        this.boxIfNecessary(writer, field.getType(), () -> this.fieldAccess(writer, field));
        writer.append(";").softNewLine();
        writer.outdent().append("}");
    }

    private void renderSetter(GeneratorContext context, SourceWriter writer, FieldReader field) {
        writer.append("function(obj,").ws().append("val)").ws().append("{").indent().softNewLine();
        this.initClass(context, writer, (MemberReader)field);
        this.fieldAccess(writer, field);
        writer.ws().append('=').ws();
        this.unboxIfNecessary(writer, field.getType(), () -> writer.append("val"));
        writer.append(";").softNewLine();
        writer.outdent().append("}");
    }

    private void renderCallable(GeneratorContext context, SourceWriter writer, MethodReader method) {
        writer.append("function(obj,").ws().append("args)").ws().append("{").indent().softNewLine();
        this.initClass(context, writer, (MemberReader)method);
        if (method.getResultType() != ValueType.VOID) {
            writer.append("return ");
        }
        boolean receiverWritten = false;
        if (!(method.hasModifier(ElementModifier.STATIC) || method.hasModifier(ElementModifier.FINAL) || method.getLevel() == AccessLevel.PRIVATE || method.getName().equals("<init>"))) {
            writer.append("obj.").appendVirtualMethod(method.getDescriptor());
            receiverWritten = true;
        } else {
            writer.appendMethod(method.getReference());
        }
        writer.append('(');
        boolean first = true;
        if (!receiverWritten && !method.hasModifier(ElementModifier.STATIC)) {
            writer.append("obj").ws();
            first = false;
        }
        for (int i = 0; i < method.parameterCount(); ++i) {
            if (!first) {
                writer.append(',').ws();
            }
            first = false;
            int index = i;
            this.unboxIfNecessary(writer, method.parameterType(i), () -> writer.append("args[" + index + "]"));
        }
        writer.append(");").softNewLine();
        if (method.getResultType() == ValueType.VOID) {
            writer.append("return null;").softNewLine();
        }
        writer.outdent().append("}");
    }

    private void initClass(GeneratorContext context, SourceWriter writer, MemberReader member) {
        ClassReader cls = context.getClassSource().get(member.getOwnerName());
        if (member.hasModifier(ElementModifier.STATIC) && context.isDynamicInitializer(member.getOwnerName()) && cls.getMethod(CLINIT) != null) {
            writer.appendClassInit(member.getOwnerName()).append("();").softNewLine();
        }
    }

    private void fieldAccess(SourceWriter writer, FieldReader field) {
        if (field.hasModifier(ElementModifier.STATIC)) {
            writer.appendStaticField(field.getReference());
        } else {
            writer.append("obj.").appendField(field.getReference());
        }
    }

    private void boxIfNecessary(SourceWriter writer, ValueType type, Fragment fragment) {
        boolean boxed = false;
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    writer.appendMethod(new MethodReference(Boolean.class, "valueOf", new Class[]{Boolean.TYPE, Boolean.class}));
                    break;
                }
                case BYTE: {
                    writer.appendMethod(new MethodReference(Byte.class, "valueOf", new Class[]{Byte.TYPE, Byte.class}));
                    break;
                }
                case SHORT: {
                    writer.appendMethod(new MethodReference(Short.class, "valueOf", new Class[]{Short.TYPE, Short.class}));
                    break;
                }
                case CHARACTER: {
                    writer.appendMethod(new MethodReference(Character.class, "valueOf", new Class[]{Character.TYPE, Character.class}));
                    break;
                }
                case INTEGER: {
                    writer.appendMethod(new MethodReference(Integer.class, "valueOf", new Class[]{Integer.TYPE, Integer.class}));
                    break;
                }
                case LONG: {
                    writer.appendMethod(new MethodReference(Long.class, "valueOf", new Class[]{Long.TYPE, Long.class}));
                    break;
                }
                case FLOAT: {
                    writer.appendMethod(new MethodReference(Float.class, "valueOf", new Class[]{Float.TYPE, Float.class}));
                    break;
                }
                case DOUBLE: {
                    writer.appendMethod(new MethodReference(Double.class, "valueOf", new Class[]{Double.TYPE, Double.class}));
                }
            }
            writer.append('(');
            boxed = true;
        }
        fragment.render();
        if (boxed) {
            writer.append(')');
        }
    }

    private void unboxIfNecessary(SourceWriter writer, ValueType type, Fragment fragment) {
        boolean boxed = false;
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    writer.appendMethod(new MethodReference(Boolean.class, "booleanValue", new Class[]{Boolean.TYPE}));
                    break;
                }
                case BYTE: {
                    writer.appendMethod(new MethodReference(Byte.class, "byteValue", new Class[]{Byte.TYPE}));
                    break;
                }
                case SHORT: {
                    writer.appendMethod(new MethodReference(Short.class, "shortValue", new Class[]{Short.TYPE}));
                    break;
                }
                case CHARACTER: {
                    writer.appendMethod(new MethodReference(Character.class, "charValue", new Class[]{Character.TYPE}));
                    break;
                }
                case INTEGER: {
                    writer.appendMethod(new MethodReference(Integer.class, "intValue", new Class[]{Integer.TYPE}));
                    break;
                }
                case LONG: {
                    writer.appendMethod(new MethodReference(Long.class, "longValue", new Class[]{Long.TYPE}));
                    break;
                }
                case FLOAT: {
                    writer.appendMethod(new MethodReference(Float.class, "floatValue", new Class[]{Float.TYPE}));
                    break;
                }
                case DOUBLE: {
                    writer.appendMethod(new MethodReference(Double.class, "doubleValue", new Class[]{Double.TYPE}));
                }
            }
            writer.append('(');
            boxed = true;
        }
        fragment.render();
        if (boxed) {
            writer.append(')');
        }
    }

    private static interface MemberRenderer<T extends MemberReader> {
        public void render(T var1);
    }

    private static interface Fragment {
        public void render();
    }
}

