/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.longimpl;

import java.util.function.LongPredicate;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamImpl;

public class TSkippingLongStreamImpl
extends TSimpleLongStreamImpl {
    private TSimpleLongStreamImpl sourceStream;
    private int skip;
    private int remaining;

    public TSkippingLongStreamImpl(TSimpleLongStreamImpl sourceStream, int skip) {
        this.sourceStream = sourceStream;
        this.skip = skip;
        this.remaining = skip;
    }

    @Override
    public boolean next(LongPredicate consumer) {
        while (this.remaining > 0) {
            if (this.sourceStream.next(e -> --this.remaining > 0)) continue;
            return false;
        }
        return this.sourceStream.next(consumer);
    }

    @Override
    protected int estimateSize() {
        int sourceSize = this.sourceStream.estimateSize();
        return sourceSize >= 0 ? Math.max(0, sourceSize - this.skip) : -1;
    }

    @Override
    public void close() {
        this.sourceStream.close();
    }
}

