/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.function.Predicate;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;

public class TDropWhileStream<T>
extends TSimpleStreamImpl<T> {
    private TSimpleStreamImpl<T> sourceStream;
    private Predicate<? super T> predicate;
    private boolean isStarted;

    TDropWhileStream(TSimpleStreamImpl<T> sourceStream, Predicate<? super T> predicate) {
        this.sourceStream = sourceStream;
        this.predicate = predicate;
    }

    @Override
    public boolean next(final Predicate<? super T> consumer) {
        if (!this.isStarted) {
            var skippingPredicate = new Predicate<T>(){
                boolean consumerCanTakeMore;

                @Override
                public boolean test(T t) {
                    if (TDropWhileStream.this.predicate.test(t)) {
                        return true;
                    }
                    TDropWhileStream.this.isStarted = true;
                    this.consumerCanTakeMore = consumer.test(t);
                    return false;
                }
            };
            boolean result = this.sourceStream.next(skippingPredicate);
            if (!result) {
                return false;
            }
            if (!skippingPredicate.consumerCanTakeMore) {
                return true;
            }
        }
        return this.sourceStream.next(consumer);
    }

    @Override
    public void close() {
        this.sourceStream.close();
    }
}

