/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.doubleimpl;

import java.util.function.DoublePredicate;
import org.teavm.classlib.java.util.stream.doubleimpl.TSimpleDoubleStreamImpl;

public class TTakeWhileDoubleStream
extends TSimpleDoubleStreamImpl {
    private TSimpleDoubleStreamImpl sourceStream;
    private DoublePredicate predicate;
    private boolean isStopped;

    TTakeWhileDoubleStream(TSimpleDoubleStreamImpl sourceStream, DoublePredicate predicate) {
        this.sourceStream = sourceStream;
        this.predicate = predicate;
    }

    @Override
    public boolean next(DoublePredicate consumer) {
        if (this.isStopped) {
            return false;
        }
        boolean result = this.sourceStream.next(e -> {
            if (!this.predicate.test(e)) {
                this.isStopped = true;
                return false;
            }
            return consumer.test(e);
        });
        if (!result) {
            this.isStopped = true;
        }
        return result;
    }

    @Override
    public void close() {
        this.sourceStream.close();
    }
}

