/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.file.impl;

import java.io.IOException;
import java.util.Iterator;
import org.teavm.classlib.java.net.TURI;
import org.teavm.classlib.java.nio.file.TLinkOption;
import org.teavm.classlib.java.nio.file.TPath;
import org.teavm.classlib.java.nio.file.impl.TDefaultFileSystem;

public class TDefaultPath
implements TPath {
    private TDefaultFileSystem fs;
    public final String pathString;
    private int[] segments;

    public TDefaultPath(TDefaultFileSystem fs, String pathString) {
        this.fs = fs;
        this.pathString = pathString;
    }

    @Override
    public TDefaultFileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public boolean isAbsolute() {
        if (!this.fs.vfs.isWindows()) {
            return this.pathString.startsWith("/");
        }
        if (this.pathString.length() < 3) {
            return false;
        }
        char c = Character.toUpperCase(this.pathString.charAt(0));
        if (c < 'A' || c > 'Z') {
            return false;
        }
        return this.pathString.charAt(1) == ':' && this.pathString.charAt(2) == '\\';
    }

    @Override
    public TDefaultPath getRoot() {
        if (!this.isAbsolute()) {
            return null;
        }
        if (this.fs.vfs.isWindows()) {
            return new TDefaultPath(this.fs, this.pathString.substring(0, 2));
        }
        return new TDefaultPath(this.fs, "/");
    }

    @Override
    public TDefaultPath getFileName() {
        char sep = this.fs.getSeparatorChar();
        int index = this.pathString.lastIndexOf(sep);
        if (index == 0 && this.pathString.length() == 1) {
            return null;
        }
        return index >= 0 ? new TDefaultPath(this.fs, this.pathString.substring(index + 1)) : this;
    }

    @Override
    public TDefaultPath getParent() {
        char sep = this.fs.getSeparatorChar();
        int index = this.pathString.lastIndexOf(sep);
        if (index == 0) {
            return this.pathString.length() == 1 ? null : new TDefaultPath(this.fs, this.pathString.substring(0, 1));
        }
        return index > 0 ? new TDefaultPath(this.fs, this.pathString.substring(0, index)) : null;
    }

    @Override
    public int getNameCount() {
        this.initSegments();
        return this.segments.length - 1;
    }

    @Override
    public TPath getName(int index) {
        return this.subpath(index, index + 1);
    }

    @Override
    public TPath subpath(int beginIndex, int endIndex) {
        if (beginIndex >= endIndex || beginIndex < 0) {
            throw new IllegalArgumentException();
        }
        this.initSegments();
        if (endIndex > this.segments.length - 1) {
            throw new IllegalArgumentException();
        }
        if (beginIndex == 0 && endIndex == this.segments.length) {
            return this;
        }
        return new TDefaultPath(this.fs, this.pathString.substring(this.segments[beginIndex] + 1, this.segments[endIndex]));
    }

    @Override
    public boolean startsWith(TPath other) {
        if (!(other instanceof TDefaultPath)) {
            return false;
        }
        TDefaultPath otherPath = (TDefaultPath)other;
        if (otherPath.pathString.isEmpty()) {
            return this.pathString.isEmpty();
        }
        if (this.fs.vfs.isWindows() ? this.pathString.length() <= otherPath.pathString.length() && this.pathString.regionMatches(true, 0, otherPath.pathString, 0, otherPath.pathString.length()) : !this.pathString.startsWith(otherPath.pathString)) {
            return false;
        }
        if (this.pathString.length() == otherPath.pathString.length()) {
            return true;
        }
        char sep = this.fs.getSeparatorChar();
        return otherPath.pathString.charAt(otherPath.pathString.length() - 1) == sep || this.pathString.charAt(otherPath.pathString.length()) == sep;
    }

    @Override
    public boolean endsWith(TPath other) {
        if (!(other instanceof TDefaultPath)) {
            return false;
        }
        TDefaultPath otherPath = (TDefaultPath)other;
        if (this.fs.vfs.isWindows() ? this.pathString.length() <= otherPath.pathString.length() && this.pathString.regionMatches(true, this.pathString.length() - otherPath.pathString.length(), otherPath.pathString, 0, otherPath.pathString.length()) : !this.pathString.endsWith(otherPath.pathString)) {
            return false;
        }
        return this.pathString.length() == otherPath.pathString.length() || this.pathString.charAt(this.pathString.length() - otherPath.pathString.length() - 1) == this.fs.getSeparatorChar();
    }

    @Override
    public TDefaultPath normalize() {
        char[] result = new char[this.pathString.length()];
        int resultIndex = 0;
        this.initSegments();
        int[] resultSegments = new int[this.segments.length];
        int resultSegmentIndex = 0;
        boolean abs = this.isAbsolute();
        if (abs) {
            this.pathString.getChars(0, this.segments[0], result, 0);
            resultIndex = this.segments[0];
        }
        int initialLength = resultIndex;
        for (int i = 0; i < this.segments.length - 1; ++i) {
            int start = this.segments[i] + 1;
            int end = this.segments[i + 1];
            if (start + 2 == end && this.pathString.charAt(start) == '.' && this.pathString.charAt(start + 1) == '.') {
                if (resultSegmentIndex > 0) {
                    resultIndex = resultSegments[--resultSegmentIndex];
                    continue;
                }
                if (abs) continue;
                start = Math.max(0, start - 1);
                this.pathString.getChars(start, end, result, resultIndex);
                resultIndex += end - start;
                continue;
            }
            if (start + 1 == end && this.pathString.charAt(start) == '.') continue;
            resultSegments[resultSegmentIndex++] = resultIndex;
            this.pathString.getChars(start - 1, end, result, resultIndex);
            resultIndex += end - start + 1;
        }
        if (resultIndex == this.pathString.length()) {
            return this;
        }
        if (abs && initialLength == resultIndex) {
            result[resultIndex++] = this.fs.getSeparatorChar();
        }
        return new TDefaultPath(this.fs, new String(result, 0, resultIndex));
    }

    @Override
    public TPath resolve(TPath other) {
        if (other.isAbsolute()) {
            return other;
        }
        if (other.getNameCount() == 1 && other.getFileName().toString().isEmpty()) {
            return this;
        }
        if (other instanceof TDefaultPath) {
            return new TDefaultPath(this.fs, this.pathString + this.fs.getSeparatorChar() + ((TDefaultPath)other).pathString);
        }
        StringBuilder sb = new StringBuilder(this.pathString);
        int count = other.getNameCount();
        for (int i = 0; i < count; ++i) {
            sb.append(this.fs.getSeparatorChar());
            sb.append(other.getName(i).toString());
        }
        return new TDefaultPath(this.fs, sb.toString());
    }

    @Override
    public TDefaultPath relativize(TPath other) {
        int index;
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        if (other.equals(this)) {
            return new TDefaultPath(this.fs, "");
        }
        TDefaultPath otherPath = (TDefaultPath)other;
        this.initSegments();
        otherPath.initSegments();
        int count = Math.min(otherPath.segments.length, this.segments.length) - 1;
        for (index = 0; index < count && this.segments[index] == otherPath.segments[index] && this.segments[index + 1] == otherPath.segments[index + 1] && this.pathString.regionMatches(this.fs.vfs.isWindows(), this.segments[index] + 1, otherPath.pathString, this.segments[index] + 1, this.segments[index + 1] - this.segments[index] - 1); ++index) {
        }
        StringBuilder sb = new StringBuilder();
        char sep = this.fs.getSeparatorChar();
        for (int i = index + 1; i < this.segments.length; ++i) {
            sb.append("..").append(sep);
        }
        sb.append(otherPath.pathString, otherPath.segments[index] + 1, otherPath.pathString.length());
        return new TDefaultPath(this.fs, sb.toString());
    }

    @Override
    public TDefaultPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return new TDefaultPath(this.fs, this.toAbsolutePathString());
    }

    private String toAbsolutePathString() {
        String userdir = this.fs.vfs.getUserDir();
        if (this.pathString.isEmpty()) {
            return userdir;
        }
        int length = userdir.length();
        char separatorChar = this.fs.getSeparatorChar();
        StringBuilder result = new StringBuilder(userdir);
        if (userdir.charAt(length - 1) != separatorChar) {
            if (this.pathString.charAt(0) != separatorChar) {
                result.append(separatorChar);
            }
        } else if (this.fs.vfs.isWindows() && this.pathString.charAt(0) == separatorChar) {
            result.setLength(3);
        }
        result.append(this.pathString);
        return result.toString();
    }

    @Override
    public TURI toUri() {
        return new TURI("file", null, this.toAbsolutePathString(), null, null);
    }

    @Override
    public TPath toRealPath(TLinkOption ... options) throws IOException {
        String pathString = this.toAbsolutePath().normalize().pathString;
        return new TDefaultPath(this.fs, this.fs.vfs.canonicalize(pathString));
    }

    @Override
    public int compareTo(TPath o) {
        TDefaultPath other = (TDefaultPath)o;
        if (this.fs != other.fs) {
            throw new ClassCastException();
        }
        return this.fs.vfs.isWindows() ? this.pathString.compareToIgnoreCase(other.pathString) : this.pathString.compareTo(other.pathString);
    }

    @Override
    public Iterator<TPath> iterator() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return false;
        }
        if (!(obj instanceof TDefaultPath)) {
            return false;
        }
        TDefaultPath other = (TDefaultPath)obj;
        if (this.fs != other.fs) {
            return false;
        }
        return this.fs.vfs.isWindows() ? this.pathString.equalsIgnoreCase(other.pathString) : this.pathString.equals(other.pathString);
    }

    public int hashCode() {
        return this.fs.vfs.isWindows() ? this.pathString.toLowerCase().hashCode() : this.pathString.hashCode();
    }

    public String toString() {
        return this.pathString;
    }

    private void initSegments() {
        if (this.segments == null) {
            int next;
            int next2;
            char sep = this.fs.getSeparatorChar();
            int count = 1;
            int startIndex = 0;
            if (!this.pathString.isEmpty() && this.pathString.charAt(0) == sep && ++startIndex == this.pathString.length()) {
                this.segments = new int[]{0};
                return;
            }
            int index = startIndex;
            while ((next2 = this.pathString.indexOf(sep, index)) >= 0) {
                ++count;
                index = next2 + 1;
            }
            int[] result = new int[count + 1];
            int resultIndex = 0;
            this.segments = result;
            index = startIndex;
            result[resultIndex++] = startIndex - 1;
            while ((next = this.pathString.indexOf(sep, index)) >= 0) {
                result[resultIndex++] = next;
                index = next + 1;
            }
            result[resultIndex] = this.pathString.length();
        }
    }
}

