/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.teavm.classlib.java.lang.TSystem;
import org.teavm.classlib.java.nio.file.TAccessMode;
import org.teavm.classlib.java.nio.file.TCopyOption;
import org.teavm.classlib.java.nio.file.TDirectoryStream;
import org.teavm.classlib.java.nio.file.TFileVisitOption;
import org.teavm.classlib.java.nio.file.TFileVisitResult;
import org.teavm.classlib.java.nio.file.TFileVisitor;
import org.teavm.classlib.java.nio.file.TLinkOption;
import org.teavm.classlib.java.nio.file.TOpenOption;
import org.teavm.classlib.java.nio.file.TPath;
import org.teavm.classlib.java.nio.file.TStandardCopyOption;
import org.teavm.classlib.java.nio.file.TStandardOpenOption;
import org.teavm.classlib.java.nio.file.attribute.TBasicFileAttributes;
import org.teavm.classlib.java.nio.file.attribute.TFileAttribute;
import org.teavm.classlib.java.nio.file.attribute.TFileTime;

public final class TFiles {
    private TFiles() {
    }

    public static InputStream newInputStream(TPath path, TOpenOption ... options) throws IOException {
        return path.getFileSystem().provider().newInputStream(path, options);
    }

    public static OutputStream newOutputStream(TPath path, TOpenOption ... options) throws IOException {
        return path.getFileSystem().provider().newOutputStream(path, options);
    }

    public static TDirectoryStream<TPath> newDirectoryStream(TPath dir) throws IOException {
        return TFiles.newDirectoryStream(dir, f -> true);
    }

    public static TDirectoryStream<TPath> newDirectoryStream(TPath dir, TDirectoryStream.Filter<? super TPath> filter) throws IOException {
        return dir.getFileSystem().provider().newDirectoryStream(dir, filter);
    }

    public static TPath createFile(TPath file, TFileAttribute<?> ... attrs) throws IOException {
        file.getFileSystem().provider().newOutputStream(file, TStandardOpenOption.CREATE_NEW, TStandardOpenOption.WRITE).close();
        return file;
    }

    public static TPath createDirectory(TPath dir, TFileAttribute<?> ... attrs) throws IOException {
        dir.getFileSystem().provider().createDirectory(dir, attrs);
        return dir;
    }

    public static TPath createDirectories(TPath dir, TFileAttribute<?> ... attrs) throws IOException {
        int index;
        if (dir.getNameCount() <= 1) {
            return TFiles.createDirectory(dir, attrs);
        }
        for (index = dir.getNameCount() + 1; index > 1 && !TFiles.exists(dir.subpath(0, index - 1), new TLinkOption[0]); --index) {
        }
        if (index > dir.getNameCount() && !TFiles.isDirectory(dir, new TLinkOption[0])) {
            throw new FileSystemException(dir.toString());
        }
        while (index <= dir.getNameCount()) {
            TFiles.createDirectory(dir.subpath(0, index++), new TFileAttribute[0]);
        }
        return dir;
    }

    public static TPath createTempFile(TPath dir, String prefix, String suffix, TFileAttribute<?> ... attrs) throws IOException {
        if (prefix.length() < 3) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        TFiles.generateRandomName(sb);
        sb.append(suffix != null ? suffix : ".tmp");
        return TFiles.createFile(dir.resolve(sb.toString()), attrs);
    }

    public static TPath createTempFile(String prefix, String suffix, TFileAttribute<?> ... attrs) throws IOException {
        return TFiles.createTempFile(TPath.of(TSystem.getTempDir(), new String[0]), prefix, suffix, attrs);
    }

    public static TPath createTempDirectory(TPath dir, String prefix, TFileAttribute<?> ... attrs) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        TFiles.generateRandomName(sb);
        return TFiles.createDirectory(dir.resolve(sb.toString()), attrs);
    }

    public static TPath createTempDirectory(String prefix, TFileAttribute<?> ... attrs) throws IOException {
        return TFiles.createTempDirectory(TPath.of(TSystem.getTempDir(), new String[0]), prefix, attrs);
    }

    private static void generateRandomName(StringBuilder sb) {
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            int digit = random.nextInt(62);
            char c = digit < 10 ? (char)(48 + digit) : (digit < 36 ? (char)(digit - 10 + 65) : (char)(digit - 36 + 97));
            sb.append(c);
        }
    }

    public static void delete(TPath path) throws IOException {
        path.getFileSystem().provider().delete(path);
    }

    public static boolean deleteIfExists(TPath path) throws IOException {
        return path.getFileSystem().provider().deleteIfExists(path);
    }

    public static TPath readSymbolicLink(TPath link) throws IOException {
        return link.getFileSystem().provider().readSymbolicLink(link);
    }

    public static TPath copy(TPath source, TPath target, TCopyOption ... options) throws IOException {
        if (source.getFileSystem().provider() == target.getFileSystem().provider()) {
            source.getFileSystem().provider().copy(source, target, options);
        } else {
            TFiles.copyFallback(source, target, options);
        }
        return target;
    }

    public static TPath move(TPath source, TPath target, TCopyOption ... options) throws IOException {
        if (source.getFileSystem().provider() == target.getFileSystem().provider()) {
            source.getFileSystem().provider().move(source, target, options);
        } else {
            TFiles.copyFallback(source, target, options);
            TFiles.delete(source);
        }
        return target;
    }

    private static void copyFallback(TPath source, TPath target, TCopyOption ... options) throws IOException {
        TOpenOption[] tOpenOptionArray;
        boolean replace = false;
        block15: for (TCopyOption option : options) {
            if (!(option instanceof TStandardCopyOption)) continue;
            switch ((TStandardCopyOption)option) {
                case REPLACE_EXISTING: {
                    replace = true;
                    continue block15;
                }
                case COPY_ATTRIBUTES: {
                    continue block15;
                }
                case ATOMIC_MOVE: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (replace) {
            TOpenOption[] tOpenOptionArray2 = new TOpenOption[2];
            tOpenOptionArray2[0] = TStandardOpenOption.CREATE;
            tOpenOptionArray = tOpenOptionArray2;
            tOpenOptionArray2[1] = TStandardOpenOption.TRUNCATE_EXISTING;
        } else {
            TOpenOption[] tOpenOptionArray3 = new TOpenOption[1];
            tOpenOptionArray = tOpenOptionArray3;
            tOpenOptionArray3[0] = TStandardOpenOption.CREATE_NEW;
        }
        TOpenOption[] openOptions = tOpenOptionArray;
        try (InputStream input = TFiles.newInputStream(source, new TOpenOption[0]);
             OutputStream output = TFiles.newOutputStream(target, openOptions);){
            input.transferTo(output);
        }
    }

    public static boolean isSameFile(TPath path, TPath path2) throws IOException {
        if (Objects.equals(path, path2)) {
            return true;
        }
        if (path.getFileSystem().provider() != path2.getFileSystem().provider()) {
            return false;
        }
        return path.getFileSystem().provider().isSameFile(path, path2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long mismatch(TPath path, TPath path2) throws IOException {
        long size2;
        if (TFiles.isSameFile(path, path2)) {
            return -1L;
        }
        long size1 = TFiles.readAttributes(path, TBasicFileAttributes.class, new TLinkOption[0]).size();
        if (size1 != (size2 = TFiles.readAttributes(path2, TBasicFileAttributes.class, new TLinkOption[0]).size())) {
            return Math.min(size1, size2);
        }
        long offset = 0L;
        byte[] buf1 = new byte[2048];
        byte[] buf2 = new byte[2048];
        try (InputStream input1 = TFiles.newInputStream(path, new TOpenOption[0]);
             InputStream input2 = TFiles.newInputStream(path2, new TOpenOption[0]);){
            int sz1;
            do {
                int sz2;
                if ((sz1 = input1.readNBytes(buf1, 0, buf1.length)) != (sz2 = input2.readNBytes(buf2, 0, buf2.length))) {
                    long l = offset + (long)Math.min(sz1, sz2);
                    return l;
                }
                for (int i = 0; i < buf1.length; ++i) {
                    if (buf1[i] == buf2[i]) continue;
                    long l = offset + (long)i;
                    return l;
                }
                offset += (long)sz1;
            } while (sz1 >= buf1.length);
            return -1L;
        }
    }

    public static boolean isHidden(TPath path) throws IOException {
        return path.getFileSystem().provider().isHidden(path);
    }

    public static <A extends TBasicFileAttributes> A readAttributes(TPath path, Class<A> type, TLinkOption ... options) throws IOException {
        return path.getFileSystem().provider().readAttributes(path, type, options);
    }

    public static boolean isSymbolicLink(TPath path) {
        try {
            TBasicFileAttributes attr = TFiles.readAttributes(path, TBasicFileAttributes.class, new TLinkOption[0]);
            return attr.isSymbolicLink();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isDirectory(TPath path, TLinkOption ... options) {
        try {
            TBasicFileAttributes attr = TFiles.readAttributes(path, TBasicFileAttributes.class, options);
            return attr.isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isRegularFile(TPath path, TLinkOption ... options) {
        try {
            TBasicFileAttributes attr = TFiles.readAttributes(path, TBasicFileAttributes.class, options);
            return attr.isRegularFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static TFileTime getLastModifiedTime(TPath path, TLinkOption ... options) throws IOException {
        return TFiles.readAttributes(path, TBasicFileAttributes.class, options).lastModifiedTime();
    }

    public static long size(TPath path) throws IOException {
        return TFiles.readAttributes(path, TBasicFileAttributes.class, new TLinkOption[0]).size();
    }

    public static boolean exists(TPath path, TLinkOption ... options) {
        return path.getFileSystem().provider().exists(path, options);
    }

    public static boolean notExists(TPath path, TLinkOption ... options) {
        try {
            if (Arrays.asList(options).contains(TLinkOption.NOFOLLOW_LINKS)) {
                path.getFileSystem().provider().checkAccess(path, new TAccessMode[0]);
            } else {
                TFiles.readAttributes(path, TBasicFileAttributes.class, new TLinkOption[0]);
            }
        }
        catch (NoSuchFileException e) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public static boolean isReadable(TPath path) {
        try {
            path.getFileSystem().provider().checkAccess(path, TAccessMode.READ);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean isWritable(TPath path) {
        try {
            path.getFileSystem().provider().checkAccess(path, TAccessMode.WRITE);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean isExecutable(TPath path) {
        try {
            path.getFileSystem().provider().checkAccess(path, TAccessMode.EXECUTE);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static TPath walkFileTree(TPath start, Set<TFileVisitOption> options, int maxDepth, TFileVisitor<? super TPath> visitor) throws IOException {
        TFiles.walkFileTreeRec(start, maxDepth, visitor);
        return start;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TFileVisitResult walkFileTreeRec(TPath path, int remainingDepth, TFileVisitor<? super TPath> visitor) throws IOException {
        IOException exc;
        TBasicFileAttributes attrs;
        try {
            attrs = TFiles.readAttributes(path, TBasicFileAttributes.class, new TLinkOption[0]);
            exc = null;
        }
        catch (IOException e) {
            exc = e;
            attrs = null;
        }
        if (exc != null) {
            return visitor.visitFileFailed(path, exc);
        }
        if (remainingDepth == 0) return visitor.visitFile(path, attrs);
        if (!attrs.isDirectory()) {
            return visitor.visitFile(path, attrs);
        }
        switch (visitor.preVisitDirectory(path, attrs)) {
            case CONTINUE: {
                break;
            }
            case SKIP_SIBLINGS: {
                return TFileVisitResult.SKIP_SIBLINGS;
            }
            case SKIP_SUBTREE: {
                return TFileVisitResult.CONTINUE;
            }
            case TERMINATE: {
                return TFileVisitResult.TERMINATE;
            }
        }
        try (TDirectoryStream<TPath> stream = TFiles.newDirectoryStream(path);){
            Iterator<TPath> iterator = stream.iterator();
            while (iterator.hasNext()) {
                TPath child = iterator.next();
                switch (TFiles.walkFileTreeRec(child, remainingDepth - 1, visitor)) {
                    case CONTINUE: 
                    case SKIP_SUBTREE: {
                        break;
                    }
                    case TERMINATE: {
                        TFileVisitResult tFileVisitResult = TFileVisitResult.TERMINATE;
                        return tFileVisitResult;
                    }
                    case SKIP_SIBLINGS: {
                        return visitor.postVisitDirectory(path, exc);
                    }
                }
            }
            return visitor.postVisitDirectory(path, exc);
        }
        catch (IOException e) {
            exc = e;
        }
        return visitor.postVisitDirectory(path, exc);
    }

    public static TPath walkFileTree(TPath start, TFileVisitor<? super TPath> visitor) throws IOException {
        return TFiles.walkFileTree(start, EnumSet.noneOf(TFileVisitOption.class), Integer.MAX_VALUE, visitor);
    }

    public static BufferedReader newBufferedReader(TPath path, Charset cs) throws IOException {
        return new BufferedReader(new InputStreamReader(TFiles.newInputStream(path, new TOpenOption[0]), cs));
    }

    public static BufferedReader newBufferedReader(TPath path) throws IOException {
        return TFiles.newBufferedReader(path, StandardCharsets.UTF_8);
    }

    public static BufferedWriter newBufferedWriter(TPath path, Charset cs, TOpenOption ... options) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(TFiles.newOutputStream(path, options), cs));
    }

    public static BufferedWriter newBufferedWriter(TPath path, TOpenOption ... options) throws IOException {
        return TFiles.newBufferedWriter(path, StandardCharsets.UTF_8, options);
    }

    public static long copy(InputStream in, TPath target, TCopyOption ... options) throws IOException {
        TOpenOption[] tOpenOptionArray;
        boolean replace = false;
        block9: for (TCopyOption option : options) {
            if (!(option instanceof TStandardCopyOption)) continue;
            switch ((TStandardCopyOption)option) {
                case REPLACE_EXISTING: {
                    replace = true;
                    continue block9;
                }
                case COPY_ATTRIBUTES: 
                case ATOMIC_MOVE: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (replace) {
            TOpenOption[] tOpenOptionArray2 = new TOpenOption[2];
            tOpenOptionArray2[0] = TStandardOpenOption.CREATE;
            tOpenOptionArray = tOpenOptionArray2;
            tOpenOptionArray2[1] = TStandardOpenOption.TRUNCATE_EXISTING;
        } else {
            TOpenOption[] tOpenOptionArray3 = new TOpenOption[1];
            tOpenOptionArray = tOpenOptionArray3;
            tOpenOptionArray3[0] = TStandardOpenOption.CREATE_NEW;
        }
        TOpenOption[] openOptions = tOpenOptionArray;
        try (OutputStream output = TFiles.newOutputStream(target, openOptions);){
            long l = in.transferTo(output);
            return l;
        }
    }

    public static long copy(TPath source, OutputStream out) throws IOException {
        try (InputStream input = TFiles.newInputStream(source, new TOpenOption[0]);){
            long l = input.transferTo(out);
            return l;
        }
    }

    public static byte[] readAllBytes(TPath path) throws IOException {
        try (InputStream input = TFiles.newInputStream(path, new TOpenOption[0]);){
            byte[] byArray = input.readAllBytes();
            return byArray;
        }
    }

    public static String readString(TPath path) throws IOException {
        StringWriter out = new StringWriter();
        try (BufferedReader reader = TFiles.newBufferedReader(path);){
            reader.transferTo(out);
        }
        return out.toString();
    }

    public static String readString(TPath path, Charset cs) throws IOException {
        StringWriter out = new StringWriter();
        try (BufferedReader reader = TFiles.newBufferedReader(path, cs);){
            reader.transferTo(out);
        }
        return out.toString();
    }

    public static List<String> readAllLines(TPath path, Charset cs) throws IOException {
        try (BufferedReader reader = TFiles.newBufferedReader(path, cs);){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    public static List<String> readAllLines(TPath path) throws IOException {
        return TFiles.readAllLines(path, StandardCharsets.UTF_8);
    }

    public static TPath write(TPath path, byte[] bytes, TOpenOption ... options) throws IOException {
        try (OutputStream output = TFiles.newOutputStream(path, options);){
            output.write(bytes);
        }
        return path;
    }

    public static TPath write(TPath path, Iterable<? extends CharSequence> lines, Charset cs, TOpenOption ... options) throws IOException {
        try (BufferedWriter writer = TFiles.newBufferedWriter(path, cs, options);){
            for (CharSequence charSequence : lines) {
                writer.write(charSequence.toString());
                writer.newLine();
            }
        }
        return path;
    }

    public static TPath write(TPath path, Iterable<? extends CharSequence> lines, TOpenOption ... options) throws IOException {
        return TFiles.write(path, lines, StandardCharsets.UTF_8, options);
    }

    public static TPath writeString(TPath path, CharSequence csq, TOpenOption ... options) throws IOException {
        return TFiles.writeString(path, csq, StandardCharsets.UTF_8, options);
    }

    public static TPath writeString(TPath path, CharSequence csq, Charset cs, TOpenOption ... options) throws IOException {
        try (BufferedWriter writer = TFiles.newBufferedWriter(path, cs, options);){
            writer.write(csq.toString());
        }
        return path;
    }

    public static Stream<TPath> list(TPath dir) throws IOException {
        TDirectoryStream<TPath> dirStream = TFiles.newDirectoryStream(dir);
        return (Stream)StreamSupport.stream(dirStream.spliterator(), false).onClose(() -> {
            try {
                dirStream.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static Stream<TPath> walk(TPath start, int maxDepth, TFileVisitOption ... options) throws IOException {
        return TFiles.walkRec(start, maxDepth);
    }

    private static Stream<TPath> walkRec(TPath path, int maxDepth) throws IOException {
        Stream<TPath> result = Stream.of(path);
        if (maxDepth > 0 && TFiles.isDirectory(path, new TLinkOption[0])) {
            result = Stream.concat(result, TFiles.list(path).flatMap(child -> {
                try {
                    return TFiles.walkRec(child, maxDepth - 1);
                }
                catch (IOException e) {
                    return Stream.empty();
                }
            }));
        }
        return result;
    }

    public static Stream<TPath> walk(TPath start, TFileVisitOption ... options) throws IOException {
        return TFiles.walk(start, Integer.MAX_VALUE, options);
    }

    public static Stream<TPath> find(TPath start, int maxDepth, BiPredicate<TPath, TBasicFileAttributes> matcher, TFileVisitOption ... options) throws IOException {
        return TFiles.findRec(start, maxDepth, matcher);
    }

    private static Stream<TPath> findRec(TPath path, int maxDepth, BiPredicate<TPath, TBasicFileAttributes> matcher) throws IOException {
        Stream<TPath> result;
        TBasicFileAttributes attr = TFiles.readAttributes(path, TBasicFileAttributes.class, new TLinkOption[0]);
        Stream<TPath> stream = result = matcher.test(path, attr) ? Stream.of(path) : null;
        if (maxDepth > 0 && attr.isDirectory()) {
            Stream<TPath> next = Stream.concat(result, TFiles.list(path).flatMap(child -> {
                try {
                    return TFiles.findRec(child, maxDepth - 1, matcher);
                }
                catch (IOException e) {
                    return Stream.empty();
                }
            }));
            result = result != null ? Stream.concat(result, next) : next;
        }
        return result;
    }

    public static Stream<String> lines(TPath path, Charset cs) throws IOException {
        BufferedReader reader = TFiles.newBufferedReader(path, cs);
        return (Stream)reader.lines().onClose(() -> {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static Stream<String> lines(TPath path) throws IOException {
        return TFiles.lines(path, StandardCharsets.UTF_8);
    }
}

