/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteBufferNative;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TJSBufferHelper;
import org.teavm.classlib.java.nio.TNativeBufferObjectMarker;
import org.teavm.classlib.java.nio.TShortBuffer;
import org.teavm.classlib.java.nio.TShortBufferImpl;
import org.teavm.classlib.java.nio.file.TAddressBasedBuffer;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Int16Array;

class TShortBufferNative
extends TShortBufferImpl
implements TArrayBufferViewProvider,
TAddressBasedBuffer {
    Object gcRef;
    short[] array;
    boolean readOnly;
    @TNativeBufferObjectMarker
    protected final Object base;
    Address address;
    int capacity;
    boolean swap;

    TShortBufferNative(Object gcRef, short[] array, int position, int limit, boolean readOnly, Object base, Address address, int capacity, boolean swap) {
        super(position, limit);
        this.gcRef = gcRef;
        this.array = array;
        this.readOnly = readOnly;
        this.base = base;
        this.address = address;
        this.capacity = capacity;
        this.swap = swap;
    }

    @Override
    public Address getDataAddress() {
        return this.address;
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    short[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return (int)(this.address.diff(Address.ofData((short[])this.array)) / 2L);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.base == null;
    }

    @Override
    TShortBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TShortBufferNative(this, this.array, position, limit, readOnly, this.base, this.address.add(start * 2), capacity, this.swap);
    }

    @Override
    short getElement(int index) {
        short result = this.address.add(index * 2).getShort();
        return this.swap ? Short.reverseBytes(result) : result;
    }

    @Override
    void putElement(int index, short value) {
        this.address.add(index * 2).putShort(this.swap ? Short.reverseBytes(value) : value);
    }

    @Override
    void getImpl(int index, short[] dst, int offset, int length) {
        Address addr = this.address.add(index * 2);
        if (this.swap) {
            while (length-- > 0) {
                dst[offset++] = Short.reverseBytes(addr.getShort());
                addr = addr.add(2);
            }
        } else {
            this.copy(addr, dst, offset, length);
        }
    }

    @Override
    void putImpl(int index, short[] src, int offset, int length) {
        Address addr = this.address.add(index * 2);
        if (this.swap) {
            while (length-- > 0) {
                addr.putShort(Short.reverseBytes(src[offset++]));
                addr = addr.add(2);
            }
        } else {
            this.copy(src, offset, addr, length);
        }
    }

    @Override
    void putImpl(int index, TShortBuffer src, int offset, int length) {
        if (src instanceof TShortBufferNative) {
            TShortBufferNative srcImpl = (TShortBufferNative)src;
            Address addr = this.address.add(index * 2);
            if (srcImpl.swap == this.swap) {
                TByteBufferNative.copy(srcImpl.address.add(offset * 2), addr, length * 2);
            } else {
                Address srcAddr = srcImpl.address.add(offset * 2);
                while (length-- > 0) {
                    addr.putShort(Short.reverseBytes(srcAddr.getShort()));
                    addr = addr.add(2);
                    srcAddr = srcAddr.add(2);
                }
            }
        } else {
            Address addr = this.address.add(index * 2);
            if (this.swap) {
                while (length-- > 0) {
                    addr.putShort(Short.reverseBytes(src.get(offset++)));
                    addr = addr.add(2);
                }
            } else {
                while (length-- > 0) {
                    addr.putShort(src.get(offset++));
                    addr = addr.add(2);
                }
            }
        }
    }

    @Override
    public TByteOrder order() {
        return this.swap ? TByteBufferNative.oppositeOrder(TByteOrder.nativeOrder()) : TByteOrder.nativeOrder();
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return new Int16Array(TJSBufferHelper.WasmGC.getLinearMemory(), this.address.toInt(), this.capacity);
    }

    @Override
    public int elementSize() {
        return 2;
    }

    void copy(short[] from, int fromOffset, Address to, int count) {
        TByteBufferNative.copy(Address.ofData((short[])from).add(fromOffset * 2), to, count * 2);
    }

    void copy(Address from, short[] to, int toOffset, int count) {
        TByteBufferNative.copy(from, Address.ofData((short[])to).add(toOffset * 2), count * 2);
    }
}

