/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.nio.TBuffer;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.classlib.java.nio.TShortBufferNative;
import org.teavm.classlib.java.nio.TShortBufferOverArray;
import org.teavm.classlib.java.nio.TShortBufferOverTypedArray;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.Int16Array;

public abstract class TShortBuffer
extends TBuffer
implements Comparable<TShortBuffer> {
    TShortBuffer(int position, int limit) {
        this.position = position;
        this.limit = limit;
    }

    public static TShortBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        if (PlatformDetector.isJavaScript()) {
            short[] array = new short[capacity];
            return new TShortBufferOverTypedArray(0, capacity, false, Int16Array.fromJavaArray((short[])array), array);
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            short[] array = new short[capacity];
            return new TShortBufferNative(null, array, 0, capacity, false, array, Address.ofData((short[])array), capacity, false);
        }
        return new TShortBufferOverArray(capacity);
    }

    public static TShortBuffer wrap(short[] array, int offset, int length) {
        if (PlatformDetector.isJavaScript()) {
            TShortBufferOverTypedArray result = new TShortBufferOverTypedArray(0, array.length, false, Int16Array.fromJavaArray((short[])array), array);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            TShortBufferNative result = new TShortBufferNative(null, array, 0, array.length, false, array, Address.ofData((short[])array), array.length, false);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        return new TShortBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TShortBuffer wrap(short[] array) {
        return TShortBuffer.wrap(array, 0, array.length);
    }

    public abstract TShortBuffer slice();

    public abstract TShortBuffer duplicate();

    public abstract TShortBuffer asReadOnlyBuffer();

    public abstract short get();

    public abstract TShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract TShortBuffer put(int var1, short var2);

    abstract short getElement(int var1);

    abstract void putElement(int var1, short var2);

    public TShortBuffer get(short[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.remaining()) {
            throw new TBufferUnderflowException();
        }
        this.getImpl(this.position, dst, offset, length);
        this.position += length;
        return this;
    }

    public TShortBuffer get(int index, short[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.getImpl(index, dst, offset, length);
        return this;
    }

    public TShortBuffer get(int index, short[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    abstract void getImpl(int var1, short[] var2, int var3, int var4);

    public TShortBuffer get(short[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TShortBuffer put(TShortBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        int elementsToTransfer = src.remaining();
        if (this.remaining() < elementsToTransfer) {
            throw new TBufferOverflowException();
        }
        this.putImpl(this.position, src, src.position, elementsToTransfer);
        this.position += elementsToTransfer;
        src.position += elementsToTransfer;
        return this;
    }

    public TShortBuffer put(int index, TShortBuffer src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index > this.limit() || offset < 0 || offset + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    abstract void putImpl(int var1, TShortBuffer var2, int var3, int var4);

    public TShortBuffer put(short[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(this.position, src, offset, length);
        this.position += length;
        return this;
    }

    public TShortBuffer put(int index, short[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    public TShortBuffer put(int index, short[] src) {
        return this.put(index, src, 0, src.length);
    }

    public final TShortBuffer put(short[] src) {
        return this.put(src, 0, src.length);
    }

    abstract void putImpl(int var1, short[] var2, int var3, int var4);

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final short[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract short[] getArray();

    abstract int getArrayOffset();

    public abstract TShortBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[ShortBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity() + ", mark " + (String)(this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            hashCode = 31 * hashCode + this.getElement(pos++);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TShortBuffer)) {
            return false;
        }
        TShortBuffer other = (TShortBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getElement(a++) == other.getElement(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TShortBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Short.compare(this.getElement(a++), other.getElement(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public abstract TByteOrder order();

    @Override
    public final TShortBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TShortBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TShortBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TShortBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TShortBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TShortBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TShortBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

