/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.nio.TBuffer;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TDoubleBufferNative;
import org.teavm.classlib.java.nio.TDoubleBufferOverArray;
import org.teavm.classlib.java.nio.TDoubleBufferOverTypedArray;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.Float64Array;

public abstract class TDoubleBuffer
extends TBuffer
implements Comparable<TDoubleBuffer> {
    TDoubleBuffer(int position, int limit) {
        this.position = position;
        this.limit = limit;
    }

    public static TDoubleBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        if (PlatformDetector.isJavaScript()) {
            double[] array = new double[capacity];
            return new TDoubleBufferOverTypedArray(0, capacity, false, Float64Array.fromJavaArray((double[])array), array);
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            double[] array = new double[capacity];
            return new TDoubleBufferNative(null, array, 0, capacity, false, array, Address.ofData((double[])array), capacity, false);
        }
        return new TDoubleBufferOverArray(capacity);
    }

    public static TDoubleBuffer wrap(double[] array, int offset, int length) {
        if (PlatformDetector.isJavaScript()) {
            TDoubleBufferOverTypedArray result = new TDoubleBufferOverTypedArray(0, array.length, false, Float64Array.fromJavaArray((double[])array), array);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            TDoubleBufferNative result = new TDoubleBufferNative(null, array, 0, array.length, false, array, Address.ofData((double[])array), array.length, false);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        return new TDoubleBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TDoubleBuffer wrap(double[] array) {
        return TDoubleBuffer.wrap(array, 0, array.length);
    }

    public abstract TDoubleBuffer slice();

    public abstract TDoubleBuffer duplicate();

    public abstract TDoubleBuffer asReadOnlyBuffer();

    public abstract double get();

    public abstract TDoubleBuffer put(double var1);

    public abstract double get(int var1);

    public abstract TDoubleBuffer put(int var1, double var2);

    abstract double getElement(int var1);

    abstract void putElement(int var1, double var2);

    public TDoubleBuffer get(double[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.remaining()) {
            throw new TBufferUnderflowException();
        }
        this.getImpl(this.position, dst, offset, length);
        this.position += length;
        return this;
    }

    public TDoubleBuffer get(int index, double[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.getImpl(index, dst, offset, length);
        return this;
    }

    public TDoubleBuffer get(int index, double[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    abstract void getImpl(int var1, double[] var2, int var3, int var4);

    public TDoubleBuffer get(double[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TDoubleBuffer put(int index, TDoubleBuffer src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index > this.limit() || offset < 0 || offset + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    abstract void putImpl(int var1, TDoubleBuffer var2, int var3, int var4);

    public TDoubleBuffer put(TDoubleBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        int elementsToTransfer = src.remaining();
        if (this.remaining() < elementsToTransfer) {
            throw new TBufferOverflowException();
        }
        this.putImpl(this.position, src, src.position, elementsToTransfer);
        this.position += elementsToTransfer;
        src.position += elementsToTransfer;
        return this;
    }

    public TDoubleBuffer put(double[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(this.position, src, offset, length);
        this.position += length;
        return this;
    }

    public TDoubleBuffer put(int index, double[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    public final TDoubleBuffer put(double[] src) {
        return this.put(src, 0, src.length);
    }

    public TDoubleBuffer put(int index, double[] src) {
        return this.put(index, src, 0, src.length);
    }

    abstract void putImpl(int var1, double[] var2, int var3, int var4);

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final double[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract double[] getArray();

    abstract int getArrayOffset();

    public abstract TDoubleBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[DoubleBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity() + ", mark " + (String)(this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            long elem = Double.doubleToLongBits(this.getElement(pos++));
            hashCode = 31 * hashCode + (int)elem + (int)(elem >>> 32);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TDoubleBuffer)) {
            return false;
        }
        TDoubleBuffer other = (TDoubleBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getElement(a++) == other.getElement(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TDoubleBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Double.compare(this.getElement(a++), other.getElement(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public abstract TByteOrder order();

    @Override
    public final TDoubleBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TDoubleBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TDoubleBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TDoubleBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TDoubleBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TDoubleBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TDoubleBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

