/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteBufferNative;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferImpl;
import org.teavm.classlib.java.nio.TJSBufferHelper;
import org.teavm.classlib.java.nio.TNativeBufferObjectMarker;
import org.teavm.classlib.java.nio.file.TAddressBasedBuffer;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Uint16Array;

class TCharBufferNative
extends TCharBufferImpl
implements TArrayBufferViewProvider,
TAddressBasedBuffer {
    Object gcRef;
    char[] array;
    boolean readOnly;
    @TNativeBufferObjectMarker
    final Object base;
    Address address;
    int capacity;
    boolean swap;

    TCharBufferNative(Object gcRef, char[] array, int position, int limit, boolean readOnly, Object base, Address address, int capacity, boolean swap) {
        super(position, limit);
        this.array = array;
        this.readOnly = readOnly;
        this.base = base;
        this.address = address;
        this.capacity = capacity;
        this.swap = swap;
    }

    @Override
    public Address getDataAddress() {
        return this.address;
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    char[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return (int)(this.address.diff(Address.ofData((char[])this.array)) / 2L);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.base == null;
    }

    @Override
    TCharBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TCharBufferNative(this.gcRef, this.array, position, limit, readOnly, this.base, this.address.add(start * 2), capacity, this.swap);
    }

    @Override
    char getChar(int index) {
        char result = this.address.add(index * 2).getChar();
        return this.swap ? Character.reverseBytes(result) : result;
    }

    @Override
    void putChar(int index, char value) {
        this.address.add(index * 2).putChar(this.swap ? Character.reverseBytes(value) : value);
    }

    @Override
    void getImpl(int index, char[] dst, int offset, int length) {
        Address addr = this.address.add(index * 2);
        if (this.swap) {
            while (length-- > 0) {
                dst[offset++] = Character.reverseBytes(addr.getChar());
                addr = addr.add(2);
            }
        } else {
            this.copy(addr, dst, offset, length);
        }
    }

    @Override
    void putImpl(int index, char[] src, int offset, int length) {
        Address addr = this.address.add(index * 2);
        if (this.swap) {
            while (length-- > 0) {
                addr.putChar(Character.reverseBytes(src[offset++]));
                addr = addr.add(2);
            }
        } else {
            this.copy(src, offset, addr, length);
        }
    }

    @Override
    void putImpl(int index, TCharBuffer src, int offset, int length) {
        if (src instanceof TCharBufferNative) {
            TCharBufferNative srcImpl = (TCharBufferNative)src;
            Address addr = this.address.add(index * 2);
            if (srcImpl.swap == this.swap) {
                TByteBufferNative.copy(srcImpl.address.add(offset * 2), addr, length * 2);
            } else {
                Address srcAddr = srcImpl.address.add(offset * 2);
                while (length-- > 0) {
                    addr.putChar(Character.reverseBytes(srcAddr.getChar()));
                    addr = addr.add(2);
                    srcAddr = srcAddr.add(2);
                }
            }
        } else {
            Address addr = this.address.add(index * 2);
            if (this.swap) {
                while (length-- > 0) {
                    addr.putChar(Character.reverseBytes(src.get(offset++)));
                    addr = addr.add(2);
                }
            } else {
                while (length-- > 0) {
                    addr.putChar(src.get(offset++));
                    addr = addr.add(2);
                }
            }
        }
    }

    @Override
    void putImpl(int index, String src, int offset, int length) {
        Address addr = this.address.add(index * 2);
        if (this.swap) {
            while (length-- > 0) {
                addr.putChar(Character.reverseBytes(src.charAt(offset++)));
                addr = addr.add(2);
            }
        } else {
            while (length-- > 0) {
                addr.putChar(src.charAt(offset++));
                addr = addr.add(2);
            }
        }
    }

    @Override
    public TByteOrder order() {
        return this.swap ? TByteBufferNative.oppositeOrder(TByteOrder.nativeOrder()) : TByteOrder.nativeOrder();
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return new Uint16Array(TJSBufferHelper.WasmGC.getLinearMemory(), this.address.toInt(), this.capacity);
    }

    @Override
    public int elementSize() {
        return 2;
    }

    void copy(char[] from, int fromOffset, Address to, int count) {
        TByteBufferNative.copy(Address.ofData((char[])from).add(fromOffset * 2), to, count * 2);
    }

    void copy(Address from, char[] to, int toOffset, int count) {
        TByteBufferNative.copy(from, Address.ofData((char[])to).add(toOffset * 2), count * 2);
    }
}

