/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.TClassLoader;
import org.teavm.classlib.java.lang.TDefaultUncaughtExceptionHandler;
import org.teavm.classlib.java.lang.TInterruptedException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TRunnable;
import org.teavm.classlib.java.lang.TStackTraceElement;
import org.teavm.classlib.java.lang.TThreadInterruptHandler;
import org.teavm.interop.Async;
import org.teavm.interop.AsyncCallback;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformRunnable;
import org.teavm.runtime.EventQueue;
import org.teavm.runtime.Fiber;

public class TThread
extends TObject
implements TRunnable {
    private static TThread mainThread;
    private static TThread currentThread;
    private static int nextId;
    private static int activeCount;
    private static UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private UncaughtExceptionHandler uncaughtExceptionHandler;
    private long id;
    private int priority;
    private boolean daemon;
    private long timeSliceStart;
    private int yieldCount;
    private final Object finishedLock = new Object();
    private boolean interruptedFlag;
    public TThreadInterruptHandler interruptHandler;
    public Object key;
    private String name;
    private boolean alive = true;
    TRunnable target;

    public TThread() {
        this(null, null);
    }

    public TThread(String name) {
        this(null, name);
    }

    public TThread(TRunnable target) {
        this(target, null);
    }

    public TThread(TRunnable target, String name) {
        this.name = name;
        this.target = target;
        this.id = nextId++;
    }

    public void start() {
        if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
            boolean daemon = this.daemon;
            if (!daemon) {
                ++Fiber.userThreadCount;
            }
            EventQueue.offer(() -> Fiber.start(this::runThread, (boolean)daemon));
        } else {
            Platform.startThread(this::runThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runThread() {
        try {
            ++activeCount;
            TThread.setCurrentThread(this);
            this.key = new Object();
            this.run();
        }
        catch (Throwable t) {
            this.getUncaughtExceptionHandler().uncaughtException(this, t);
        }
        finally {
            Object object = this.finishedLock;
            synchronized (object) {
                this.finishedLock.notifyAll();
            }
            this.alive = false;
            --activeCount;
            this.key = null;
            TThread.setCurrentThread(mainThread);
        }
    }

    static void setCurrentThread(TThread thread) {
        if (currentThread != thread) {
            currentThread = thread;
        }
        TThread.currentThread.timeSliceStart = System.currentTimeMillis();
    }

    static TThread getMainThread() {
        return mainThread;
    }

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    public static TThread currentThread() {
        return currentThread;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join(long millis, int nanos) throws InterruptedException {
        if (TThread.currentThread() == this) {
            return;
        }
        Object object = this.finishedLock;
        synchronized (object) {
            this.finishedLock.wait(millis, nanos);
        }
    }

    public final void join(long millis) throws InterruptedException {
        this.join(millis, 0);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void yield() {
        TThread currentThread = TThread.currentThread();
        if (++currentThread.yieldCount < 30) {
            return;
        }
        TThread.currentThread().yieldCount = 0;
        if (currentThread.timeSliceStart + 100L < System.currentTimeMillis()) {
            TThread.switchContext(currentThread);
        }
    }

    @Async
    static native void switchContext(TThread var0);

    private static void switchContext(TThread thread, AsyncCallback<Void> callback) {
        if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
            EventQueue.offer(() -> {
                TThread.setCurrentThread(thread);
                callback.complete(null);
            });
        } else {
            Platform.postpone(() -> {
                TThread.setCurrentThread(thread);
                callback.complete(null);
            });
        }
    }

    public void interrupt() {
        this.interruptedFlag = true;
        if (this.interruptHandler != null) {
            this.interruptHandler.interrupted();
            this.interruptHandler = null;
        }
    }

    public static boolean interrupted() {
        TThread thread = TThread.currentThread();
        boolean result = thread.interruptedFlag;
        thread.interruptedFlag = false;
        return result;
    }

    public boolean isInterrupted() {
        return this.interruptedFlag;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public static int activeCount() {
        return activeCount;
    }

    public long getId() {
        return this.id;
    }

    public static boolean holdsLock(TObject obj) {
        return TObject.holdsLock(obj);
    }

    @Async
    public static native void sleep(long var0) throws TInterruptedException;

    private static void sleep(long millis, AsyncCallback<Void> callback) {
        TThread current = TThread.currentThread();
        SleepHandler handler = new SleepHandler(current, callback);
        if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
            if (current.interruptedFlag) {
                handler.interrupted();
            } else {
                handler.scheduleId = EventQueue.offer((EventQueue.Event)handler, (long)(System.currentTimeMillis() + millis));
                current.interruptHandler = handler;
            }
        } else {
            int intMillis = millis < Integer.MAX_VALUE ? (int)millis : Integer.MAX_VALUE;
            handler.scheduleId = Platform.schedule((PlatformRunnable)handler, (int)intMillis);
            current.interruptHandler = handler;
        }
    }

    public final void setPriority(int newPriority) {
        this.priority = newPriority;
    }

    public final int getPriority() {
        return this.priority;
    }

    public TStackTraceElement[] getStackTrace() {
        return new TStackTraceElement[0];
    }

    public TClassLoader getContextClassLoader() {
        return TClassLoader.getSystemClassLoader();
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (this.uncaughtExceptionHandler != null) {
            return this.uncaughtExceptionHandler;
        }
        return defaultUncaughtExceptionHandler;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        defaultUncaughtExceptionHandler = handler;
    }

    static {
        currentThread = mainThread = new TThread("main");
        nextId = 1;
        activeCount = 1;
        defaultUncaughtExceptionHandler = new TDefaultUncaughtExceptionHandler();
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(TThread var1, Throwable var2);
    }

    static class SleepHandler
    implements PlatformRunnable,
    EventQueue.Event,
    TThreadInterruptHandler {
        private TThread thread;
        private AsyncCallback<Void> callback;
        private boolean isInterrupted;
        int scheduleId;

        SleepHandler(TThread thread, AsyncCallback<Void> callback) {
            this.thread = thread;
            this.callback = callback;
        }

        @Override
        public void interrupted() {
            this.thread.interruptedFlag = false;
            this.isInterrupted = true;
            if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
                EventQueue.kill((int)this.scheduleId);
                EventQueue.offer(() -> this.callback.error((Throwable)new TInterruptedException()));
            } else {
                Platform.killSchedule((int)this.scheduleId);
                Platform.postpone(() -> this.callback.error((Throwable)new TInterruptedException()));
            }
        }

        public void run() {
            if (!this.isInterrupted) {
                this.thread.interruptHandler = null;
                TThread.setCurrentThread(this.thread);
                this.callback.complete(null);
            }
        }
    }
}

