/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.impl.text.DoubleSynthesizer;
import org.teavm.classlib.java.lang.DoubleGenerator;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.interop.Import;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSBody;

@NoSideEffects
public class TDouble
extends TNumber
implements TComparable<TDouble> {
    public static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    public static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    public static final double NaN = Double.NaN;
    public static final double MAX_VALUE = Double.MAX_VALUE;
    public static final double MIN_NORMAL = -4.49423283715579E307;
    public static final double MIN_VALUE = Double.MIN_VALUE;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_EXPONENT = -1022;
    public static final int SIZE = 64;
    public static final int BYTES = 8;
    public static final Class<Double> TYPE = Double.TYPE;
    private final double value;

    public TDouble(double value) {
        this.value = value;
    }

    public TDouble(String value) throws TNumberFormatException {
        this.value = TDouble.parseDouble(value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    public static TDouble valueOf(double d) {
        return new TDouble(d);
    }

    public static String toString(double d) {
        return new TStringBuilder().append(d).toString();
    }

    public static TDouble valueOf(String string) {
        return TDouble.valueOf(TDouble.parseDouble(string));
    }

    public static double parseDouble(String string) throws NumberFormatException {
        if (string.isEmpty()) {
            throw new NumberFormatException();
        }
        int start = 0;
        int end = string.length();
        while (string.charAt(start) <= ' ') {
            if (++start != end) continue;
            throw new NumberFormatException();
        }
        while (string.charAt(end - 1) <= ' ') {
            --end;
        }
        if (string.charAt(end - 1) == 'f' || string.charAt(end - 1) == 'F' || string.charAt(end - 1) == 'd' || string.charAt(end - 1) == 'D') {
            --end;
        }
        boolean negative = false;
        int index = start;
        if (string.charAt(index) == '-') {
            ++index;
            negative = true;
        } else if (string.charAt(index) == '+') {
            ++index;
        }
        if (index == end) {
            throw new NumberFormatException();
        }
        char c = string.charAt(index);
        long mantissa = 0L;
        int exp = -1;
        boolean hasOneDigit = false;
        long mantissaPos = 1000000000000000000L;
        if (c != '.') {
            hasOneDigit = true;
            if (c < '0' || c > '9') {
                throw new NumberFormatException();
            }
            while (index < end && string.charAt(index) == '0') {
                ++index;
            }
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                if (mantissaPos > 0L) {
                    mantissa += mantissaPos * (long)(c - 48);
                    mantissaPos = Long.divideUnsigned(mantissaPos, 10L);
                }
                ++exp;
                ++index;
            }
        }
        if (index < end && string.charAt(index) == '.') {
            ++index;
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                if (mantissa == 0L && c == '0') {
                    --exp;
                } else if (mantissaPos > 0L) {
                    mantissa += mantissaPos * (long)(c - 48);
                    mantissaPos = Long.divideUnsigned(mantissaPos, 10L);
                }
                ++index;
                hasOneDigit = true;
            }
            if (!hasOneDigit) {
                throw new NumberFormatException();
            }
        }
        if (index < end) {
            c = string.charAt(index);
            if (c != 'e' && c != 'E') {
                throw new NumberFormatException();
            }
            boolean negativeExp = false;
            if (++index == end) {
                throw new NumberFormatException();
            }
            if (string.charAt(index) == '-') {
                ++index;
                negativeExp = true;
            } else if (string.charAt(index) == '+') {
                ++index;
            }
            int numExp = 0;
            hasOneDigit = false;
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                numExp = 10 * numExp + (c - 48);
                hasOneDigit = true;
                ++index;
            }
            if (!hasOneDigit) {
                throw new NumberFormatException();
            }
            if (negativeExp) {
                numExp = -numExp;
            }
            exp += numExp;
        }
        return DoubleSynthesizer.synthesizeDouble(mantissa, exp, negative);
    }

    @Override
    public String toString() {
        return TDouble.toString(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TDouble && TDouble.equals(this.value, ((TDouble)other).value);
    }

    private static boolean equals(double a, double b) {
        return PlatformDetector.isJavaScript() ? TDouble.doubleEqualsJs(a, b) : TDouble.equalsWithBits(a, b);
    }

    @InjectedBy(value=DoubleGenerator.class)
    private static native boolean doubleEqualsJs(double var0, double var2);

    private static boolean equalsWithBits(double a, double b) {
        return a != a ? b != b : TDouble.doubleToRawLongBits(a) == TDouble.doubleToRawLongBits(b);
    }

    @Override
    public int hashCode() {
        return TDouble.hashCode(this.value);
    }

    public static int hashCode(double d) {
        long h = TDouble.doubleToLongBits(d);
        return (int)(h >>> 32) ^ (int)h;
    }

    @NoSideEffects
    public static int compare(double a, double b) {
        int diff = (a > b ? 1 : 0) - (b > a ? 1 : 0);
        return diff != 0 ? diff : (1.0 / a > 1.0 / b ? 1 : 0) - (1.0 / b > 1.0 / a ? 1 : 0) + (b == b ? 1 : 0) - (a == a ? 1 : 0);
    }

    @Override
    public int compareTo(TDouble other) {
        return TDouble.compare(this.value, other.value);
    }

    public boolean isNaN() {
        return TDouble.isNaN(this.value);
    }

    public boolean isInfinite() {
        return TDouble.isInfinite(this.value);
    }

    @JSBody(params={"v"}, script="return isNaN(v);")
    @Import(module="teavm", name="isnan")
    @NoSideEffects
    @Unmanaged
    public static native boolean isNaN(double var0);

    @JSBody(params={"v"}, script="return !isFinite(v);")
    @Import(module="teavm", name="isinf")
    @NoSideEffects
    @Unmanaged
    public static native boolean isInfinite(double var0);

    @JSBody(params={"v"}, script="return isFinite(v);")
    @Import(module="teavm", name="isfinite")
    @NoSideEffects
    @Unmanaged
    public static native boolean isFinite(double var0);

    @InjectedBy(value=DoubleGenerator.class)
    @Import(name="teavm_reinterpretDoubleToLong")
    @NoSideEffects
    @Unmanaged
    public static native long doubleToRawLongBits(double var0);

    public static long doubleToLongBits(double value) {
        if (TDouble.isNaN(value)) {
            return 9221120237041090560L;
        }
        return TDouble.doubleToRawLongBits(value);
    }

    @InjectedBy(value=DoubleGenerator.class)
    @Import(name="teavm_reinterpretLongToDouble")
    @NoSideEffects
    @Unmanaged
    public static native double longBitsToDouble(long var0);

    public static String toHexString(double d) {
        if (TDouble.isNaN(d)) {
            return "NaN";
        }
        if (TDouble.isInfinite(d)) {
            return d > 0.0 ? "Infinity" : "-Infinity";
        }
        char[] buffer = new char[30];
        int sz = 0;
        long bits = TDouble.doubleToLongBits(d);
        boolean subNormal = false;
        boolean negative = (bits & Long.MIN_VALUE) != 0L;
        int exp = (int)(bits >>> 52 & 0x7FFL) - 1023;
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        if (exp == -1023) {
            if (mantissa == 0L) {
                return negative ? "-0x0.0p0" : "0x0.0p0";
            }
            ++exp;
            subNormal = true;
        }
        for (int i = 0; i < 13; ++i) {
            int digit = (int)(mantissa & 0xFL);
            if (digit > 0 || sz > 0) {
                buffer[sz++] = TCharacter.forDigit(digit, 16);
            }
            mantissa >>>= 4;
        }
        if (sz == 0) {
            buffer[sz++] = 48;
        }
        buffer[sz++] = 46;
        buffer[sz++] = subNormal ? 48 : 49;
        buffer[sz++] = 120;
        buffer[sz++] = 48;
        if (negative) {
            buffer[sz++] = 45;
        }
        int half = sz / 2;
        for (int i = 0; i < half; ++i) {
            char tmp = buffer[i];
            buffer[i] = buffer[sz - i - 1];
            buffer[sz - i - 1] = tmp;
        }
        buffer[sz++] = 112;
        if (exp < 0) {
            exp = -exp;
            buffer[sz++] = 45;
        }
        int pos = 1000;
        boolean first = true;
        for (int i = 0; i < 4; ++i) {
            int digit = exp / pos;
            if (digit > 0 || !first) {
                buffer[sz++] = TCharacter.forDigit(digit, 10);
                first = false;
            }
            exp %= pos;
            pos /= 10;
        }
        if (first) {
            buffer[sz++] = 48;
        }
        return new String(buffer, 0, sz);
    }
}

