/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import org.teavm.classlib.java.io.TFilterReader;
import org.teavm.classlib.java.io.TReader;
import org.teavm.classlib.java.lang.TObject;

public class TPushbackReader
extends TFilterReader {
    char[] buf;
    int pos;

    public TPushbackReader(TReader in) {
        super(in);
        this.buf = new char[1];
        this.pos = 1;
    }

    public TPushbackReader(TReader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size must be > 0");
        }
        this.buf = new char[size];
        this.pos = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        TObject tObject = this.lock;
        synchronized (tObject) {
            this.buf = null;
            this.in.close();
        }
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("Mark/Reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        TObject tObject = this.lock;
        synchronized (tObject) {
            if (this.buf == null) {
                throw new IOException("Stream is closed");
            }
            if (this.pos < this.buf.length) {
                return this.buf[this.pos++];
            }
            return this.in.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buffer, int offset, int count) throws IOException {
        TObject tObject = this.lock;
        synchronized (tObject) {
            if (null == this.buf) {
                throw new IOException("Stream is closed");
            }
            if (offset < 0 || count < 0 || offset > buffer.length - count) {
                throw new IndexOutOfBoundsException();
            }
            int copiedChars = 0;
            int copyLength = 0;
            int newOffset = offset;
            if (this.pos < this.buf.length) {
                copyLength = this.buf.length - this.pos >= count ? count : this.buf.length - this.pos;
                System.arraycopy(this.buf, this.pos, buffer, newOffset, copyLength);
                newOffset += copyLength;
                copiedChars += copyLength;
                this.pos += copyLength;
            }
            if (copyLength == count) {
                return count;
            }
            int inCopied = this.in.read(buffer, newOffset, count - copiedChars);
            if (inCopied > 0) {
                return inCopied + copiedChars;
            }
            if (copiedChars == 0) {
                return inCopied;
            }
            return copiedChars;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        TObject tObject = this.lock;
        synchronized (tObject) {
            if (this.buf == null) {
                throw new IOException("Reader is closed");
            }
            return this.buf.length - this.pos > 0 || this.in.ready();
        }
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark/Reset not supported");
    }

    public void unread(char[] buffer) throws IOException {
        this.unread(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(char[] buffer, int offset, int length) throws IOException {
        TObject tObject = this.lock;
        synchronized (tObject) {
            if (this.buf == null) {
                throw new IOException("Stream is closed");
            }
            if (length > this.pos) {
                throw new IOException("Pushback buffer full");
            }
            if (offset > buffer.length - length || offset < 0) {
                throw new ArrayIndexOutOfBoundsException("Offset out of bounds : " + offset);
            }
            if (length < 0) {
                throw new ArrayIndexOutOfBoundsException("Length out of bounds : " + length);
            }
            for (int i = offset + length - 1; i >= offset; --i) {
                this.unread(buffer[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(int oneChar) throws IOException {
        TObject tObject = this.lock;
        synchronized (tObject) {
            if (this.buf == null) {
                throw new IOException("Stream is closed");
            }
            if (this.pos == 0) {
                throw new IOException("Pushback buffer full");
            }
            this.buf[--this.pos] = (char)oneChar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long count) throws IOException {
        if (count < 0L) {
            throw new IllegalArgumentException();
        }
        TObject tObject = this.lock;
        synchronized (tObject) {
            long inSkipped;
            if (this.buf == null) {
                throw new IOException("Stream is closed");
            }
            if (count == 0L) {
                return 0L;
            }
            int availableFromBuffer = this.buf.length - this.pos;
            if (availableFromBuffer > 0) {
                long requiredFromIn = count - (long)availableFromBuffer;
                if (requiredFromIn <= 0L) {
                    this.pos = (int)((long)this.pos + count);
                    return count;
                }
                this.pos += availableFromBuffer;
                inSkipped = this.in.skip(requiredFromIn);
            } else {
                inSkipped = this.in.skip(count);
            }
            return inSkipped + (long)availableFromBuffer;
        }
    }
}

