/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.classlib.impl.unicode.CLDRTimeZone;
import org.teavm.classlib.impl.unicode.TimeZoneLocalizationBuilder;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.builders.ResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceMapBuilder;
import org.teavm.platform.metadata.builders.StringResourceBuilder;

public class TimeZoneLocalizationGenerator
implements MetadataGenerator {
    public ResourceBuilder generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        CLDRReader cldr = (CLDRReader)context.getService(CLDRReader.class);
        ResourceMapBuilder localizations = new ResourceMapBuilder();
        for (Map.Entry<String, CLDRLocale> locale : cldr.getKnownLocales().entrySet()) {
            TimeZoneLocalizationBuilder localization = new TimeZoneLocalizationBuilder();
            localizations.values.put(locale.getKey(), localization);
            for (CLDRTimeZone tz : locale.getValue().getTimeZones()) {
                ResourceMapBuilder area = (ResourceMapBuilder)localization.timeZones.values.get(tz.getArea());
                if (area == null) {
                    area = new ResourceMapBuilder();
                    localization.timeZones.values.put(tz.getArea(), area);
                }
                StringResourceBuilder name = new StringResourceBuilder();
                name.value = tz.getName();
                area.values.put(tz.getLocation(), name);
            }
        }
        return localizations;
    }
}

