/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.builders.ResourceArrayBuilder;
import org.teavm.platform.metadata.builders.ResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceMapBuilder;
import org.teavm.platform.metadata.builders.StringResourceBuilder;

public class DateSymbolsMetadataGenerator
implements MetadataGenerator {
    public ResourceBuilder generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        switch (method.getName()) {
            case "getErasMap": {
                return this.generateSymbols(context, locale -> locale.getEras());
            }
            case "getAmPmMap": {
                return this.generateSymbols(context, locale -> locale.getDayPeriods());
            }
            case "getMonthMap": {
                return this.generateSymbols(context, locale -> locale.getMonths());
            }
            case "getShortMonthMap": {
                return this.generateSymbols(context, locale -> locale.getShortMonths());
            }
            case "getWeekdayMap": {
                return this.generateSymbols(context, locale -> locale.getWeekdays());
            }
            case "getShortWeekdayMap": {
                return this.generateSymbols(context, locale -> locale.getShortWeekdays());
            }
        }
        throw new AssertionError((Object)("Unsupported method: " + String.valueOf(method)));
    }

    private ResourceBuilder generateSymbols(MetadataGeneratorContext context, ResourceExtractor extractor) {
        CLDRReader reader = (CLDRReader)context.getService(CLDRReader.class);
        ResourceMapBuilder result = new ResourceMapBuilder();
        for (Map.Entry<String, CLDRLocale> localeEntry : reader.getKnownLocales().entrySet()) {
            ResourceArrayBuilder symbolsRes = new ResourceArrayBuilder();
            result.values.put(localeEntry.getKey(), symbolsRes);
            for (String symbol : extractor.extract(localeEntry.getValue())) {
                StringResourceBuilder symbolRes = new StringResourceBuilder();
                symbolRes.value = symbol;
                symbolsRes.values.add(symbolRes);
            }
        }
        return result;
    }

    private static interface ResourceExtractor {
        public String[] extract(CLDRLocale var1);
    }
}

