/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.reflection;

import java.util.ArrayList;
import java.util.Set;
import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCReflectionProvider;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCVirtualCallGenerator;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmBlockType;
import org.teavm.backend.wasm.model.WasmEntity;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullCondition;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmSignedType;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.transformation.gc.CoroutineTransformation;
import org.teavm.classlib.impl.ReflectionDependencyListener;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.dependency.ValueDependencyInfo;
import org.teavm.interop.Address;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.runtime.Fiber;

public class WasmGCReflectionIntrinsics
implements WasmGCIntrinsic {
    private ReflectionDependencyListener reflection;
    private final Set<ValueType> typesToSkip = Set.of(ValueType.parse(Address.class), ValueType.parse(Fiber.PlatformObject.class), ValueType.parse(Fiber.PlatformFunction.class));
    private WasmFunction initReflectionFunction;

    public WasmGCReflectionIntrinsics(ReflectionDependencyListener reflection) {
        this.reflection = reflection;
    }

    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getClassName()) {
            case "org.teavm.classlib.impl.reflection.FieldInfo": {
                switch (invocation.getMethod().getName()) {
                    case "name": {
                        return this.fieldInfoCall(invocation, context, 0);
                    }
                    case "modifiers": {
                        return this.fieldInfoCall(invocation, context, 1);
                    }
                    case "accessLevel": {
                        return this.fieldInfoCall(invocation, context, 2);
                    }
                    case "type": {
                        return this.fieldInfoCall(invocation, context, 3);
                    }
                    case "reader": {
                        return this.fieldInfoCall(invocation, context, 4);
                    }
                    case "writer": {
                        return this.fieldInfoCall(invocation, context, 5);
                    }
                }
                break;
            }
            case "org.teavm.classlib.impl.reflection.FieldInfoList": {
                switch (invocation.getMethod().getName()) {
                    case "count": {
                        return new WasmArrayLength(context.generate((Expr)invocation.getArguments().get(0)));
                    }
                    case "get": {
                        WasmExpression arg = context.generate((Expr)invocation.getArguments().get(0));
                        WasmExpression index = context.generate((Expr)invocation.getArguments().get(1));
                        WasmArray arrayType = context.classInfoProvider().reflection().getReflectionFieldArrayType();
                        return new WasmArrayGet(arrayType, arg, index);
                    }
                }
                break;
            }
            case "org.teavm.classlib.impl.reflection.MethodInfo": {
                switch (invocation.getMethod().getName()) {
                    case "name": {
                        return this.methodInfoCall(invocation, context, 0);
                    }
                    case "modifiers": {
                        return this.methodInfoCall(invocation, context, 1);
                    }
                    case "accessLevel": {
                        return this.methodInfoCall(invocation, context, 2);
                    }
                    case "returnType": {
                        return this.methodInfoCall(invocation, context, 3);
                    }
                    case "parameterTypes": {
                        return this.methodInfoCall(invocation, context, 4);
                    }
                    case "caller": {
                        return this.methodInfoCall(invocation, context, 5);
                    }
                }
                break;
            }
            case "org.teavm.classlib.impl.reflection.MethodInfoList": {
                switch (invocation.getMethod().getName()) {
                    case "count": {
                        return new WasmArrayLength(context.generate((Expr)invocation.getArguments().get(0)));
                    }
                    case "get": {
                        WasmExpression arg = context.generate((Expr)invocation.getArguments().get(0));
                        WasmExpression index = context.generate((Expr)invocation.getArguments().get(1));
                        WasmArray arrayType = context.classInfoProvider().reflection().getReflectionMethodArrayType();
                        return new WasmArrayGet(arrayType, arg, index);
                    }
                }
                break;
            }
            case "org.teavm.classlib.impl.reflection.ClassList": {
                switch (invocation.getMethod().getName()) {
                    case "count": {
                        return new WasmArrayLength(context.generate((Expr)invocation.getArguments().get(0)));
                    }
                    case "get": {
                        WasmExpression arg = context.generate((Expr)invocation.getArguments().get(0));
                        WasmExpression index = context.generate((Expr)invocation.getArguments().get(1));
                        WasmArray arrayType = context.classInfoProvider().reflection().getClassArrayType();
                        return new WasmArrayGet(arrayType, arg, index);
                    }
                }
                break;
            }
            case "org.teavm.classlib.impl.reflection.FieldReader": {
                WasmExpression fn = context.generate((Expr)invocation.getArguments().get(0));
                WasmExpression arg = context.generate((Expr)invocation.getArguments().get(1));
                WasmType.CompositeReference objectType = context.classInfoProvider().getClassInfo("java.lang.Object").getType();
                WasmFunctionType type = context.functionTypes().of((WasmType)objectType, new WasmType[]{objectType});
                return new WasmCallReference(fn, type, new WasmExpression[]{arg});
            }
            case "org.teavm.classlib.impl.reflection.FieldWriter": {
                WasmExpression fn = context.generate((Expr)invocation.getArguments().get(0));
                WasmExpression arg = context.generate((Expr)invocation.getArguments().get(1));
                WasmExpression value = context.generate((Expr)invocation.getArguments().get(2));
                WasmType.CompositeReference objectType = context.classInfoProvider().getClassInfo("java.lang.Object").getType();
                WasmFunctionType type = context.functionTypes().of(null, new WasmType[]{objectType, objectType});
                return new WasmCallReference(fn, type, new WasmExpression[]{arg, value});
            }
            case "org.teavm.classlib.impl.reflection.MethodCaller": {
                WasmExpression fn = context.generate((Expr)invocation.getArguments().get(0));
                WasmExpression instanceArg = context.generate((Expr)invocation.getArguments().get(1));
                WasmExpression paramsArg = context.generate((Expr)invocation.getArguments().get(2));
                WasmType.CompositeReference objectType = context.classInfoProvider().getClassInfo("java.lang.Object").getType();
                WasmType.CompositeReference objArrayType = context.classInfoProvider().getClassInfo((ValueType)ValueType.arrayOf((ValueType)ValueType.object((String)"java.lang.Object"))).getType();
                WasmFunctionType type = context.functionTypes().of((WasmType)objectType, new WasmType[]{objectType, objArrayType});
                return new WasmCallReference(fn, type, new WasmExpression[]{instanceArg, paramsArg});
            }
            case "java.lang.Class": {
                switch (invocation.getMethod().getName()) {
                    case "createMetadata": {
                        return new WasmCall(this.getInitReflectionFunction(context));
                    }
                    case "newInstanceImpl": {
                        WasmGCClassInfo classClass = context.classInfoProvider().getClassInfo("java.lang.Class");
                        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
                        WasmFunctionType functionType = context.functionTypes().of((WasmType)objectClass.getType(), new WasmType[0]);
                        WasmExpression arg = context.generate((Expr)invocation.getArguments().get(0));
                        WasmStructGet instantiator = new WasmStructGet(classClass.getStructure(), arg, context.classInfoProvider().getClassInstantiatorOffset());
                        WasmBlock outerBlock = new WasmBlock(false);
                        outerBlock.setType((WasmBlockType)objectClass.getType().asBlock());
                        WasmBlock innerBlock = new WasmBlock(false);
                        innerBlock.setType((WasmBlockType)functionType.getReference().asBlock());
                        WasmNullBranch nullBranch = new WasmNullBranch(WasmNullCondition.NOT_NULL, (WasmExpression)instantiator, innerBlock);
                        innerBlock.getBody().add(nullBranch);
                        WasmBreak br = new WasmBreak(outerBlock);
                        br.setResult((WasmExpression)new WasmNullConstant((WasmType.Reference)objectClass.getType()));
                        innerBlock.getBody().add(br);
                        WasmCallReference call = new WasmCallReference((WasmExpression)innerBlock, functionType);
                        outerBlock.getBody().add(call);
                        call.setSuspensionPoint(context.isAsync());
                        return outerBlock;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    private WasmExpression fieldInfoCall(InvocationExpr invocation, WasmGCIntrinsicContext context, int fieldIndex) {
        WasmExpression arg = context.generate((Expr)invocation.getArguments().get(0));
        return new WasmStructGet(context.classInfoProvider().reflection().getReflectionFieldType(), arg, fieldIndex);
    }

    private WasmExpression methodInfoCall(InvocationExpr invocation, WasmGCIntrinsicContext context, int fieldIndex) {
        WasmExpression arg = context.generate((Expr)invocation.getArguments().get(0));
        return new WasmStructGet(context.classInfoProvider().reflection().getReflectionMethodType(), arg, fieldIndex);
    }

    private WasmFunction getInitReflectionFunction(WasmGCIntrinsicContext context) {
        if (this.initReflectionFunction == null) {
            this.initReflectionFunction = new WasmFunction(context.functionTypes().of(null, new WasmType[0]));
            this.initReflectionFunction.setName(context.names().topLevel("@teavm.initReflection"));
            context.module().functions.add((WasmEntity)this.initReflectionFunction);
            this.initReflectionFields(context, this.initReflectionFunction);
            this.initReflectionMethods(context, this.initReflectionFunction);
            this.initReflectionInstantiator(context, this.initReflectionFunction);
        }
        return this.initReflectionFunction;
    }

    private void initReflectionFields(WasmGCIntrinsicContext context, WasmFunction function) {
        WasmGCReflectionProvider wasmGcReflection = context.classInfoProvider().reflection();
        WasmGCClassInfo classClass = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        for (String className : this.reflection.getClassesWithReflectableFields()) {
            ClassReader cls = context.hierarchy().getClassSource().get(className);
            if (cls == null || cls.getFields().isEmpty()) continue;
            boolean skipPrivates = ReflectionDependencyListener.shouldSkipPrivates(cls);
            WasmArrayNewFixed array = new WasmArrayNewFixed(wasmGcReflection.getReflectionFieldArrayType());
            WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(className);
            function.getBody().add(new WasmStructSet(classClass.getStructure(), (WasmExpression)new WasmGetGlobal(classInfo.getPointer()), context.classInfoProvider().getClassFieldsOffset(), (WasmExpression)array));
            Set<String> accessibleFields = this.reflection.getAccessibleFields(className);
            for (FieldReader field : cls.getFields()) {
                if (skipPrivates && (field.getLevel() == AccessLevel.PRIVATE || field.getLevel() == AccessLevel.PACKAGE_PRIVATE)) continue;
                WasmStructNew fieldInit = new WasmStructNew(wasmGcReflection.getReflectionFieldType());
                array.getElements().add(fieldInit);
                WasmGCStringConstant nameStr = context.strings().getStringConstant(field.getName());
                fieldInit.getInitializers().add(new WasmGetGlobal(nameStr.global));
                fieldInit.getInitializers().add(new WasmInt32Constant(ElementModifier.pack((Set)field.readModifiers())));
                fieldInit.getInitializers().add(new WasmInt32Constant(field.getLevel().ordinal()));
                fieldInit.getInitializers().add(this.renderType(context, field.getType()));
                if (accessibleFields != null && accessibleFields.contains(field.getName()) && this.reflection.isGetReached() && this.reflection.isRead(field.getReference())) {
                    WasmFunction getter = this.generateGetter(context, field);
                    fieldInit.getInitializers().add(new WasmFunctionReference(getter));
                } else {
                    WasmFunctionType getterType = context.functionTypes().of((WasmType)objectClass.getType(), new WasmType[]{objectClass.getType()});
                    fieldInit.getInitializers().add(new WasmNullConstant((WasmType.Reference)getterType.getReference()));
                }
                if (accessibleFields != null && accessibleFields.contains(field.getName()) && this.reflection.isSetReached() && this.reflection.isWritten(field.getReference())) {
                    WasmFunction setter = this.generateSetter(context, field);
                    fieldInit.getInitializers().add(new WasmFunctionReference(setter));
                    continue;
                }
                WasmFunctionType setterType = context.functionTypes().of(null, new WasmType[]{objectClass.getType(), objectClass.getType()});
                fieldInit.getInitializers().add(new WasmNullConstant((WasmType.Reference)setterType.getReference()));
            }
        }
    }

    private void initReflectionMethods(WasmGCIntrinsicContext context, WasmFunction function) {
        WasmGCReflectionProvider wasmGcReflection = context.classInfoProvider().reflection();
        WasmGCClassInfo classClass = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        WasmGCClassInfo objectArrayClass = context.classInfoProvider().getClassInfo((ValueType)ValueType.arrayOf((ValueType)ValueType.object((String)"java.lang.Object")));
        WasmFunctionType callerType = context.functionTypes().of((WasmType)objectClass.getType(), new WasmType[]{objectClass.getType(), objectArrayClass.getType()});
        for (String className : this.reflection.getClassesWithReflectableMethods()) {
            ClassReader cls = context.hierarchy().getClassSource().get(className);
            if (cls == null || cls.getMethods().isEmpty()) continue;
            boolean skipPrivates = ReflectionDependencyListener.shouldSkipPrivates(cls);
            WasmArrayNewFixed array = new WasmArrayNewFixed(wasmGcReflection.getReflectionMethodArrayType());
            WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(className);
            function.getBody().add(new WasmStructSet(classClass.getStructure(), (WasmExpression)new WasmGetGlobal(classInfo.getPointer()), context.classInfoProvider().getClassMethodsOffset(), (WasmExpression)array));
            Set<MethodDescriptor> accessibleMethods = this.reflection.getAccessibleMethods(className);
            for (MethodReader method : cls.getMethods()) {
                if (skipPrivates && (method.getLevel() == AccessLevel.PRIVATE || method.getLevel() == AccessLevel.PACKAGE_PRIVATE) || method.getName().equals("<clinit>")) continue;
                WasmStructNew methodInit = new WasmStructNew(wasmGcReflection.getReflectionMethodType());
                array.getElements().add(methodInit);
                WasmGCStringConstant nameStr = context.strings().getStringConstant(method.getName());
                methodInit.getInitializers().add(new WasmGetGlobal(nameStr.global));
                methodInit.getInitializers().add(new WasmInt32Constant(ElementModifier.pack((Set)method.readModifiers())));
                methodInit.getInitializers().add(new WasmInt32Constant(method.getLevel().ordinal()));
                methodInit.getInitializers().add(this.renderType(context, method.getResultType()));
                WasmArrayNewFixed parametersArray = new WasmArrayNewFixed(wasmGcReflection.getClassArrayType());
                for (ValueType param : method.getParameterTypes()) {
                    parametersArray.getElements().add(this.renderType(context, param));
                }
                methodInit.getInitializers().add(parametersArray);
                if (accessibleMethods != null && accessibleMethods.contains(method.getDescriptor()) && this.reflection.isCallReached() && this.reflection.isCalled(method.getReference())) {
                    WasmFunction caller = this.generateCaller(context, method);
                    methodInit.getInitializers().add(new WasmFunctionReference(caller));
                    continue;
                }
                methodInit.getInitializers().add(new WasmNullConstant((WasmType.Reference)callerType.getReference()));
            }
        }
    }

    private void initReflectionInstantiator(WasmGCIntrinsicContext context, WasmFunction function) {
        MethodDependencyInfo dep = context.dependency().getMethod(new MethodReference(Class.class, "newInstance", new Class[]{Object.class}));
        if (dep == null || !dep.isUsed()) {
            return;
        }
        ValueDependencyInfo node = dep.getVariable(0).getClassValueNode();
        if (node == null) {
            return;
        }
        WasmGCClassInfo classClass = context.classInfoProvider().getClassInfo("java.lang.Class");
        for (ValueType type : node.getTypes()) {
            WasmGCClassInfo classInfo;
            MethodReader method;
            ClassReader cls;
            if (!(type instanceof ValueType.Object) || this.typesToSkip.contains(type) || (cls = context.hierarchy().getClassSource().get(((ValueType.Object)type).getClassName())) == null || cls.hasModifier(ElementModifier.ABSTRACT) || (method = cls.getMethod(new MethodDescriptor("<init>", new Class[]{Void.TYPE}))) == null || method.getProgram() == null && !method.hasModifier(ElementModifier.NATIVE) || (classInfo = context.classInfoProvider().getClassInfo(cls.getName())).getStructure() == null) continue;
            WasmFunction instantiator = this.generateInstantiator(context, method);
            function.getBody().add(new WasmStructSet(classClass.getStructure(), (WasmExpression)new WasmGetGlobal(classInfo.getPointer()), context.classInfoProvider().getClassInstantiatorOffset(), (WasmExpression)new WasmFunctionReference(instantiator)));
        }
    }

    private WasmFunction generateGetter(WasmGCIntrinsicContext context, FieldReader field) {
        WasmGetGlobal result;
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        WasmFunctionType getterType = context.functionTypes().of((WasmType)objectClass.getType(), new WasmType[]{objectClass.getType()});
        WasmFunction function = new WasmFunction(getterType);
        function.setName(context.names().topLevel(context.names().suggestForStaticField(field.getReference()) + "@getter"));
        context.module().functions.add((WasmEntity)function);
        function.setReferenced(true);
        WasmLocal thisVar = new WasmLocal((WasmType)objectClass.getType(), "this");
        function.add(thisVar);
        WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(field.getOwnerName());
        if (field.hasModifier(ElementModifier.STATIC)) {
            if (context.classInitInfo().isDynamicInitializer(field.getOwnerName()) && classInfo.getInitializerPointer() != null) {
                WasmGetGlobal initRef = new WasmGetGlobal(classInfo.getInitializerPointer());
                WasmFunctionType initType = context.functionTypes().of(null, new WasmType[0]);
                function.getBody().add(new WasmCallReference((WasmExpression)initRef, initType));
            }
            WasmGlobal global = context.classInfoProvider().getStaticFieldLocation(field.getReference());
            result = new WasmGetGlobal(global);
        } else {
            WasmCast castInstance = new WasmCast((WasmExpression)new WasmGetLocal(thisVar), (WasmType.Reference)classInfo.getType());
            WasmStructGet structGet = new WasmStructGet(classInfo.getStructure(), (WasmExpression)castInstance, context.classInfoProvider().getFieldIndex(field.getReference()));
            if (field.getType() instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)field.getType()).getKind()) {
                    case BYTE: 
                    case SHORT: {
                        structGet.setSignedType(WasmSignedType.SIGNED);
                        break;
                    }
                    case BOOLEAN: 
                    case CHARACTER: {
                        structGet.setSignedType(WasmSignedType.UNSIGNED);
                        break;
                    }
                }
            }
            result = structGet;
        }
        function.getBody().add(this.boxIfNecessary(context, (WasmExpression)result, field.getType()));
        return function;
    }

    private WasmFunction generateSetter(WasmGCIntrinsicContext context, FieldReader field) {
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        WasmFunctionType setterType = context.functionTypes().of(null, new WasmType[]{objectClass.getType(), objectClass.getType()});
        WasmFunction function = new WasmFunction(setterType);
        function.setName(context.names().topLevel(context.names().suggestForStaticField(field.getReference()) + "@setter"));
        context.module().functions.add((WasmEntity)function);
        function.setReferenced(true);
        WasmLocal thisVar = new WasmLocal((WasmType)objectClass.getType(), "this");
        function.add(thisVar);
        WasmLocal valueVar = new WasmLocal((WasmType)objectClass.getType(), "value");
        function.add(valueVar);
        WasmExpression value = this.unboxIfNecessary(context, (WasmExpression)new WasmGetLocal(valueVar), field.getType());
        WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(field.getOwnerName());
        if (field.hasModifier(ElementModifier.STATIC)) {
            this.initClass(context, classInfo, field.getOwnerName(), function);
            WasmGlobal global = context.classInfoProvider().getStaticFieldLocation(field.getReference());
            function.getBody().add(new WasmSetGlobal(global, value));
        } else {
            WasmCast castInstance = new WasmCast((WasmExpression)new WasmGetLocal(thisVar), (WasmType.Reference)classInfo.getType());
            WasmStructSet structSet = new WasmStructSet(classInfo.getStructure(), (WasmExpression)castInstance, context.classInfoProvider().getFieldIndex(field.getReference()), value);
            function.getBody().add(structSet);
        }
        return function;
    }

    private WasmFunction generateCaller(WasmGCIntrinsicContext context, MethodReader method) {
        WasmCall call;
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        WasmGCClassInfo objectArrayClass = context.classInfoProvider().getClassInfo((ValueType)ValueType.arrayOf((ValueType)ValueType.object((String)"java.lang.Object")));
        WasmFunctionType callerType = context.functionTypes().of((WasmType)objectClass.getType(), new WasmType[]{objectClass.getType(), objectArrayClass.getType()});
        WasmFunction function = new WasmFunction(callerType);
        function.setName(context.names().topLevel(context.names().suggestForMethod(method.getReference()) + "@caller"));
        context.module().functions.add((WasmEntity)function);
        function.setReferenced(true);
        WasmField dataField = (WasmField)objectArrayClass.getStructure().getFields().get(2);
        WasmLocal thisVar = new WasmLocal((WasmType)objectClass.getType(), "this");
        function.add(thisVar);
        WasmLocal argsVar = new WasmLocal((WasmType)objectArrayClass.getType(), "args");
        function.add(argsVar);
        WasmLocal argsDataVar = new WasmLocal(dataField.getUnpackedType(), "argsData");
        function.add(argsDataVar);
        WasmLocal instanceVar = null;
        function.getBody().add(new WasmSetLocal(argsDataVar, (WasmExpression)new WasmStructGet(objectArrayClass.getStructure(), (WasmExpression)new WasmGetLocal(argsVar), dataField.getIndex())));
        WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(method.getOwnerName());
        ArrayList<Object> args = new ArrayList<Object>();
        WasmFunction callee = null;
        boolean virtual = false;
        if (method.hasModifier(ElementModifier.STATIC)) {
            this.initClass(context, classInfo, method.getOwnerName(), function);
            callee = context.functions().forStaticMethod(method.getReference());
        } else {
            if (method.getName().equals("<init>")) {
                instanceVar = new WasmLocal((WasmType)classInfo.getStructure().getNonNullReference(), "instance");
                function.add(instanceVar);
                function.getBody().add(new WasmSetLocal(instanceVar, (WasmExpression)new WasmStructNewDefault(classInfo.getStructure())));
                function.getBody().add(new WasmStructSet(classInfo.getStructure(), (WasmExpression)new WasmGetLocal(instanceVar), 0, (WasmExpression)new WasmGetGlobal(classInfo.getVirtualTablePointer())));
                args.add(new WasmGetLocal(instanceVar));
            } else {
                boolean bl = virtual = !method.hasModifier(ElementModifier.FINAL) && method.getLevel() != AccessLevel.PRIVATE;
                if (!virtual) {
                    WasmCast castInstance = new WasmCast((WasmExpression)new WasmGetLocal(thisVar), (WasmType.Reference)classInfo.getType());
                    args.add(castInstance);
                }
            }
            if (!virtual) {
                callee = context.functions().forInstanceMethod(method.getReference());
            }
        }
        WasmType.CompositeReference dataType = (WasmType.CompositeReference)dataField.getUnpackedType();
        WasmArray dataArray = (WasmArray)dataType.composite;
        for (int i = 0; i < method.parameterCount(); ++i) {
            WasmArrayGet rawArg = new WasmArrayGet(dataArray, (WasmExpression)new WasmGetLocal(argsDataVar), (WasmExpression)new WasmInt32Constant(i));
            args.add(this.unboxIfNecessary(context, (WasmExpression)rawArg, method.parameterType(i)));
        }
        if (virtual) {
            WasmGCVirtualCallGenerator callGen = new WasmGCVirtualCallGenerator(context.virtualTables(), context.classInfoProvider());
            call = callGen.generate(method.getReference(), false, thisVar, args);
        } else {
            call = new WasmCall(callee, args.toArray(new WasmExpression[0]));
        }
        function.getBody().add(this.boxIfNecessary(context, (WasmExpression)call, method.getResultType()));
        if (method.getResultType() == ValueType.VOID) {
            if (method.getName().equals("<init>")) {
                function.getBody().add(new WasmGetLocal(instanceVar));
            } else {
                function.getBody().add(new WasmNullConstant((WasmType.Reference)objectClass.getType()));
            }
        }
        return function;
    }

    private WasmFunction generateInstantiator(WasmGCIntrinsicContext context, MethodReader method) {
        String className = method.getOwnerName();
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        WasmFunctionType instantiatorType = context.functionTypes().of((WasmType)objectClass.getType(), new WasmType[0]);
        WasmFunction instantiator = new WasmFunction(instantiatorType);
        instantiator.setName(context.names().topLevel(className + "@instantiate"));
        instantiator.setReferenced(true);
        context.module().functions.add((WasmEntity)instantiator);
        WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(className);
        WasmLocal localVar = new WasmLocal((WasmType)classInfo.getType(), "instance");
        instantiator.add(localVar);
        this.initClass(context, classInfo, method.getOwnerName(), instantiator);
        instantiator.getBody().add(new WasmSetLocal(localVar, (WasmExpression)new WasmStructNewDefault(classInfo.getStructure())));
        instantiator.getBody().add(new WasmStructSet(objectClass.getStructure(), (WasmExpression)new WasmGetLocal(localVar), 0, (WasmExpression)new WasmGetGlobal(classInfo.getVirtualTablePointer())));
        WasmCall call = new WasmCall(context.functions().forInstanceMethod(method.getReference()), new WasmExpression[]{new WasmGetLocal(localVar)});
        instantiator.getBody().add(call);
        instantiator.getBody().add(new WasmGetLocal(localVar));
        if (context.isAsyncMethod(method.getReference())) {
            call.setSuspensionPoint(true);
            CoroutineTransformation transformation = new CoroutineTransformation(context.functionTypes(), context.functions(), context.classInfoProvider());
            transformation.transform(instantiator);
        }
        return instantiator;
    }

    private void initClass(WasmGCIntrinsicContext context, WasmGCClassInfo classInfo, String className, WasmFunction function) {
        if (context.classInitInfo().isDynamicInitializer(className) && classInfo.getInitializerPointer() != null) {
            WasmGetGlobal initRef = new WasmGetGlobal(classInfo.getInitializerPointer());
            WasmFunctionType initType = context.functionTypes().of(null, new WasmType[0]);
            function.getBody().add(new WasmCallReference((WasmExpression)initRef, initType));
        }
    }

    private WasmExpression boxIfNecessary(WasmGCIntrinsicContext context, WasmExpression expr, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.box(context, Boolean.class, type, expr);
                }
                case BYTE: {
                    return this.box(context, Byte.class, type, expr);
                }
                case SHORT: {
                    return this.box(context, Short.class, type, expr);
                }
                case CHARACTER: {
                    return this.box(context, Character.class, type, expr);
                }
                case INTEGER: {
                    return this.box(context, Integer.class, type, expr);
                }
                case LONG: {
                    return this.box(context, Long.class, type, expr);
                }
                case FLOAT: {
                    return this.box(context, Float.class, type, expr);
                }
                case DOUBLE: {
                    return this.box(context, Double.class, type, expr);
                }
            }
        }
        return expr;
    }

    private WasmExpression box(WasmGCIntrinsicContext context, Class<?> wrapperType, ValueType sourceType, WasmExpression expr) {
        MethodReference method = new MethodReference(wrapperType.getName(), "valueOf", new ValueType[]{sourceType, ValueType.object((String)wrapperType.getName())});
        WasmFunction function = context.functions().forStaticMethod(method);
        return new WasmCall(function, new WasmExpression[]{expr});
    }

    private WasmExpression unboxIfNecessary(WasmGCIntrinsicContext context, WasmExpression expr, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.unbox(context, Boolean.TYPE, Boolean.class, expr);
                }
                case BYTE: {
                    return this.unbox(context, Byte.TYPE, Byte.class, expr);
                }
                case SHORT: {
                    return this.unbox(context, Short.TYPE, Short.class, expr);
                }
                case CHARACTER: {
                    return this.unbox(context, Character.TYPE, Character.class, expr);
                }
                case INTEGER: {
                    return this.unbox(context, Integer.TYPE, Integer.class, expr);
                }
                case LONG: {
                    return this.unbox(context, Long.TYPE, Long.class, expr);
                }
                case FLOAT: {
                    return this.unbox(context, Float.TYPE, Float.class, expr);
                }
                case DOUBLE: {
                    return this.unbox(context, Double.TYPE, Double.class, expr);
                }
            }
        } else if (type instanceof ValueType.Object && ((ValueType.Object)type).getClassName().equals("java.lang.Object")) {
            return expr;
        }
        WasmType targetType = context.typeMapper().mapType(type);
        if (targetType == context.typeMapper().mapType((ValueType)ValueType.object((String)"java.lang.Object"))) {
            return expr;
        }
        return new WasmCast(expr, (WasmType.Reference)targetType);
    }

    private WasmExpression unbox(WasmGCIntrinsicContext context, Class<?> primitiveType, Class<?> wrapperType, WasmExpression expr) {
        MethodReference method = new MethodReference(wrapperType.getName(), primitiveType.getName() + "Value", new ValueType[]{ValueType.parse(primitiveType)});
        WasmFunction function = context.functions().forInstanceMethod(method);
        WasmCast cast = new WasmCast(expr, (WasmType.Reference)context.classInfoProvider().getClassInfo(wrapperType.getName()).getType());
        return new WasmCall(function, new WasmExpression[]{cast});
    }

    private WasmExpression renderType(WasmGCIntrinsicContext context, ValueType type) {
        ValueType itemType;
        if (type instanceof ValueType.Array && !((itemType = ((ValueType.Array)type).getItemType()) instanceof ValueType.Primitive)) {
            int degree = 0;
            while (type instanceof ValueType.Array) {
                type = ((ValueType.Array)type).getItemType();
                ++degree;
            }
            WasmGetGlobal result = new WasmGetGlobal(context.classInfoProvider().getClassInfo(type).getPointer());
            while (degree-- > 0) {
                result = new WasmCall(context.classInfoProvider().getGetArrayClassFunction(), new WasmExpression[]{result});
            }
            return result;
        }
        WasmGCClassInfo classConstant = context.classInfoProvider().getClassInfo(type);
        return new WasmGetGlobal(classConstant.getPointer());
    }
}

