/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.metaprogramming.Meta;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.Resource;
import org.teavm.metaprogramming.Value;
import org.teavm.metaprogramming.reflect.ReflectMethod;

@CompileTime
public class ResourceBundleImpl {
    private ResourceBundleImpl() {
    }

    @Meta
    public static native Map<String, Supplier<ResourceBundle>> createBundleMap(boolean var0);

    private static void createBundleMap(Value<Boolean> b) throws IOException {
        Iterator resources = Metaprogramming.getResources((String)"META-INF/services/java.util.ResourceBundle");
        LinkedHashSet<String> implementations = new LinkedHashSet<String>();
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.open(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    implementations.add(line);
                }
            }
        }
        Value result = Metaprogramming.emit(() -> new HashMap());
        for (String implementation : implementations) {
            Value lazyResource;
            ReflectClass cls = Metaprogramming.findClass((String)implementation);
            if (cls != null) {
                ReflectMethod constructor = cls.getMethod("<init>", new ReflectClass[0]);
                if (constructor == null) continue;
                lazyResource = Metaprogramming.lazy(() -> (ResourceBundle)constructor.construct(new Object[0]));
            } else {
                String path = implementation.replace('.', '/');
                Iterator iter = Metaprogramming.getResources((String)(path + ".properties"));
                if (!iter.hasNext()) continue;
                lazyResource = Metaprogramming.lazyFragment(() -> {
                    Properties properties = new Properties();
                    try (InputStream input = ((Resource)iter.next()).open();){
                        properties.load(input);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return Metaprogramming.proxy(ListResourceBundle.class, (instance, methodName, args) -> {
                        Value contentsBuilder = Metaprogramming.emit(() -> new ArrayList());
                        for (Object propertyName : properties.keySet()) {
                            String key;
                            String value;
                            if (!(propertyName instanceof String) || (value = properties.getProperty(key = (String)propertyName)) == null) continue;
                            Metaprogramming.emit(() -> ((List)contentsBuilder.get()).add(new Object[]{key, value}));
                        }
                        Metaprogramming.exit(() -> ((List)contentsBuilder.get()).toArray((T[])new Object[0][]));
                    });
                });
            }
            Value supplierValueRaw = Metaprogramming.proxy(Supplier.class, (instance, methodName, args) -> Metaprogramming.exit(() -> lazyResource.get()));
            Value supplierValue = Metaprogramming.emit(() -> (Supplier)supplierValueRaw.get());
            Metaprogramming.emit(() -> ((Map)result.get()).put(implementation, (Supplier)supplierValue.get()));
        }
        Metaprogramming.exit(() -> result.get());
    }
}

